/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.views;

import java.sql.SQLException;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.orm.BasicMapping;
import org.eclipse.dali.orm.FetchTypeDefaultEager;
import org.eclipse.dali.orm.Optional;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.Temporal;
import org.eclipse.dali.orm.TemporalType;
import org.eclipse.dali.orm.provider.BasicMappingItemProvider;
import org.eclipse.dali.orm.provider.OrmItemProviderAdapterFactory;
import org.eclipse.dali.orm.provider.TemporalItemProvider;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.views.ColumnComposite;
import org.eclipse.dali.ui.views.IMappingCompositeBuilder;
import org.eclipse.dali.ui.views.IPersistenceComposite;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class BasicMappingComposite
extends Composite
implements IPersistenceComposite {
    BasicMapping basicMapping;
    private EditingDomain editingDomain;
    private OrmItemProviderAdapterFactory adapterFactory;
    private BasicMappingItemProvider mappingItemProvider;
    private TemporalItemProvider temporalItemProvider;
    private ColumnComposite columnComposite;
    private ComboViewer fetchTypeComboViewer;
    private ComboViewer optionalComboViewer;
    private Button temporalCheckBox;
    private ComboViewer temporalTypeComboViewer;
    private INotifyChangedListener mappingListener;
    private INotifyChangedListener temporalListener;
    private ConnectionListener connectionListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    BasicMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
        super(parent, 0);
        this.editingDomain = editingDomain;
        this.adapterFactory = adapterFactory;
        this.initialize();
        this.initializeLayout();
    }

    private void initialize() {
        this.mappingItemProvider = (BasicMappingItemProvider)this.adapterFactory.createBasicMappingAdapter();
        this.temporalItemProvider = (TemporalItemProvider)this.adapterFactory.createTemporalAdapter();
    }

    private void initializeLayout() {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.columnComposite = new ColumnComposite(this, this.editingDomain, this.adapterFactory, "org.eclipse.dali.ui.mapping_column");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnComposite.setLayoutData(gridData);
        Label fetchTypeLabel = new Label((Composite)this, 16384);
        fetchTypeLabel.setText(DaliUiMessages.BasicMappingComposite_fetchType);
        this.fetchTypeComboViewer = this.buildFetchTypeCombo(this);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fetchTypeComboViewer.getCombo().setLayoutData((Object)gridData);
        helpSystem.setHelp((Control)this.fetchTypeComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_fetchType");
        Label optionalLabel = new Label((Composite)this, 16384);
        optionalLabel.setText(DaliUiMessages.BasicMappingComposite_optional);
        this.optionalComboViewer = this.buildOptionalCombo(this);
        this.optionalComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.optionalComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_optional");
        this.temporalCheckBox = this.buildTemporalCheckBox(this);
        this.temporalTypeComboViewer = this.buildTemporalCombo(this);
        this.temporalTypeComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        helpSystem.setHelp((Control)this.temporalTypeComboViewer.getCombo(), "org.eclipse.dali.ui.mapping_temporal");
    }

    private ComboViewer buildFetchTypeCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(FetchTypeDefaultEager.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BasicMappingComposite.this.fetchTypeSelectionChanged(event.getSelection());
            }
        });
        return viewer;
    }

    void fetchTypeSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            FetchTypeDefaultEager fetchType = (FetchTypeDefaultEager)((IStructuredSelection)selection).getFirstElement();
            if (!this.basicMapping.getFetchType().equals(fetchType)) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.basicMapping, (Object)OrmPackage.eINSTANCE.getBasicMapping_FetchType(), (Object)fetchType));
            }
        }
    }

    private ComboViewer buildOptionalCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(Optional.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BasicMappingComposite.this.optionalSelectionChanged(event.getSelection());
            }
        });
        return viewer;
    }

    void optionalSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Optional optional = (Optional)((IStructuredSelection)selection).getFirstElement();
            if (!this.basicMapping.getOptional().equals(optional)) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.basicMapping, (Object)OrmPackage.eINSTANCE.getBasicMapping_Optional(), (Object)optional));
            }
        }
    }

    private Button buildTemporalCheckBox(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText(DaliUiMessages.BasicMappingComposite_temporal);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BasicMappingComposite.this.temporalCheckBoxClicked(e);
            }
        });
        return button;
    }

    void temporalCheckBoxClicked(SelectionEvent e) {
        boolean mappingHasTemporal = this.basicMapping.getTemporal() != null;
        boolean checked = this.temporalCheckBox.getSelection();
        if (checked == mappingHasTemporal) {
            return;
        }
        Temporal temporal = null;
        if (checked) {
            temporal = this.basicMapping.getBasicMappingModelAdapter().createTemporalModelAdapter(null).getTemporal();
        }
        this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)this.basicMapping, (Object)OrmPackage.eINSTANCE.getBasicMapping_Temporal(), (Object)temporal));
    }

    private ComboViewer buildTemporalCombo(Composite parent) {
        ComboViewer viewer = new ComboViewer(parent, 8);
        viewer.add(TemporalType.VALUES.toArray());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BasicMappingComposite.this.temporalTypeSelectionChanged(event.getSelection());
            }
        });
        return viewer;
    }

    void temporalTypeSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            TemporalType sel = (TemporalType)((IStructuredSelection)selection).getFirstElement();
            TemporalType tt = null;
            Temporal temporal = this.basicMapping.getTemporal();
            if (temporal != null) {
                tt = temporal.getType();
            }
            if (temporal != null && tt != sel) {
                this.editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)this.editingDomain, (Object)temporal, (Object)OrmPackage.eINSTANCE.getTemporal_Type(), (Object)sel));
            }
        }
    }

    public void populate(EObject model) {
        Optional optional;
        Temporal temporal;
        if (this.basicMapping != null) {
            temporal = this.basicMapping.getTemporal();
            if (temporal != null) {
                temporal.eAdapters().remove((Object)this.temporalItemProvider);
                this.temporalItemProvider.removeListener(this.getTemporalListener());
            }
            this.basicMapping.eAdapters().remove((Object)this.mappingItemProvider);
            this.mappingItemProvider.removeListener(this.getMappingListener());
        }
        if (model == null) {
            this.basicMapping = null;
            this.columnComposite.populate(null);
            return;
        }
        this.basicMapping = (BasicMapping)((PersistentAttribute)model).getAttributeMapping();
        this.mappingItemProvider.addListener(this.getMappingListener());
        this.basicMapping.eAdapters().add((Object)this.mappingItemProvider);
        temporal = this.basicMapping.getTemporal();
        if (temporal != null) {
            this.temporalItemProvider.addListener(this.getTemporalListener());
            temporal.eAdapters().add((Object)this.temporalItemProvider);
        }
        if (this.basicMapping.getFetchType() == FetchTypeDefaultEager.DEFAULT_LITERAL) {
            if (((IStructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchTypeDefaultEager.DEFAULT_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchTypeDefaultEager.DEFAULT_LITERAL));
            }
        } else if (this.basicMapping.getFetchType() == FetchTypeDefaultEager.EAGER_LITERAL) {
            if (((IStructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchTypeDefaultEager.EAGER_LITERAL) {
                this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchTypeDefaultEager.EAGER_LITERAL));
            }
        } else if (((IStructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != FetchTypeDefaultEager.LAZY_LITERAL) {
            this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)FetchTypeDefaultEager.LAZY_LITERAL));
        }
        if ((optional = this.basicMapping.getOptional()) != ((IStructuredSelection)this.optionalComboViewer.getSelection()).getFirstElement()) {
            this.optionalComboViewer.setSelection((ISelection)new StructuredSelection((Object)optional));
        }
        this.populateColumnCombo();
        if (temporal == null) {
            this.temporalCheckBox.setSelection(false);
            this.temporalTypeComboViewer.getCombo().setEnabled(false);
        } else {
            this.temporalCheckBox.setSelection(true);
            this.temporalTypeComboViewer.getCombo().setEnabled(true);
            this.setTemporalTypeSelection(temporal.getType());
        }
    }

    void setTemporalTypeSelection(TemporalType temporalType) {
        if (temporalType != ((IStructuredSelection)this.temporalTypeComboViewer.getSelection()).getFirstElement()) {
            this.temporalTypeComboViewer.setSelection((ISelection)this.buildStructuredSelection(temporalType));
        }
    }

    private IStructuredSelection buildStructuredSelection(TemporalType temporalType) {
        return temporalType == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)temporalType);
    }

    void populateColumnCombo() {
        this.addConnectionListener();
        if (this.basicMapping == null) {
            this.columnComposite.populate(null);
        } else {
            this.columnComposite.populate((EObject)this.basicMapping.getColumn());
        }
    }

    private INotifyChangedListener getMappingListener() {
        if (this.mappingListener == null) {
            this.mappingListener = this.buildMappingListener();
        }
        return this.mappingListener;
    }

    private INotifyChangedListener buildMappingListener() {
        return new INotifyChangedListener(){

            public void notifyChanged(Notification notification) {
                if (((ViewerNotification)notification).getElement() instanceof BasicMapping) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.dali.orm.BasicMapping");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    switch (notification.getFeatureID((Class)clazz)) {
                        case 2: {
                            FetchTypeDefaultEager fetchType = (FetchTypeDefaultEager)notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(this, fetchType){
                                final /* synthetic */ 5 this$1;
                                private final /* synthetic */ FetchTypeDefaultEager val$fetchType;
                                {
                                    this.this$1 = var1_1;
                                    this.val$fetchType = fetchTypeDefaultEager;
                                }

                                public void run() {
                                    5.access$0(this.this$1).fetchTypeChanged(this.val$fetchType);
                                }
                            });
                            break;
                        }
                        case 3: {
                            Optional optional = (Optional)notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(this, optional){
                                final /* synthetic */ 5 this$1;
                                private final /* synthetic */ Optional val$optional;
                                {
                                    this.this$1 = var1_1;
                                    this.val$optional = optional;
                                }

                                public void run() {
                                    5.access$0(this.this$1).optionalChanged(this.val$optional);
                                }
                            });
                            break;
                        }
                        case 4: {
                            Temporal oldTemporal = (Temporal)notification.getOldValue();
                            Temporal newTemporal = (Temporal)notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(this, oldTemporal, newTemporal){
                                final /* synthetic */ 5 this$1;
                                private final /* synthetic */ Temporal val$oldTemporal;
                                private final /* synthetic */ Temporal val$newTemporal;
                                {
                                    this.this$1 = var1_1;
                                    this.val$oldTemporal = temporal;
                                    this.val$newTemporal = temporal2;
                                }

                                public void run() {
                                    5.access$0(this.this$1).temporalChanged(this.val$oldTemporal, this.val$newTemporal);
                                }
                            });
                        }
                    }
                }
            }

            static /* synthetic */ BasicMappingComposite access$0(5 var0) {
                return var0.BasicMappingComposite.this;
            }
        };
    }

    void fetchTypeChanged(FetchTypeDefaultEager fetchType) {
        if (((IStructuredSelection)this.fetchTypeComboViewer.getSelection()).getFirstElement() != fetchType) {
            this.fetchTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)fetchType));
        }
    }

    void optionalChanged(Optional optional) {
        if (((IStructuredSelection)this.optionalComboViewer.getSelection()).getFirstElement() != optional) {
            this.optionalComboViewer.setSelection((ISelection)new StructuredSelection((Object)optional));
        }
    }

    void temporalChanged(Temporal oldTemporal, Temporal newTemporal) {
        if (oldTemporal == null) {
            if (newTemporal != null) {
                this.temporalItemProvider.addListener(this.getTemporalListener());
                newTemporal.eAdapters().add((Object)this.temporalItemProvider);
                this.temporalCheckBox.setSelection(true);
                this.temporalTypeComboViewer.getCombo().setEnabled(true);
                this.setTemporalTypeSelection(newTemporal.getType());
            }
        } else {
            oldTemporal.eAdapters().remove((Object)this.temporalItemProvider);
            this.temporalItemProvider.removeListener(this.getTemporalListener());
            if (newTemporal == null) {
                this.temporalCheckBox.setSelection(false);
                this.temporalTypeComboViewer.getCombo().setEnabled(false);
                this.setTemporalTypeSelection(null);
            } else {
                this.temporalItemProvider.addListener(this.getTemporalListener());
                newTemporal.eAdapters().add((Object)this.temporalItemProvider);
                this.setTemporalTypeSelection(newTemporal.getType());
            }
        }
    }

    private INotifyChangedListener getTemporalListener() {
        if (this.temporalListener == null) {
            this.temporalListener = this.buildTemporalListener();
        }
        return this.temporalListener;
    }

    private INotifyChangedListener buildTemporalListener() {
        return new INotifyChangedListener(){

            public void notifyChanged(Notification notification) {
                if (((ViewerNotification)notification).getElement() instanceof Temporal) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.dali.orm.Temporal");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    switch (notification.getFeatureID((Class)clazz)) {
                        case 0: {
                            TemporalType temporalType = (TemporalType)notification.getNewValue();
                            Display.getDefault().syncExec(new Runnable(this, temporalType){
                                final /* synthetic */ 9 this$1;
                                private final /* synthetic */ TemporalType val$temporalType;
                                {
                                    this.this$1 = var1_1;
                                    this.val$temporalType = temporalType;
                                }

                                public void run() {
                                    9.access$0(this.this$1).setTemporalTypeSelection(this.val$temporalType);
                                }
                            });
                        }
                    }
                }
            }

            static /* synthetic */ BasicMappingComposite access$0(9 var0) {
                return var0.BasicMappingComposite.this;
            }
        };
    }

    public boolean setFocus() {
        super.setFocus();
        return this.fetchTypeComboViewer.getCombo().setFocus();
    }

    public void dispose() {
        if (this.basicMapping != null) {
            Temporal temporal = this.basicMapping.getTemporal();
            if (temporal != null) {
                temporal.eAdapters().remove((Object)this.temporalItemProvider);
                this.temporalItemProvider.removeListener(this.getTemporalListener());
            }
            this.basicMapping.eAdapters().remove((Object)this.mappingItemProvider);
            this.mappingItemProvider.removeListener(this.getMappingListener());
        }
        this.removeConnectionListener();
        super.dispose();
    }

    private void addConnectionListener() {
        if (this.connectionListener == null) {
            Connection connection = this.basicMapping.getPersistenceProject().getConnection();
            this.connectionListener = this.buildConnectionListener(connection);
            connection.addConnectionListener(this.connectionListener);
        }
    }

    private void removeConnectionListener() {
        if (this.connectionListener != null) {
            this.connectionListener.dispose();
            this.basicMapping.getPersistenceProject().getConnection().removeConnectionListener(this.connectionListener);
            this.connectionListener = null;
        }
    }

    private ConnectionListener buildConnectionListener(final Connection connectionInfo) {
        return new ConnectionListener(){

            public void connectionInfoRenamed(String previousName, Connection connection) {
            }

            public void connected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    BasicMappingComposite.this.populateColumnCombo();
                }
            }

            public void disconnected(Connection connection) {
                if (connectionInfo.equals(connection)) {
                    BasicMappingComposite.this.populateColumnCombo();
                }
            }

            public void sharedConnectionAdded(Connection connection) {
            }

            public void sharedConnectionRemove(Connection connection) {
            }

            public void schemaChanged(Schema schema) {
                BasicMappingComposite.this.populateColumnCombo();
            }

            public void tableChanged(Table table) {
                if (BasicMappingComposite.this.basicMapping != null && table.getName().equalsIgnoreCase(BasicMappingComposite.this.basicMapping.getColumn().getTableName())) {
                    BasicMappingComposite.this.populateColumnCombo();
                }
            }

            public void databaseAdded(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    BasicMappingComposite.this.populateColumnCombo();
                }
            }

            public void databaseRemove(Connection connection, Database database) {
                if (connectionInfo.equals(connection)) {
                    BasicMappingComposite.this.populateColumnCombo();
                }
            }

            public void onSQLException(Connection connection, SQLException exception) {
                connectionInfo.equals(connection);
            }

            public void dispose() {
            }
        };
    }

    public static class BasicMappingCompositeBuilder
    implements IMappingCompositeBuilder {
        public IPersistenceComposite buildMappingComposite(Composite parent, EditingDomain editingDomain, OrmItemProviderAdapterFactory adapterFactory) {
            return new BasicMappingComposite(parent, editingDomain, adapterFactory);
        }
    }
}

