/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection.listener;

import java.util.List;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.ui.composites.PageBookManager;
import org.eclipse.dali.ui.selection.listener.PageBookSelectionListener;
import org.eclipse.dali.ui.selection.notification.ISelectionNotification;
import org.eclipse.dali.ui.selection.notification.SelectionNotificationEvent;
import org.eclipse.dali.ui.views.MappingComposite;
import org.eclipse.dali.ui.views.PersistentTypeComposite;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;

public class PersistentPropertiesListener
extends PageBookSelectionListener {
    private EditingDomain editingDomain;

    public PersistentPropertiesListener(PageBookManager aPageBookManager, List aList, EditingDomain anEditingDomain) {
        super(aPageBookManager, aList);
        this.editingDomain = anEditingDomain;
    }

    public void selectionChanged(ISelectionNotification aNotification) {
        EObject eObj = aNotification.getSelection();
        Object origin = this.getKey(aNotification);
        SelectionNotificationEvent event = aNotification.getEvent();
        Key key = new Key(origin, eObj);
        if (event == SelectionNotificationEvent.OPENED || event == SelectionNotificationEvent.ACTIVATED || event == SelectionNotificationEvent.INITIALIZED || event == SelectionNotificationEvent.BROUGHT_TO_TOP || event == SelectionNotificationEvent.SELECTION_CHANGED) {
            if (this.pageBookManager.contains(key) || aNotification.isDeselection()) {
                this.pageBookManager.activate(key);
            } else {
                Composite composite = this.pageBookManager.getComposite();
                Composite pComp = null;
                if (eObj instanceof PersistentType) {
                    pComp = new PersistentTypeComposite(composite, this.editingDomain);
                } else if (eObj instanceof PersistentAttribute) {
                    pComp = new MappingComposite(composite, this.editingDomain);
                }
                if (pComp != null) {
                    pComp.populate(eObj);
                    this.pageBookManager.put(key, pComp);
                } else {
                    this.pageBookManager.activate(key);
                }
            }
        } else if (event == SelectionNotificationEvent.CLOSED) {
            this.pageBookManager.remove(key);
        }
    }

    private Object getKey(ISelectionNotification aNotification) {
        if (aNotification.getEventView() instanceof EditorPart) {
            return aNotification.getEventView();
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    private class Key {
        private EObject eobj;
        private Object origin;

        public Key(Object anOrigin, EObject anEObj) {
            this.origin = anOrigin;
            this.eobj = anEObj;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key key = (Key)obj;
                return this.eobj.equals(key.eobj) && this.origin.equals(key.origin);
            }
            return false;
        }

        public int hashCode() {
            return this.eobj.hashCode() ^ this.origin.hashCode();
        }
    }
}

