/*******************************************************************************
 * Copyright (c) 2014 Bosch Software Innovations GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * The Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 * Bosch Software Innovations GmbH - Please refer to git log
 *
 *******************************************************************************/
/*
 * generated by Xtext
 */
grammar InternalDatatype;

options {
	superClass=AbstractInternalAntlrParser;
}

@lexer::header {
package org.eclipse.vorto.editor.datatype.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.vorto.editor.datatype.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.vorto.editor.datatype.services.DatatypeGrammarAccess;

}

@parser::members {

 	private DatatypeGrammarAccess grammarAccess;

    public InternalDatatypeParser(TokenStream input, DatatypeGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "Model";
   	}

   	@Override
   	protected DatatypeGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRuleModel
entryRuleModel returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getModelRule()); }
	iv_ruleModel=ruleModel
	{ $current=$iv_ruleModel.current; }
	EOF;

// Rule Model
ruleModel returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getModelAccess().getTypeParserRuleCall());
	}
	this_Type_0=ruleType
	{
		$current = $this_Type_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRuleModelReference
entryRuleModelReference returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getModelReferenceRule()); }
	iv_ruleModelReference=ruleModelReference
	{ $current=$iv_ruleModelReference.current; }
	EOF;

// Rule ModelReference
ruleModelReference returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='using'
		{
			newLeafNode(otherlv_0, grammarAccess.getModelReferenceAccess().getUsingKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getModelReferenceAccess().getImportedNamespaceQualifiedNameParserRuleCall_1_0());
				}
				lv_importedNamespace_1_0=ruleQualifiedName
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getModelReferenceRule());
					}
					set(
						$current,
						"importedNamespace",
						lv_importedNamespace_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.QualifiedName");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=';'
		{
			newLeafNode(otherlv_2, grammarAccess.getModelReferenceAccess().getSemicolonKeyword_2());
		}
		(
			(
				lv_version_3_0=RULE_VERSION
				{
					newLeafNode(lv_version_3_0, grammarAccess.getModelReferenceAccess().getVersionVERSIONTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getModelReferenceRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VERSION");
				}
			)
		)
	)
;

// Entry rule entryRuleQualifiedName
entryRuleQualifiedName returns [String current=null]:
	{ newCompositeNode(grammarAccess.getQualifiedNameRule()); }
	iv_ruleQualifiedName=ruleQualifiedName
	{ $current=$iv_ruleQualifiedName.current.getText(); }
	EOF;

// Rule QualifiedName
ruleQualifiedName returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_0());
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getQualifiedNameAccess().getFullStopKeyword_1_0());
			}
			this_ID_2=RULE_ID
			{
				$current.merge(this_ID_2);
			}
			{
				newLeafNode(this_ID_2, grammarAccess.getQualifiedNameAccess().getIDTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRuleType
entryRuleType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeRule()); }
	iv_ruleType=ruleType
	{ $current=$iv_ruleType.current; }
	EOF;

// Rule Type
ruleType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getTypeAccess().getEntityParserRuleCall_0());
		}
		this_Entity_0=ruleEntity
		{
			$current = $this_Entity_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getTypeAccess().getEnumParserRuleCall_1());
		}
		this_Enum_1=ruleEnum
		{
			$current = $this_Enum_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleEntity
entryRuleEntity returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEntityRule()); }
	iv_ruleEntity=ruleEntity
	{ $current=$iv_ruleEntity.current; }
	EOF;

// Rule Entity
ruleEntity returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='vortolang'
		{
			newLeafNode(otherlv_0, grammarAccess.getEntityAccess().getVortolangKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEntityAccess().getLangVortoLangVersionEnumRuleCall_1_0());
				}
				lv_lang_1_0=ruleVortoLangVersion
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEntityRule());
					}
					set(
						$current,
						"lang",
						lv_lang_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VortoLangVersion");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='namespace'
		{
			newLeafNode(otherlv_2, grammarAccess.getEntityAccess().getNamespaceKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEntityAccess().getNamespaceQualifiedNameParserRuleCall_3_0());
				}
				lv_namespace_3_0=ruleQualifiedName
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEntityRule());
					}
					set(
						$current,
						"namespace",
						lv_namespace_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.QualifiedName");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='version'
		{
			newLeafNode(otherlv_4, grammarAccess.getEntityAccess().getVersionKeyword_4());
		}
		(
			(
				lv_version_5_0=RULE_VERSION
				{
					newLeafNode(lv_version_5_0, grammarAccess.getEntityAccess().getVersionVERSIONTerminalRuleCall_5_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEntityRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_5_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VERSION");
				}
			)
		)
		(
			(
				{ 
				  getUnorderedGroupHelper().enter(grammarAccess.getEntityAccess().getUnorderedGroup_6());
				}
				(
					(
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 0)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 0);
					}
								({true}?=>(otherlv_7='displayname'
								{
									newLeafNode(otherlv_7, grammarAccess.getEntityAccess().getDisplaynameKeyword_6_0_0());
								}
								(
									(
										lv_displayname_8_0=RULE_STRING
										{
											newLeafNode(lv_displayname_8_0, grammarAccess.getEntityAccess().getDisplaynameSTRINGTerminalRuleCall_6_0_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getEntityRule());
											}
											setWithLastConsumed(
												$current,
												"displayname",
												lv_displayname_8_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEntityAccess().getUnorderedGroup_6());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 1)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 1);
					}
								({true}?=>(otherlv_9='description'
								{
									newLeafNode(otherlv_9, grammarAccess.getEntityAccess().getDescriptionKeyword_6_1_0());
								}
								(
									(
										lv_description_10_0=RULE_STRING
										{
											newLeafNode(lv_description_10_0, grammarAccess.getEntityAccess().getDescriptionSTRINGTerminalRuleCall_6_1_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getEntityRule());
											}
											setWithLastConsumed(
												$current,
												"description",
												lv_description_10_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEntityAccess().getUnorderedGroup_6());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 2)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEntityAccess().getUnorderedGroup_6(), 2);
					}
								({true}?=>(otherlv_11='category'
								{
									newLeafNode(otherlv_11, grammarAccess.getEntityAccess().getCategoryKeyword_6_2_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getEntityAccess().getCategoryCATEGORYParserRuleCall_6_2_1_0());
										}
										lv_category_12_0=ruleCATEGORY
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getEntityRule());
											}
											set(
												$current,
												"category",
												lv_category_12_0,
												"org.eclipse.vorto.editor.datatype.Datatype.CATEGORY");
											afterParserOrEnumRuleCall();
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEntityAccess().getUnorderedGroup_6());
					}
				)
			)
					)*
				)
			)
				{ 
				  getUnorderedGroupHelper().leave(grammarAccess.getEntityAccess().getUnorderedGroup_6());
				}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getEntityAccess().getReferencesModelReferenceParserRuleCall_7_0());
				}
				lv_references_13_0=ruleModelReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEntityRule());
					}
					add(
						$current,
						"references",
						lv_references_13_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ModelReference");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_14='entity'
		{
			newLeafNode(otherlv_14, grammarAccess.getEntityAccess().getEntityKeyword_8());
		}
		(
			(
				lv_name_15_0=RULE_ID
				{
					newLeafNode(lv_name_15_0, grammarAccess.getEntityAccess().getNameIDTerminalRuleCall_9_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEntityRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_15_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			otherlv_16='extends'
			{
				newLeafNode(otherlv_16, grammarAccess.getEntityAccess().getExtendsKeyword_10_0());
			}
			(
				(
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getEntityRule());
						}
					}
					{
						newCompositeNode(grammarAccess.getEntityAccess().getSuperTypeEntityCrossReference_10_1_0());
					}
					ruleQualifiedName
					{
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_18='{'
		{
			newLeafNode(otherlv_18, grammarAccess.getEntityAccess().getLeftCurlyBracketKeyword_11());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEntityAccess().getPropertiesPropertyParserRuleCall_12_0());
				}
				lv_properties_19_0=ruleProperty
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEntityRule());
					}
					add(
						$current,
						"properties",
						lv_properties_19_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Property");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_20='}'
		{
			newLeafNode(otherlv_20, grammarAccess.getEntityAccess().getRightCurlyBracketKeyword_13());
		}
	)
;

// Entry rule entryRuleEnum
entryRuleEnum returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumRule()); }
	iv_ruleEnum=ruleEnum
	{ $current=$iv_ruleEnum.current; }
	EOF;

// Rule Enum
ruleEnum returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='vortolang'
		{
			newLeafNode(otherlv_0, grammarAccess.getEnumAccess().getVortolangKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumAccess().getLangVortoLangVersionEnumRuleCall_1_0());
				}
				lv_lang_1_0=ruleVortoLangVersion
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumRule());
					}
					set(
						$current,
						"lang",
						lv_lang_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VortoLangVersion");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='namespace'
		{
			newLeafNode(otherlv_2, grammarAccess.getEnumAccess().getNamespaceKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumAccess().getNamespaceQualifiedNameParserRuleCall_3_0());
				}
				lv_namespace_3_0=ruleQualifiedName
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumRule());
					}
					set(
						$current,
						"namespace",
						lv_namespace_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.QualifiedName");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='version'
		{
			newLeafNode(otherlv_4, grammarAccess.getEnumAccess().getVersionKeyword_4());
		}
		(
			(
				lv_version_5_0=RULE_VERSION
				{
					newLeafNode(lv_version_5_0, grammarAccess.getEnumAccess().getVersionVERSIONTerminalRuleCall_5_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumRule());
					}
					setWithLastConsumed(
						$current,
						"version",
						lv_version_5_0,
						"org.eclipse.vorto.editor.datatype.Datatype.VERSION");
				}
			)
		)
		(
			(
				{ 
				  getUnorderedGroupHelper().enter(grammarAccess.getEnumAccess().getUnorderedGroup_6());
				}
				(
					(
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 0)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 0);
					}
								({true}?=>(otherlv_7='displayname'
								{
									newLeafNode(otherlv_7, grammarAccess.getEnumAccess().getDisplaynameKeyword_6_0_0());
								}
								(
									(
										lv_displayname_8_0=RULE_STRING
										{
											newLeafNode(lv_displayname_8_0, grammarAccess.getEnumAccess().getDisplaynameSTRINGTerminalRuleCall_6_0_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getEnumRule());
											}
											setWithLastConsumed(
												$current,
												"displayname",
												lv_displayname_8_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEnumAccess().getUnorderedGroup_6());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 1)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 1);
					}
								({true}?=>(otherlv_9='description'
								{
									newLeafNode(otherlv_9, grammarAccess.getEnumAccess().getDescriptionKeyword_6_1_0());
								}
								(
									(
										lv_description_10_0=RULE_STRING
										{
											newLeafNode(lv_description_10_0, grammarAccess.getEnumAccess().getDescriptionSTRINGTerminalRuleCall_6_1_1_0());
										}
										{
											if ($current==null) {
												$current = createModelElement(grammarAccess.getEnumRule());
											}
											setWithLastConsumed(
												$current,
												"description",
												lv_description_10_0,
												"org.eclipse.xtext.common.Terminals.STRING");
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEnumAccess().getUnorderedGroup_6());
					}
				)
			)|
			(
				{getUnorderedGroupHelper().canSelect(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 2)}?=>(
					{
						getUnorderedGroupHelper().select(grammarAccess.getEnumAccess().getUnorderedGroup_6(), 2);
					}
								({true}?=>(otherlv_11='category'
								{
									newLeafNode(otherlv_11, grammarAccess.getEnumAccess().getCategoryKeyword_6_2_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getEnumAccess().getCategoryCATEGORYParserRuleCall_6_2_1_0());
										}
										lv_category_12_0=ruleCATEGORY
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getEnumRule());
											}
											set(
												$current,
												"category",
												lv_category_12_0,
												"org.eclipse.vorto.editor.datatype.Datatype.CATEGORY");
											afterParserOrEnumRuleCall();
										}
									)
								)
								))
					{ 
						getUnorderedGroupHelper().returnFromSelection(grammarAccess.getEnumAccess().getUnorderedGroup_6());
					}
				)
			)
					)*
				)
			)
				{ 
				  getUnorderedGroupHelper().leave(grammarAccess.getEnumAccess().getUnorderedGroup_6());
				}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumAccess().getReferencesModelReferenceParserRuleCall_7_0());
				}
				lv_references_13_0=ruleModelReference
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumRule());
					}
					add(
						$current,
						"references",
						lv_references_13_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ModelReference");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_14='enum'
		{
			newLeafNode(otherlv_14, grammarAccess.getEnumAccess().getEnumKeyword_8());
		}
		(
			(
				lv_name_15_0=RULE_ID
				{
					newLeafNode(lv_name_15_0, grammarAccess.getEnumAccess().getNameIDTerminalRuleCall_9_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_15_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		otherlv_16='{'
		{
			newLeafNode(otherlv_16, grammarAccess.getEnumAccess().getLeftCurlyBracketKeyword_10());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getEnumAccess().getEnumsEnumLiteralParserRuleCall_11_0_0());
					}
					lv_enums_17_0=ruleEnumLiteral
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getEnumRule());
						}
						add(
							$current,
							"enums",
							lv_enums_17_0,
							"org.eclipse.vorto.editor.datatype.Datatype.EnumLiteral");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_18=','
				{
					newLeafNode(otherlv_18, grammarAccess.getEnumAccess().getCommaKeyword_11_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getEnumAccess().getEnumsEnumLiteralParserRuleCall_11_1_1_0());
						}
						lv_enums_19_0=ruleEnumLiteral
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getEnumRule());
							}
							add(
								$current,
								"enums",
								lv_enums_19_0,
								"org.eclipse.vorto.editor.datatype.Datatype.EnumLiteral");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_20='}'
		{
			newLeafNode(otherlv_20, grammarAccess.getEnumAccess().getRightCurlyBracketKeyword_12());
		}
	)
;

// Entry rule entryRuleEnumLiteral
entryRuleEnumLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumLiteralRule()); }
	iv_ruleEnumLiteral=ruleEnumLiteral
	{ $current=$iv_ruleEnumLiteral.current; }
	EOF;

// Rule EnumLiteral
ruleEnumLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_name_0_0=RULE_ID
				{
					newLeafNode(lv_name_0_0, grammarAccess.getEnumLiteralAccess().getNameIDTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_0_0,
						"org.eclipse.xtext.common.Terminals.ID");
				}
			)
		)
		(
			(
				lv_description_1_0=RULE_STRING
				{
					newLeafNode(lv_description_1_0, grammarAccess.getEnumLiteralAccess().getDescriptionSTRINGTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumLiteralRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_1_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRuleProperty
entryRuleProperty returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyRule()); }
	iv_ruleProperty=ruleProperty
	{ $current=$iv_ruleProperty.current; }
	EOF;

// Rule Property
ruleProperty returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_extension_0_0='extension'
				{
					newLeafNode(lv_extension_0_0, grammarAccess.getPropertyAccess().getExtensionExtensionKeyword_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPropertyRule());
					}
					setWithLastConsumed($current, "extension", true, "extension");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getPropertyAccess().getPresencePresenceParserRuleCall_1_0());
				}
				lv_presence_1_0=rulePresence
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPropertyRule());
					}
					set(
						$current,
						"presence",
						lv_presence_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.Presence");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				lv_multiplicity_2_0='multiple'
				{
					newLeafNode(lv_multiplicity_2_0, grammarAccess.getPropertyAccess().getMultiplicityMultipleKeyword_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPropertyRule());
					}
					setWithLastConsumed($current, "multiplicity", true, "multiple");
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getPropertyAccess().getNameValidIDParserRuleCall_3_0());
				}
				lv_name_3_0=ruleValidID
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPropertyRule());
					}
					set(
						$current,
						"name",
						lv_name_3_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ValidID");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_4='as'
		{
			newLeafNode(otherlv_4, grammarAccess.getPropertyAccess().getAsKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getPropertyAccess().getTypePropertyTypeParserRuleCall_5_0());
				}
				lv_type_5_0=rulePropertyType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getPropertyRule());
					}
					set(
						$current,
						"type",
						lv_type_5_0,
						"org.eclipse.vorto.editor.datatype.Datatype.PropertyType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_6='with'
			{
				newLeafNode(otherlv_6, grammarAccess.getPropertyAccess().getWithKeyword_6_0());
			}
			otherlv_7='{'
			{
				newLeafNode(otherlv_7, grammarAccess.getPropertyAccess().getLeftCurlyBracketKeyword_6_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPropertyAccess().getPropertyAttributesPropertyAttributeParserRuleCall_6_2_0());
					}
					lv_propertyAttributes_8_0=rulePropertyAttribute
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPropertyRule());
						}
						add(
							$current,
							"propertyAttributes",
							lv_propertyAttributes_8_0,
							"org.eclipse.vorto.editor.datatype.Datatype.PropertyAttribute");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_9=','
				{
					newLeafNode(otherlv_9, grammarAccess.getPropertyAccess().getCommaKeyword_6_3_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getPropertyAccess().getPropertyAttributesPropertyAttributeParserRuleCall_6_3_1_0());
						}
						lv_propertyAttributes_10_0=rulePropertyAttribute
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getPropertyRule());
							}
							add(
								$current,
								"propertyAttributes",
								lv_propertyAttributes_10_0,
								"org.eclipse.vorto.editor.datatype.Datatype.PropertyAttribute");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_11='}'
			{
				newLeafNode(otherlv_11, grammarAccess.getPropertyAccess().getRightCurlyBracketKeyword_6_4());
			}
		)?
		(
			otherlv_12='<'
			{
				newLeafNode(otherlv_12, grammarAccess.getPropertyAccess().getLessThanSignKeyword_7_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getPropertyAccess().getConstraintRuleConstraintRuleParserRuleCall_7_1_0());
					}
					lv_constraintRule_13_0=ruleConstraintRule
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getPropertyRule());
						}
						set(
							$current,
							"constraintRule",
							lv_constraintRule_13_0,
							"org.eclipse.vorto.editor.datatype.Datatype.ConstraintRule");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_14='>'
			{
				newLeafNode(otherlv_14, grammarAccess.getPropertyAccess().getGreaterThanSignKeyword_7_2());
			}
		)?
		(
			(
				lv_description_15_0=RULE_STRING
				{
					newLeafNode(lv_description_15_0, grammarAccess.getPropertyAccess().getDescriptionSTRINGTerminalRuleCall_8_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getPropertyRule());
					}
					setWithLastConsumed(
						$current,
						"description",
						lv_description_15_0,
						"org.eclipse.xtext.common.Terminals.STRING");
				}
			)
		)?
	)
;

// Entry rule entryRuleConstraintRule
entryRuleConstraintRule returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConstraintRuleRule()); }
	iv_ruleConstraintRule=ruleConstraintRule
	{ $current=$iv_ruleConstraintRule.current; }
	EOF;

// Rule ConstraintRule
ruleConstraintRule returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getConstraintRuleAccess().getConstraintRuleAction_0(),
					$current);
			}
		)
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getConstraintRuleAccess().getConstraintsConstraintParserRuleCall_1_0_0());
					}
					lv_Constraints_1_0=ruleConstraint
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getConstraintRuleRule());
						}
						add(
							$current,
							"Constraints",
							lv_Constraints_1_0,
							"org.eclipse.vorto.editor.datatype.Datatype.Constraint");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_2=','
				{
					newLeafNode(otherlv_2, grammarAccess.getConstraintRuleAccess().getCommaKeyword_1_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getConstraintRuleAccess().getConstraintsConstraintParserRuleCall_1_1_1_0());
						}
						lv_Constraints_3_0=ruleConstraint
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getConstraintRuleRule());
							}
							add(
								$current,
								"Constraints",
								lv_Constraints_3_0,
								"org.eclipse.vorto.editor.datatype.Datatype.Constraint");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
	)
;

// Entry rule entryRulePropertyAttribute
entryRulePropertyAttribute returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyAttributeRule()); }
	iv_rulePropertyAttribute=rulePropertyAttribute
	{ $current=$iv_rulePropertyAttribute.current; }
	EOF;

// Rule PropertyAttribute
rulePropertyAttribute returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPropertyAttributeAccess().getBooleanPropertyAttributeParserRuleCall_0());
		}
		this_BooleanPropertyAttribute_0=ruleBooleanPropertyAttribute
		{
			$current = $this_BooleanPropertyAttribute_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPropertyAttributeAccess().getEnumLiteralPropertyAttributeParserRuleCall_1());
		}
		this_EnumLiteralPropertyAttribute_1=ruleEnumLiteralPropertyAttribute
		{
			$current = $this_EnumLiteralPropertyAttribute_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleBooleanPropertyAttribute
entryRuleBooleanPropertyAttribute returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBooleanPropertyAttributeRule()); }
	iv_ruleBooleanPropertyAttribute=ruleBooleanPropertyAttribute
	{ $current=$iv_ruleBooleanPropertyAttribute.current; }
	EOF;

// Rule BooleanPropertyAttribute
ruleBooleanPropertyAttribute returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getBooleanPropertyAttributeAccess().getTypeBooleanPropertyAttributeTypeEnumRuleCall_0_0());
				}
				lv_type_0_0=ruleBooleanPropertyAttributeType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getBooleanPropertyAttributeRule());
					}
					set(
						$current,
						"type",
						lv_type_0_0,
						"org.eclipse.vorto.editor.datatype.Datatype.BooleanPropertyAttributeType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1=':'
		{
			newLeafNode(otherlv_1, grammarAccess.getBooleanPropertyAttributeAccess().getColonKeyword_1());
		}
		(
			(
				(
					lv_value_2_0='true'
					{
						newLeafNode(lv_value_2_0, grammarAccess.getBooleanPropertyAttributeAccess().getValueTrueKeyword_2_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getBooleanPropertyAttributeRule());
						}
						setWithLastConsumed($current, "value", true, "true");
					}
				)
			)
			    |
			otherlv_3='false'
			{
				newLeafNode(otherlv_3, grammarAccess.getBooleanPropertyAttributeAccess().getFalseKeyword_2_1());
			}
		)
	)
;

// Entry rule entryRuleEnumLiteralPropertyAttribute
entryRuleEnumLiteralPropertyAttribute returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getEnumLiteralPropertyAttributeRule()); }
	iv_ruleEnumLiteralPropertyAttribute=ruleEnumLiteralPropertyAttribute
	{ $current=$iv_ruleEnumLiteralPropertyAttribute.current; }
	EOF;

// Rule EnumLiteralPropertyAttribute
ruleEnumLiteralPropertyAttribute returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getEnumLiteralPropertyAttributeAccess().getTypeEnumLiteralPropertyAttributeTypeEnumRuleCall_0_0());
				}
				lv_type_0_0=ruleEnumLiteralPropertyAttributeType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getEnumLiteralPropertyAttributeRule());
					}
					set(
						$current,
						"type",
						lv_type_0_0,
						"org.eclipse.vorto.editor.datatype.Datatype.EnumLiteralPropertyAttributeType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1=':'
		{
			newLeafNode(otherlv_1, grammarAccess.getEnumLiteralPropertyAttributeAccess().getColonKeyword_1());
		}
		(
			(
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getEnumLiteralPropertyAttributeRule());
					}
				}
				{
					newCompositeNode(grammarAccess.getEnumLiteralPropertyAttributeAccess().getValueEnumLiteralCrossReference_2_0());
				}
				ruleQualifiedName
				{
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulePropertyType
entryRulePropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPropertyTypeRule()); }
	iv_rulePropertyType=rulePropertyType
	{ $current=$iv_rulePropertyType.current; }
	EOF;

// Rule PropertyType
rulePropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			newCompositeNode(grammarAccess.getPropertyTypeAccess().getObjectPropertyTypeParserRuleCall_0());
		}
		this_ObjectPropertyType_0=ruleObjectPropertyType
		{
			$current = $this_ObjectPropertyType_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPropertyTypeAccess().getPrimitivePropertyTypeParserRuleCall_1());
		}
		this_PrimitivePropertyType_1=rulePrimitivePropertyType
		{
			$current = $this_PrimitivePropertyType_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			newCompositeNode(grammarAccess.getPropertyTypeAccess().getComplexPrimitivePropertyTypeParserRuleCall_2());
		}
		this_ComplexPrimitivePropertyType_2=ruleComplexPrimitivePropertyType
		{
			$current = $this_ComplexPrimitivePropertyType_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRulePrimitivePropertyType
entryRulePrimitivePropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPrimitivePropertyTypeRule()); }
	iv_rulePrimitivePropertyType=rulePrimitivePropertyType
	{ $current=$iv_rulePrimitivePropertyType.current; }
	EOF;

// Rule PrimitivePropertyType
rulePrimitivePropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				newCompositeNode(grammarAccess.getPrimitivePropertyTypeAccess().getTypePrimitiveTypeEnumRuleCall_0());
			}
			lv_type_0_0=rulePrimitiveType
			{
				if ($current==null) {
					$current = createModelElementForParent(grammarAccess.getPrimitivePropertyTypeRule());
				}
				set(
					$current,
					"type",
					lv_type_0_0,
					"org.eclipse.vorto.editor.datatype.Datatype.PrimitiveType");
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleObjectPropertyType
entryRuleObjectPropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getObjectPropertyTypeRule()); }
	iv_ruleObjectPropertyType=ruleObjectPropertyType
	{ $current=$iv_ruleObjectPropertyType.current; }
	EOF;

// Rule ObjectPropertyType
ruleObjectPropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				if ($current==null) {
					$current = createModelElement(grammarAccess.getObjectPropertyTypeRule());
				}
			}
			{
				newCompositeNode(grammarAccess.getObjectPropertyTypeAccess().getTypeTypeCrossReference_0());
			}
			ruleQualifiedName
			{
				afterParserOrEnumRuleCall();
			}
		)
	)
;

// Entry rule entryRuleComplexPrimitivePropertyType
entryRuleComplexPrimitivePropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getComplexPrimitivePropertyTypeRule()); }
	iv_ruleComplexPrimitivePropertyType=ruleComplexPrimitivePropertyType
	{ $current=$iv_ruleComplexPrimitivePropertyType.current; }
	EOF;

// Rule ComplexPrimitivePropertyType
ruleComplexPrimitivePropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	{
		newCompositeNode(grammarAccess.getComplexPrimitivePropertyTypeAccess().getDictionaryPropertyTypeParserRuleCall());
	}
	this_DictionaryPropertyType_0=ruleDictionaryPropertyType
	{
		$current = $this_DictionaryPropertyType_0.current;
		afterParserOrEnumRuleCall();
	}
;

// Entry rule entryRuleDictionaryPropertyType
entryRuleDictionaryPropertyType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getDictionaryPropertyTypeRule()); }
	iv_ruleDictionaryPropertyType=ruleDictionaryPropertyType
	{ $current=$iv_ruleDictionaryPropertyType.current; }
	EOF;

// Rule DictionaryPropertyType
ruleDictionaryPropertyType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getDictionaryPropertyTypeAccess().getDictionaryPropertyTypeAction_0(),
					$current);
			}
		)
		otherlv_1='dictionary'
		{
			newLeafNode(otherlv_1, grammarAccess.getDictionaryPropertyTypeAccess().getDictionaryKeyword_1());
		}
		(
			otherlv_2='['
			{
				newLeafNode(otherlv_2, grammarAccess.getDictionaryPropertyTypeAccess().getLeftSquareBracketKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getDictionaryPropertyTypeAccess().getKeyTypePropertyTypeParserRuleCall_2_1_0());
					}
					lv_keyType_3_0=rulePropertyType
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getDictionaryPropertyTypeRule());
						}
						set(
							$current,
							"keyType",
							lv_keyType_3_0,
							"org.eclipse.vorto.editor.datatype.Datatype.PropertyType");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_4=','
			{
				newLeafNode(otherlv_4, grammarAccess.getDictionaryPropertyTypeAccess().getCommaKeyword_2_2());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getDictionaryPropertyTypeAccess().getValueTypePropertyTypeParserRuleCall_2_3_0());
					}
					lv_valueType_5_0=rulePropertyType
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getDictionaryPropertyTypeRule());
						}
						set(
							$current,
							"valueType",
							lv_valueType_5_0,
							"org.eclipse.vorto.editor.datatype.Datatype.PropertyType");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_6=']'
			{
				newLeafNode(otherlv_6, grammarAccess.getDictionaryPropertyTypeAccess().getRightSquareBracketKeyword_2_4());
			}
		)?
	)
;

// Entry rule entryRulePresence
entryRulePresence returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getPresenceRule()); }
	iv_rulePresence=rulePresence
	{ $current=$iv_rulePresence.current; }
	EOF;

// Rule Presence
rulePresence returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				$current = forceCreateModelElement(
					grammarAccess.getPresenceAccess().getPresenceAction_0(),
					$current);
			}
		)
		(
			(
				(
					lv_mandatory_1_0='mandatory'
					{
						newLeafNode(lv_mandatory_1_0, grammarAccess.getPresenceAccess().getMandatoryMandatoryKeyword_1_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getPresenceRule());
						}
						setWithLastConsumed($current, "mandatory", true, "mandatory");
					}
				)
			)
			    |
			otherlv_2='optional'
			{
				newLeafNode(otherlv_2, grammarAccess.getPresenceAccess().getOptionalKeyword_1_1());
			}
		)
	)
;

// Entry rule entryRuleConstraint
entryRuleConstraint returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getConstraintRule()); }
	iv_ruleConstraint=ruleConstraint
	{ $current=$iv_ruleConstraint.current; }
	EOF;

// Rule Constraint
ruleConstraint returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getConstraintAccess().getTypeConstraintIntervalTypeEnumRuleCall_0_0());
				}
				lv_type_0_0=ruleConstraintIntervalType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConstraintRule());
					}
					set(
						$current,
						"type",
						lv_type_0_0,
						"org.eclipse.vorto.editor.datatype.Datatype.ConstraintIntervalType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getConstraintAccess().getConstraintValuesIntervalTypeParserRuleCall_1_0());
				}
				lv_constraintValues_1_0=ruleIntervalType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getConstraintRule());
					}
					set(
						$current,
						"constraintValues",
						lv_constraintValues_1_0,
						"org.eclipse.vorto.editor.datatype.Datatype.IntervalType");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleIntervalType
entryRuleIntervalType returns [String current=null]:
	{ newCompositeNode(grammarAccess.getIntervalTypeRule()); }
	iv_ruleIntervalType=ruleIntervalType
	{ $current=$iv_ruleIntervalType.current.getText(); }
	EOF;

// Rule IntervalType
ruleIntervalType returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getIntervalTypeAccess().getINTTerminalRuleCall_0());
		}
		    |
		this_SIGNEDINT_1=RULE_SIGNEDINT
		{
			$current.merge(this_SIGNEDINT_1);
		}
		{
			newLeafNode(this_SIGNEDINT_1, grammarAccess.getIntervalTypeAccess().getSIGNEDINTTerminalRuleCall_1());
		}
		    |
		this_FLOAT_2=RULE_FLOAT
		{
			$current.merge(this_FLOAT_2);
		}
		{
			newLeafNode(this_FLOAT_2, grammarAccess.getIntervalTypeAccess().getFLOATTerminalRuleCall_2());
		}
		    |
		this_DATETIME_3=RULE_DATETIME
		{
			$current.merge(this_DATETIME_3);
		}
		{
			newLeafNode(this_DATETIME_3, grammarAccess.getIntervalTypeAccess().getDATETIMETerminalRuleCall_3());
		}
		    |
		this_STRING_4=RULE_STRING
		{
			$current.merge(this_STRING_4);
		}
		{
			newLeafNode(this_STRING_4, grammarAccess.getIntervalTypeAccess().getSTRINGTerminalRuleCall_4());
		}
		    |
		{
			newCompositeNode(grammarAccess.getIntervalTypeAccess().getBOOLEANParserRuleCall_5());
		}
		this_BOOLEAN_5=ruleBOOLEAN
		{
			$current.merge(this_BOOLEAN_5);
		}
		{
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleBOOLEAN
entryRuleBOOLEAN returns [String current=null]:
	{ newCompositeNode(grammarAccess.getBOOLEANRule()); }
	iv_ruleBOOLEAN=ruleBOOLEAN
	{ $current=$iv_ruleBOOLEAN.current.getText(); }
	EOF;

// Rule BOOLEAN
ruleBOOLEAN returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='true'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getBOOLEANAccess().getTrueKeyword_0());
		}
		    |
		kw='false'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getBOOLEANAccess().getFalseKeyword_1());
		}
	)
;

// Entry rule entryRuleCATEGORY
entryRuleCATEGORY returns [String current=null]:
	{ newCompositeNode(grammarAccess.getCATEGORYRule()); }
	iv_ruleCATEGORY=ruleCATEGORY
	{ $current=$iv_ruleCATEGORY.current.getText(); }
	EOF;

// Rule CATEGORY
ruleCATEGORY returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_0());
		}
		(
			kw='/'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getCATEGORYAccess().getSolidusKeyword_1_0());
			}
			this_ID_2=RULE_ID
			{
				$current.merge(this_ID_2);
			}
			{
				newLeafNode(this_ID_2, grammarAccess.getCATEGORYAccess().getIDTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRuleValidID
entryRuleValidID returns [String current=null]:
	{ newCompositeNode(grammarAccess.getValidIDRule()); }
	iv_ruleValidID=ruleValidID
	{ $current=$iv_ruleValidID.current.getText(); }
	EOF;

// Rule ValidID
ruleValidID returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_ID_0=RULE_ID
		{
			$current.merge(this_ID_0);
		}
		{
			newLeafNode(this_ID_0, grammarAccess.getValidIDAccess().getIDTerminalRuleCall_0());
		}
		    |
		{
			newCompositeNode(grammarAccess.getValidIDAccess().getKEYWORDParserRuleCall_1());
		}
		this_KEYWORD_1=ruleKEYWORD
		{
			$current.merge(this_KEYWORD_1);
		}
		{
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuleKEYWORD
entryRuleKEYWORD returns [String current=null]:
	{ newCompositeNode(grammarAccess.getKEYWORDRule()); }
	iv_ruleKEYWORD=ruleKEYWORD
	{ $current=$iv_ruleKEYWORD.current.getText(); }
	EOF;

// Rule KEYWORD
ruleKEYWORD returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='breakable'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getBreakableKeyword_0());
		}
		    |
		kw='category'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getCategoryKeyword_1());
		}
		    |
		kw='configuration'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getConfigurationKeyword_2());
		}
		    |
		kw='dateTime'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getDateTimeKeyword_3());
		}
		    |
		kw='description'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getDescriptionKeyword_4());
		}
		    |
		kw='dictionary'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getDictionaryKeyword_5());
		}
		    |
		kw='displayname'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getDisplaynameKeyword_6());
		}
		    |
		kw='events'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getEventsKeyword_7());
		}
		    |
		kw='extension'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getExtensionKeyword_8());
		}
		    |
		kw='fault'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getFaultKeyword_9());
		}
		    |
		kw='functionblock'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getFunctionblockKeyword_10());
		}
		    |
		kw='functionblocks'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getFunctionblocksKeyword_11());
		}
		    |
		kw='infomodel'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getInfomodelKeyword_12());
		}
		    |
		kw='mandatory'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getMandatoryKeyword_13());
		}
		    |
		kw='namespace'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getNamespaceKeyword_14());
		}
		    |
		kw='operations'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getOperationsKeyword_15());
		}
		    |
		kw='optional'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getOptionalKeyword_16());
		}
		    |
		kw='status'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getStatusKeyword_17());
		}
		    |
		kw='version'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getKEYWORDAccess().getVersionKeyword_18());
		}
	)
;

// Rule BooleanPropertyAttributeType
ruleBooleanPropertyAttributeType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='readable'
			{
				$current = grammarAccess.getBooleanPropertyAttributeTypeAccess().getReadableEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getBooleanPropertyAttributeTypeAccess().getReadableEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='writable'
			{
				$current = grammarAccess.getBooleanPropertyAttributeTypeAccess().getWritableEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getBooleanPropertyAttributeTypeAccess().getWritableEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='eventable'
			{
				$current = grammarAccess.getBooleanPropertyAttributeTypeAccess().getEventableEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getBooleanPropertyAttributeTypeAccess().getEventableEnumLiteralDeclaration_2());
			}
		)
	)
;

// Rule VortoLangVersion
ruleVortoLangVersion returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		enumLiteral_0='1.0'
		{
			$current = grammarAccess.getVortoLangVersionAccess().getVersion1EnumLiteralDeclaration().getEnumLiteral().getInstance();
			newLeafNode(enumLiteral_0, grammarAccess.getVortoLangVersionAccess().getVersion1EnumLiteralDeclaration());
		}
	)
;

// Rule EnumLiteralPropertyAttributeType
ruleEnumLiteralPropertyAttributeType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		enumLiteral_0='measurementUnit'
		{
			$current = grammarAccess.getEnumLiteralPropertyAttributeTypeAccess().getMeasurementUnitEnumLiteralDeclaration().getEnumLiteral().getInstance();
			newLeafNode(enumLiteral_0, grammarAccess.getEnumLiteralPropertyAttributeTypeAccess().getMeasurementUnitEnumLiteralDeclaration());
		}
	)
;

// Rule PrimitiveType
rulePrimitiveType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='string'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getStringEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getPrimitiveTypeAccess().getStringEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='int'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getIntEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getPrimitiveTypeAccess().getIntEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='float'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getFloatEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getPrimitiveTypeAccess().getFloatEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='boolean'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getBooleanEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getPrimitiveTypeAccess().getBooleanEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='dateTime'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getDatetimeEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getPrimitiveTypeAccess().getDatetimeEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='double'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getDoubleEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getPrimitiveTypeAccess().getDoubleEnumLiteralDeclaration_5());
			}
		)
		    |
		(
			enumLiteral_6='long'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getLongEnumLiteralDeclaration_6().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_6, grammarAccess.getPrimitiveTypeAccess().getLongEnumLiteralDeclaration_6());
			}
		)
		    |
		(
			enumLiteral_7='short'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getShortEnumLiteralDeclaration_7().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_7, grammarAccess.getPrimitiveTypeAccess().getShortEnumLiteralDeclaration_7());
			}
		)
		    |
		(
			enumLiteral_8='base64Binary'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getBase64BinaryEnumLiteralDeclaration_8().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_8, grammarAccess.getPrimitiveTypeAccess().getBase64BinaryEnumLiteralDeclaration_8());
			}
		)
		    |
		(
			enumLiteral_9='byte'
			{
				$current = grammarAccess.getPrimitiveTypeAccess().getByteEnumLiteralDeclaration_9().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_9, grammarAccess.getPrimitiveTypeAccess().getByteEnumLiteralDeclaration_9());
			}
		)
	)
;

// Rule ConstraintIntervalType
ruleConstraintIntervalType returns [Enumerator current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			enumLiteral_0='MIN'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getMinEnumLiteralDeclaration_0().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_0, grammarAccess.getConstraintIntervalTypeAccess().getMinEnumLiteralDeclaration_0());
			}
		)
		    |
		(
			enumLiteral_1='MAX'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getMaxEnumLiteralDeclaration_1().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_1, grammarAccess.getConstraintIntervalTypeAccess().getMaxEnumLiteralDeclaration_1());
			}
		)
		    |
		(
			enumLiteral_2='STRLEN'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getStrlenEnumLiteralDeclaration_2().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_2, grammarAccess.getConstraintIntervalTypeAccess().getStrlenEnumLiteralDeclaration_2());
			}
		)
		    |
		(
			enumLiteral_3='REGEX'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getRegexEnumLiteralDeclaration_3().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_3, grammarAccess.getConstraintIntervalTypeAccess().getRegexEnumLiteralDeclaration_3());
			}
		)
		    |
		(
			enumLiteral_4='MIMETYPE'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getMimetypeEnumLiteralDeclaration_4().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_4, grammarAccess.getConstraintIntervalTypeAccess().getMimetypeEnumLiteralDeclaration_4());
			}
		)
		    |
		(
			enumLiteral_5='SCALING'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getScalingEnumLiteralDeclaration_5().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_5, grammarAccess.getConstraintIntervalTypeAccess().getScalingEnumLiteralDeclaration_5());
			}
		)
		    |
		(
			enumLiteral_6='DEFAULT'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getDefaultEnumLiteralDeclaration_6().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_6, grammarAccess.getConstraintIntervalTypeAccess().getDefaultEnumLiteralDeclaration_6());
			}
		)
		    |
		(
			enumLiteral_7='NULLABLE'
			{
				$current = grammarAccess.getConstraintIntervalTypeAccess().getNullableEnumLiteralDeclaration_7().getEnumLiteral().getInstance();
				newLeafNode(enumLiteral_7, grammarAccess.getConstraintIntervalTypeAccess().getNullableEnumLiteralDeclaration_7());
			}
		)
	)
;

RULE_SIGNEDINT : '-' RULE_INT;

RULE_FLOAT : '-'? RULE_INT '.' RULE_INT;

fragment RULE_DATE : '0'..'9' '0'..'9' '0'..'9' '0'..'9' '-' '0'..'9' '0'..'9' '-' '0'..'9' '0'..'9';

fragment RULE_TIME : '0'..'9' '0'..'9' ':' '0'..'9' '0'..'9' ':' '0'..'9' '0'..'9' RULE_TIMEZONE?;

fragment RULE_TIMEZONE : ('Z'|('+'|'-') '0'..'9' '0'..'9' ':' '0'..'9' '0'..'9');

RULE_DATETIME : RULE_DATE 'T' RULE_TIME;

RULE_VERSION : ('0'..'9')* '.' ('0'..'9')* '.' ('0'..'9')* ('-' RULE_ID)?;

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_STRING : ('"' ('\\' .|~(('\\'|'"')))* '"'|'\'' ('\\' .|~(('\\'|'\'')))* '\'');

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
