/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.core.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.functionblock.Configuration;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockFactory;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.Status;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.model.ModelFactory;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelReference;

public class ModelConversionUtils {
    public static FunctionblockModel convertToFlatHierarchy(FunctionblockModel fbm) {
        FunctionBlock fb = fbm.getFunctionblock();
        List<Property> properties = ModelConversionUtils.getFlatProperties(fbm);
        if (fbm.getSuperType() != null) {
            ModelConversionUtils.removeSuperTypeModelReference(fbm);
        }
        properties.stream().filter(p -> p.getType() instanceof ObjectPropertyType).forEach(p -> ModelConversionUtils.createReference(fbm, (ObjectPropertyType)p.getType()));
        Status status = FunctionblockFactory.eINSTANCE.createStatus();
        status.getProperties().addAll((Collection)properties.stream().filter(p -> p.eContainer() instanceof Status).collect(Collectors.toList()));
        fb.setStatus(status);
        Configuration configuration = FunctionblockFactory.eINSTANCE.createConfiguration();
        configuration.getProperties().addAll((Collection)properties.stream().filter(p -> p.eContainer() instanceof Configuration).collect(Collectors.toList()));
        fb.setConfiguration(configuration);
        List<Operation> operations = ModelConversionUtils.getFlatOperations(fbm);
        fb.getOperations().clear();
        fb.getOperations().addAll(operations);
        return fbm;
    }

    private static void removeSuperTypeModelReference(FunctionblockModel fbm) {
        Iterator iter = fbm.getReferences().iterator();
        while (iter.hasNext()) {
            ModelReference reference = (ModelReference)iter.next();
            ModelReference superTypeReference = ModelIdFactory.newInstance(fbm.getSuperType()).asModelReference();
            if (!EcoreUtil.equals((EObject)superTypeReference, (EObject)reference)) continue;
            iter.remove();
        }
    }

    private static void createReference(FunctionblockModel fbm, ObjectPropertyType type) {
        ModelReference reference = ModelFactory.eINSTANCE.createModelReference();
        reference.setImportedNamespace(String.valueOf(type.getType().getNamespace()) + "." + type.getType().getName());
        reference.setVersion(type.getType().getVersion());
        fbm.getReferences().add((Object)reference);
    }

    private static List<Operation> getFlatOperations(FunctionblockModel fbm) {
        ArrayList<Operation> operations = new ArrayList<Operation>();
        TreeIterator iter = fbm.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof Operation)) continue;
            operations.add((Operation)obj);
        }
        if (fbm.getSuperType() != null) {
            operations.addAll(ModelConversionUtils.getFlatOperations(fbm.getSuperType()));
        }
        return operations;
    }

    public static InformationModel convertToFlatHierarchy(InformationModel infomodel) {
        for (FunctionblockProperty fbProperty : infomodel.getProperties()) {
            FunctionblockModel fbm = fbProperty.getType();
            fbProperty.setType(ModelConversionUtils.convertToFlatHierarchy(fbm));
            if (fbProperty.getExtendedFunctionBlock() == null || fbProperty.getExtendedFunctionBlock().getStatus() == null) continue;
            for (Property extendedProperty : fbProperty.getExtendedFunctionBlock().getStatus().getProperties()) {
                Optional<Property> baseProperty = fbm.getFunctionblock().getStatus().getProperties().stream().filter(p -> p.getName().equals(extendedProperty.getName())).findFirst();
                if (!baseProperty.isPresent()) continue;
                baseProperty.get().setConstraintRule(extendedProperty.getConstraintRule());
            }
        }
        return infomodel;
    }

    private static List<Property> getFlatProperties(FunctionblockModel fbm) {
        ArrayList<Property> properties = new ArrayList<Property>();
        TreeIterator iter = fbm.eAllContents();
        while (iter.hasNext()) {
            ObjectPropertyType objectType;
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof Property)) continue;
            Property property = (Property)obj;
            properties.add(property);
            if (!(property.getType() instanceof ObjectPropertyType) || !((objectType = (ObjectPropertyType)property.getType()).getType() instanceof Entity)) continue;
            Entity entity = (Entity)((ObjectPropertyType)property.getType()).getType();
            List<Property> entityProperties = ModelConversionUtils.getFlatProperties(entity);
            entity.getProperties().addAll(entityProperties);
            if (entity.getSuperType() != null) {
                ModelConversionUtils.removeSuperTypeModelReference(entity);
            }
            entity.getProperties().stream().filter(p -> p.getType() instanceof ObjectPropertyType).forEach(p -> ModelConversionUtils.createReference(entity, (ObjectPropertyType)p.getType()));
        }
        if (fbm.getSuperType() != null) {
            properties.addAll(ModelConversionUtils.getFlatProperties(fbm.getSuperType()));
        }
        return properties;
    }

    private static void removeSuperTypeModelReference(Entity entity) {
        Iterator iter = entity.getReferences().iterator();
        while (iter.hasNext()) {
            ModelReference reference = (ModelReference)iter.next();
            ModelReference superTypeReference = ModelIdFactory.newInstance(entity.getSuperType()).asModelReference();
            if (!EcoreUtil.equals((EObject)superTypeReference, (EObject)reference)) continue;
            iter.remove();
        }
    }

    private static void createReference(Entity entity, ObjectPropertyType type) {
        ModelReference reference = ModelFactory.eINSTANCE.createModelReference();
        reference.setImportedNamespace(String.valueOf(type.getType().getNamespace()) + "." + type.getType().getName());
        reference.setVersion(type.getType().getVersion());
        entity.getReferences().add((Object)reference);
    }

    private static List<Property> getFlatProperties(Entity entity) {
        ArrayList<Property> properties = new ArrayList<Property>();
        TreeIterator iter = entity.eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof Property)) continue;
            Property property = (Property)obj;
            properties.add(property);
        }
        if (entity.getSuperType() != null) {
            properties.addAll(ModelConversionUtils.getFlatProperties(entity.getSuperType()));
        }
        return properties;
    }
}

