/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.xml.ws.WebServiceRef;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Introspection;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class DefaultInstanceManager
implements InstanceManager {
    private static final AnnotationCacheEntry[] ANNOTATIONS_EMPTY = new AnnotationCacheEntry[0];
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private final javax.naming.Context context;
    private final Map<String, Map<String, String>> injectionMap;
    protected final ClassLoader classLoader;
    protected final ClassLoader containerClassLoader;
    protected boolean privileged;
    protected boolean ignoreAnnotations;
    private final Properties restrictedFilters = new Properties();
    private final Properties restrictedListeners = new Properties();
    private final Properties restrictedServlets = new Properties();
    private final Map<Class<?>, AnnotationCacheEntry[]> annotationCache = new WeakHashMap();
    private final Map<String, String> postConstructMethods;
    private final Map<String, String> preDestroyMethods;

    public DefaultInstanceManager(javax.naming.Context context, Map<String, Map<String, String>> injectionMap, Context catalinaContext, ClassLoader containerClassLoader) {
        InputStream is;
        this.classLoader = catalinaContext.getLoader().getClassLoader();
        this.privileged = catalinaContext.getPrivileged();
        this.containerClassLoader = containerClassLoader;
        this.ignoreAnnotations = catalinaContext.getIgnoreAnnotations();
        StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedServlets.properties");
            if (is != null) {
                this.restrictedServlets.load(is);
            } else {
                catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedServletsResource"));
            }
        }
        catch (IOException e) {
            catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedServletsResource"), (Throwable)e);
        }
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedListeners.properties");
            if (is != null) {
                this.restrictedListeners.load(is);
            } else {
                catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedListenersResources"));
            }
        }
        catch (IOException e) {
            catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedListenersResources"), (Throwable)e);
        }
        try {
            is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/core/RestrictedFilters.properties");
            if (is != null) {
                this.restrictedFilters.load(is);
            } else {
                catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedFiltersResource"));
            }
        }
        catch (IOException e) {
            catalinaContext.getLogger().error((Object)sm.getString("defaultInstanceManager.restrictedServletsResources"), (Throwable)e);
        }
        this.context = context;
        this.injectionMap = injectionMap;
        this.postConstructMethods = catalinaContext.findPostConstructMethods();
        this.preDestroyMethods = catalinaContext.findPreDestroyMethods();
    }

    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
        return this.newInstance(clazz.newInstance(), clazz);
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = this.loadClassMaybePrivileged(className, this.classLoader);
        return this.newInstance(clazz.newInstance(), clazz);
    }

    public Object newInstance(String className, ClassLoader classLoader) throws IllegalAccessException, NamingException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class<?> clazz = classLoader.loadClass(className);
        return this.newInstance(clazz.newInstance(), clazz);
    }

    public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
        this.newInstance(o, o.getClass());
    }

    private Object newInstance(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (!this.ignoreAnnotations) {
            Map<String, String> injections = this.assembleInjectionsFromClassHierarchy(clazz);
            this.populateAnnotationsCache(clazz, injections);
            this.processAnnotations(instance, injections);
            this.postConstruct(instance, clazz);
        }
        return instance;
    }

    private Map<String, String> assembleInjectionsFromClassHierarchy(Class<?> clazz) {
        HashMap<String, String> injections = new HashMap<String, String>();
        Map<String, String> currentInjections = null;
        while (clazz != null) {
            currentInjections = this.injectionMap.get(clazz.getName());
            if (currentInjections != null) {
                injections.putAll(currentInjections);
            }
            clazz = clazz.getSuperclass();
        }
        return injections;
    }

    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        if (!this.ignoreAnnotations) {
            this.preDestroy(instance, instance.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postConstruct(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        AnnotationCacheEntry[] annotations;
        if (this.context == null) {
            return;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.postConstruct(instance, superClass);
        }
        Map<Class<?>, AnnotationCacheEntry[]> map = this.annotationCache;
        synchronized (map) {
            annotations = this.annotationCache.get(clazz);
        }
        for (AnnotationCacheEntry entry : annotations) {
            Method postConstruct;
            if (entry.getType() != AnnotationCacheEntryType.POST_CONSTRUCT) continue;
            Method method = postConstruct = DefaultInstanceManager.getMethod(clazz, entry);
            synchronized (method) {
                boolean accessibility = postConstruct.isAccessible();
                postConstruct.setAccessible(true);
                postConstruct.invoke(instance, new Object[0]);
                postConstruct.setAccessible(accessibility);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preDestroy(Object instance, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class) {
            this.preDestroy(instance, superClass);
        }
        AnnotationCacheEntry[] annotations = null;
        Map<Class<?>, AnnotationCacheEntry[]> map = this.annotationCache;
        synchronized (map) {
            annotations = this.annotationCache.get(clazz);
        }
        if (annotations == null) {
            return;
        }
        for (AnnotationCacheEntry entry : annotations) {
            Method preDestroy;
            if (entry.getType() != AnnotationCacheEntryType.PRE_DESTROY) continue;
            Method method = preDestroy = DefaultInstanceManager.getMethod(clazz, entry);
            synchronized (method) {
                boolean accessibility = preDestroy.isAccessible();
                preDestroy.setAccessible(true);
                preDestroy.invoke(instance, new Object[0]);
                preDestroy.setAccessible(accessibility);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateAnnotationsCache(Class<?> clazz, Map<String, String> injections) throws IllegalAccessException, InvocationTargetException, NamingException {
        ArrayList<AnnotationCacheEntry> annotations = null;
        while (clazz != null) {
            AnnotationCacheEntry[] annotationsArray = null;
            Map<Class<?>, AnnotationCacheEntry[]> map = this.annotationCache;
            synchronized (map) {
                annotationsArray = this.annotationCache.get(clazz);
            }
            if (annotationsArray == null) {
                if (annotations == null) {
                    annotations = new ArrayList<AnnotationCacheEntry>();
                } else {
                    annotations.clear();
                }
                if (this.context != null) {
                    Field[] fields;
                    for (Field field : fields = Introspection.getDeclaredFields(clazz)) {
                        Resource annotation;
                        if (injections != null && injections.containsKey(field.getName())) {
                            annotations.add(new AnnotationCacheEntry(field.getName(), null, injections.get(field.getName()), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        if (field.isAnnotationPresent(Resource.class)) {
                            annotation = field.getAnnotation(Resource.class);
                            annotations.add(new AnnotationCacheEntry(field.getName(), null, annotation.name(), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        if (field.isAnnotationPresent(EJB.class)) {
                            annotation = field.getAnnotation(EJB.class);
                            annotations.add(new AnnotationCacheEntry(field.getName(), null, annotation.name(), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        if (field.isAnnotationPresent(WebServiceRef.class)) {
                            annotation = field.getAnnotation(WebServiceRef.class);
                            annotations.add(new AnnotationCacheEntry(field.getName(), null, annotation.name(), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        if (field.isAnnotationPresent(PersistenceContext.class)) {
                            annotation = field.getAnnotation(PersistenceContext.class);
                            annotations.add(new AnnotationCacheEntry(field.getName(), null, annotation.name(), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        if (!field.isAnnotationPresent(PersistenceUnit.class)) continue;
                        annotation = field.getAnnotation(PersistenceUnit.class);
                        annotations.add(new AnnotationCacheEntry(field.getName(), null, annotation.name(), AnnotationCacheEntryType.FIELD));
                    }
                }
                Method[] methods = Introspection.getDeclaredMethods(clazz);
                Method postConstruct = null;
                String postConstructFromXml = this.postConstructMethods.get(clazz.getName());
                Method preDestroy = null;
                String preDestroyFromXml = this.preDestroyMethods.get(clazz.getName());
                for (Method method : methods) {
                    if (this.context != null) {
                        Resource annotation;
                        String fieldName;
                        if (injections != null && Introspection.isValidSetter(method) && injections.containsKey(fieldName = Introspection.getPropertyName(method))) {
                            annotations.add(new AnnotationCacheEntry(method.getName(), method.getParameterTypes(), injections.get(fieldName), AnnotationCacheEntryType.SETTER));
                            continue;
                        }
                        if (method.isAnnotationPresent(Resource.class)) {
                            annotation = method.getAnnotation(Resource.class);
                            annotations.add(new AnnotationCacheEntry(method.getName(), method.getParameterTypes(), annotation.name(), AnnotationCacheEntryType.SETTER));
                        } else if (method.isAnnotationPresent(EJB.class)) {
                            annotation = method.getAnnotation(EJB.class);
                            annotations.add(new AnnotationCacheEntry(method.getName(), method.getParameterTypes(), annotation.name(), AnnotationCacheEntryType.SETTER));
                        } else if (method.isAnnotationPresent(WebServiceRef.class)) {
                            annotation = method.getAnnotation(WebServiceRef.class);
                            annotations.add(new AnnotationCacheEntry(method.getName(), method.getParameterTypes(), annotation.name(), AnnotationCacheEntryType.SETTER));
                        } else if (method.isAnnotationPresent(PersistenceContext.class)) {
                            annotation = method.getAnnotation(PersistenceContext.class);
                            annotations.add(new AnnotationCacheEntry(method.getName(), method.getParameterTypes(), annotation.name(), AnnotationCacheEntryType.SETTER));
                        } else if (method.isAnnotationPresent(PersistenceUnit.class)) {
                            annotation = method.getAnnotation(PersistenceUnit.class);
                            annotations.add(new AnnotationCacheEntry(method.getName(), method.getParameterTypes(), annotation.name(), AnnotationCacheEntryType.SETTER));
                        }
                    }
                    postConstruct = DefaultInstanceManager.findPostConstruct(postConstruct, postConstructFromXml, method);
                    preDestroy = DefaultInstanceManager.findPreDestroy(preDestroy, preDestroyFromXml, method);
                }
                if (postConstruct != null) {
                    annotations.add(new AnnotationCacheEntry(postConstruct.getName(), postConstruct.getParameterTypes(), null, AnnotationCacheEntryType.POST_CONSTRUCT));
                } else if (postConstructFromXml != null) {
                    throw new IllegalArgumentException("Post construct method " + postConstructFromXml + " for class " + clazz.getName() + " is declared in deployment descriptor but cannot be found.");
                }
                if (preDestroy != null) {
                    annotations.add(new AnnotationCacheEntry(preDestroy.getName(), preDestroy.getParameterTypes(), null, AnnotationCacheEntryType.PRE_DESTROY));
                } else if (preDestroyFromXml != null) {
                    throw new IllegalArgumentException("Pre destroy method " + preDestroyFromXml + " for class " + clazz.getName() + " is declared in deployment descriptor but cannot be found.");
                }
                annotationsArray = annotations.isEmpty() ? ANNOTATIONS_EMPTY : annotations.toArray(new AnnotationCacheEntry[annotations.size()]);
                Map<Class<?>, AnnotationCacheEntry[]> map2 = this.annotationCache;
                synchronized (map2) {
                    this.annotationCache.put(clazz, annotationsArray);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotations(Object instance, Map<String, String> injections) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            AnnotationCacheEntry[] annotations;
            Map<Class<?>, AnnotationCacheEntry[]> map = this.annotationCache;
            synchronized (map) {
                annotations = this.annotationCache.get(clazz);
            }
            for (AnnotationCacheEntry entry : annotations) {
                if (entry.getType() == AnnotationCacheEntryType.SETTER) {
                    DefaultInstanceManager.lookupMethodResource(this.context, instance, DefaultInstanceManager.getMethod(clazz, entry), entry.getName(), clazz);
                    continue;
                }
                if (entry.getType() != AnnotationCacheEntryType.FIELD) continue;
                DefaultInstanceManager.lookupFieldResource(this.context, instance, DefaultInstanceManager.getField(clazz, entry), entry.getName(), clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAnnotationCacheSize() {
        Map<Class<?>, AnnotationCacheEntry[]> map = this.annotationCache;
        synchronized (map) {
            return this.annotationCache.size();
        }
    }

    protected Class<?> loadClassMaybePrivileged(final String className, final ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws Exception {
                        return DefaultInstanceManager.this.loadClass(className, classLoader);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)t;
                }
                throw new RuntimeException(t);
            }
        } else {
            clazz = this.loadClass(className, classLoader);
        }
        this.checkAccess(clazz);
        return clazz;
    }

    protected Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className.startsWith("org.apache.catalina")) {
            return this.containerClassLoader.loadClass(className);
        }
        try {
            Class<?> clazz = this.containerClassLoader.loadClass(className);
            if (ContainerServlet.class.isAssignableFrom(clazz)) {
                return clazz;
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
        }
        return classLoader.loadClass(className);
    }

    private void checkAccess(Class<?> clazz) {
        if (this.privileged) {
            return;
        }
        if (Filter.class.isAssignableFrom(clazz)) {
            this.checkAccess(clazz, this.restrictedFilters);
        } else if (Servlet.class.isAssignableFrom(clazz)) {
            if (ContainerServlet.class.isAssignableFrom(clazz)) {
                throw new SecurityException("Restricted (ContainerServlet) " + clazz);
            }
            this.checkAccess(clazz, this.restrictedServlets);
        } else {
            this.checkAccess(clazz, this.restrictedListeners);
        }
    }

    private void checkAccess(Class<?> clazz, Properties restricted) {
        while (clazz != null) {
            if ("restricted".equals(restricted.getProperty(clazz.getName()))) {
                throw new SecurityException("Restricted " + clazz);
            }
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void lookupFieldResource(javax.naming.Context context, Object instance, Field field, String name, Class<?> clazz) throws NamingException, IllegalAccessException {
        String normalizedName = DefaultInstanceManager.normalize(name);
        Object lookedupResource = normalizedName != null && normalizedName.length() > 0 ? context.lookup(normalizedName) : context.lookup(clazz.getName() + "/" + field.getName());
        Field field2 = field;
        synchronized (field2) {
            boolean accessibility = field.isAccessible();
            field.setAccessible(true);
            field.set(instance, lookedupResource);
            field.setAccessible(accessibility);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void lookupMethodResource(javax.naming.Context context, Object instance, Method method, String name, Class<?> clazz) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!Introspection.isValidSetter(method)) {
            throw new IllegalArgumentException(sm.getString("defaultInstanceManager.invalidInjection"));
        }
        String normalizedName = DefaultInstanceManager.normalize(name);
        Object lookedupResource = normalizedName != null && normalizedName.length() > 0 ? context.lookup(normalizedName) : context.lookup(clazz.getName() + "/" + Introspection.getPropertyName(method));
        Method method2 = method;
        synchronized (method2) {
            boolean accessibility = method.isAccessible();
            method.setAccessible(true);
            method.invoke(instance, lookedupResource);
            method.setAccessible(accessibility);
        }
    }

    @Deprecated
    public static String getName(Method setter) {
        return Introspector.decapitalize(setter.getName().substring(3));
    }

    private static String normalize(String jndiName) {
        if (jndiName != null && jndiName.startsWith("java:comp/env/")) {
            return jndiName.substring(14);
        }
        return jndiName;
    }

    private static Method getMethod(final Class<?> clazz, final AnnotationCacheEntry entry) {
        Method result = null;
        if (Globals.IS_SECURITY_ENABLED) {
            result = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    Method result = null;
                    try {
                        result = clazz.getDeclaredMethod(entry.getAccessibleObjectName(), entry.getParamTypes());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    return result;
                }
            });
        } else {
            try {
                result = clazz.getDeclaredMethod(entry.getAccessibleObjectName(), entry.getParamTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return result;
    }

    private static Field getField(final Class<?> clazz, final AnnotationCacheEntry entry) {
        Field result = null;
        if (Globals.IS_SECURITY_ENABLED) {
            result = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    Field result = null;
                    try {
                        result = clazz.getDeclaredField(entry.getAccessibleObjectName());
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    return result;
                }
            });
        } else {
            try {
                result = clazz.getDeclaredField(entry.getAccessibleObjectName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return result;
    }

    private static Method findPostConstruct(Method currentPostConstruct, String postConstructFromXml, Method method) {
        return DefaultInstanceManager.findLifecycleCallback(currentPostConstruct, postConstructFromXml, method, PostConstruct.class);
    }

    private static Method findPreDestroy(Method currentPreDestroy, String preDestroyFromXml, Method method) {
        return DefaultInstanceManager.findLifecycleCallback(currentPreDestroy, preDestroyFromXml, method, PreDestroy.class);
    }

    private static Method findLifecycleCallback(Method currentMethod, String methodNameFromXml, Method method, Class<? extends Annotation> annotation) {
        Method result = currentMethod;
        if (methodNameFromXml != null) {
            if (method.getName().equals(methodNameFromXml)) {
                if (!Introspection.isValidLifecycleCallback(method)) {
                    throw new IllegalArgumentException("Invalid " + annotation.getName() + " annotation");
                }
                result = method;
            }
        } else if (method.isAnnotationPresent(annotation)) {
            if (currentMethod != null || !Introspection.isValidLifecycleCallback(method)) {
                throw new IllegalArgumentException("Invalid " + annotation.getName() + " annotation");
            }
            result = method;
        }
        return result;
    }

    private static final class AnnotationCacheEntry {
        private final String accessibleObjectName;
        private final Class<?>[] paramTypes;
        private final String name;
        private final AnnotationCacheEntryType type;

        public AnnotationCacheEntry(String accessibleObjectName, Class<?>[] paramTypes, String name, AnnotationCacheEntryType type) {
            this.accessibleObjectName = accessibleObjectName;
            this.paramTypes = paramTypes;
            this.name = name;
            this.type = type;
        }

        public String getAccessibleObjectName() {
            return this.accessibleObjectName;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public String getName() {
            return this.name;
        }

        public AnnotationCacheEntryType getType() {
            return this.type;
        }
    }

    private static enum AnnotationCacheEntryType {
        FIELD,
        SETTER,
        POST_CONSTRUCT,
        PRE_DESTROY;

    }
}

