/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.deployment.StereoTypeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeforeBeanDiscoveryImpl
implements BeforeBeanDiscovery {
    private BeanManagerImpl beanManager = null;
    private final WebBeansContext webBeansContext;

    public BeforeBeanDiscoveryImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
    }

    public void addAnnotatedType(AnnotatedType<?> type) {
        this.beanManager.addAdditionalAnnotatedType(type);
    }

    public void addQualifier(Class<? extends Annotation> qualifier) {
        this.beanManager.addAdditionalQualifier(qualifier);
    }

    public void addInterceptorBinding(Class<? extends Annotation> binding, Annotation ... bindingDef) {
        this.webBeansContext.getBeanManagerImpl().addInterceptorBindingType(binding, bindingDef);
    }

    public void addScope(Class<? extends Annotation> scope, boolean normal, boolean passivating) {
        ExternalScope additionalScope = new ExternalScope(scope, normal, passivating);
        this.beanManager.addAdditionalScope(additionalScope);
    }

    public void addStereotype(Class<? extends Annotation> stereotype, Annotation ... stereotypeDef) {
        this.webBeansContext.getAnnotationManager().checkStereoTypeClass(stereotype, stereotypeDef);
        StereoTypeModel model = new StereoTypeModel(this.webBeansContext, stereotype, stereotypeDef);
        this.webBeansContext.getStereoTypeManager().addStereoTypeModel(model);
    }
}

