/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import org.apache.derby.client.am.Utils;

public class Types {
    public static final int BIT = -7;
    public static final int BOOLEAN = 16;
    public static final int SMALLINT = 5;
    public static final int INTEGER = 4;
    public static final int BIGINT = -5;
    public static final int REAL = 7;
    public static final int DOUBLE = 8;
    public static final int DECIMAL = 3;
    public static final int CHAR = 1;
    public static final int VARCHAR = 12;
    public static final int LONGVARCHAR = -1;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int BINARY = -2;
    public static final int VARBINARY = -3;
    public static final int LONGVARBINARY = -4;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int JAVA_OBJECT = 2000;

    private Types() {
    }

    public static String getTypeString(int n) {
        switch (n) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case -7: 
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case 2003: {
                return "ARRAY";
            }
            case 70: {
                return "DATALINK";
            }
            case 2006: {
                return "REF";
            }
            case -8: {
                return "ROWID";
            }
            case 2009: {
                return "SQLXML";
            }
            case 2002: {
                return "STRUCT";
            }
        }
        return "<UNKNOWN>";
    }

    public static int mapDERBYTypeToDriverType(boolean bl, int n, long l, int n2) {
        switch (Utils.getNonNullableSqlType(n)) {
            case 2436: {
                return 16;
            }
            case 500: {
                return 5;
            }
            case 496: {
                return 4;
            }
            case 492: {
                return -5;
            }
            case 480: {
                if (l == 16L) {
                    return 3;
                }
                if (l == 8L) {
                    return 8;
                }
                if (l == 4L) {
                    return 7;
                }
                return 0;
            }
            case 484: 
            case 504: {
                return 3;
            }
            case 452: {
                if (bl && (n2 == 65535 || n2 == 0)) {
                    return -2;
                }
                return 1;
            }
            case 460: {
                return 1;
            }
            case 448: {
                if (bl && (n2 == 65535 || n2 == 0)) {
                    return -3;
                }
                return 12;
            }
            case 456: {
                if (bl && (n2 == 65535 || n2 == 0)) {
                    return -4;
                }
                return -1;
            }
            case 384: {
                return 91;
            }
            case 388: {
                return 92;
            }
            case 392: {
                return 93;
            }
            case 408: {
                return 2005;
            }
            case 404: {
                return 2004;
            }
            case 2000: {
                return 2000;
            }
        }
        return 0;
    }
}

