/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.invalidation;

import java.util.Calendar;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.internal.identitymaps.CacheKey;

public class DailyCacheInvalidationPolicy
extends CacheInvalidationPolicy {
    protected Calendar expiryTime = null;
    protected Calendar previousExpiry = null;

    public DailyCacheInvalidationPolicy() {
        this.expiryTime = Calendar.getInstance();
        this.previousExpiry = (Calendar)this.expiryTime.clone();
        this.previousExpiry.add(6, -1);
    }

    public DailyCacheInvalidationPolicy(int hour, int minute, int second, int millisecond) {
        this.setExpiryTime(hour, minute, second, millisecond);
    }

    @Override
    public long getExpiryTimeInMillis(CacheKey key) {
        this.incrementExpiry();
        return this.expiryTime.getTimeInMillis();
    }

    public Calendar getExpiryTime() {
        return this.expiryTime;
    }

    @Override
    public boolean isInvalidated(CacheKey key, long currentTimeMillis) {
        if (key.getInvalidationState() == -1) {
            return true;
        }
        long expiryMillis = this.expiryTime.getTimeInMillis();
        long readTime = key.getReadTime();
        if (currentTimeMillis < expiryMillis) {
            long previousExpiryMillis = this.previousExpiry.getTimeInMillis();
            if (readTime >= previousExpiryMillis) {
                return false;
            }
            return currentTimeMillis >= previousExpiryMillis;
        }
        if (readTime < expiryMillis) {
            this.incrementExpiry();
            return true;
        }
        this.incrementExpiry();
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void incrementExpiry() {
        currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis > (expiryInMillis = this.expiryTime.getTimeInMillis())) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            this.previousExpiry.add(6, 1);
            this.expiryTime.add(6, 1);
lbl6:
            // 2 sources

            ** while (currentTimeMillis > this.expiryTime.getTimeInMillis())
        }
lbl7:
        // 1 sources

    }

    public void setExpiryTime(int hour, int minute, int second, int millisecond) {
        this.expiryTime = Calendar.getInstance();
        this.expiryTime.set(11, hour);
        this.expiryTime.set(12, minute);
        this.expiryTime.set(13, second);
        this.expiryTime.set(14, millisecond);
        this.previousExpiry = (Calendar)this.expiryTime.clone();
        this.previousExpiry.add(6, -1);
        this.incrementExpiry();
    }

    public void setExpiryTime(Calendar calendar) {
        this.setExpiryTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }
}

