/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class SpecialFunctionNode
extends ValueNode {
    String sqlName;
    private String methodName;
    private String methodType;

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector vector) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor;
        int n = this.getNodeType();
        switch (n) {
            case 109: 
            case 110: 
            case 126: {
                switch (n) {
                    case 110: {
                        this.sqlName = "USER";
                        break;
                    }
                    case 109: {
                        this.sqlName = "CURRENT_USER";
                        break;
                    }
                    case 126: {
                        this.sqlName = "SYSTEM_USER";
                    }
                }
                this.methodName = "getCurrentUserId";
                this.methodType = "java.lang.String";
                dataTypeDescriptor = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 125: {
                this.methodName = "getSessionUserId";
                this.methodType = "java.lang.String";
                this.sqlName = "SESSION_USER";
                dataTypeDescriptor = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 6: {
                this.sqlName = "CURRENT SCHEMA";
                this.methodName = "getCurrentSchemaName";
                this.methodType = "java.lang.String";
                dataTypeDescriptor = DataDictionary.TYPE_SYSTEM_IDENTIFIER;
                break;
            }
            case 210: {
                this.sqlName = "CURRENT_ROLE";
                this.methodName = "getCurrentRoleIdDelimited";
                this.methodType = "java.lang.String";
                dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, 258);
                break;
            }
            case 5: {
                this.sqlName = "IDENTITY_VAL_LOCAL";
                this.methodName = "getIdentityValue";
                this.methodType = "java.lang.Long";
                dataTypeDescriptor = DataTypeDescriptor.getSQLDataTypeDescriptor("java.math.BigDecimal", 31, 0, true, 31);
                break;
            }
            case 4: {
                this.sqlName = "CURRENT ISOLATION";
                this.methodName = "getCurrentIsolationLevelStr";
                this.methodType = "java.lang.String";
                dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 2);
                break;
            }
            default: {
                dataTypeDescriptor = null;
            }
        }
        this.checkReliability(this.sqlName, 64);
        this.setType(dataTypeDescriptor);
        return this;
    }

    protected int getOrderableVariantType() {
        return 2;
    }

    public void generateExpression(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        methodBuilder.pushThis();
        methodBuilder.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        int n = 0;
        if (this.methodName.equals("getCurrentRoleIdDelimited") || this.methodName.equals("getCurrentSchemaName") || this.methodName.equals("getCurrentUserId")) {
            expressionClassBuilder.pushThisAsActivation(methodBuilder);
            ++n;
        }
        methodBuilder.callMethod((short)185, null, this.methodName, this.methodType, n);
        String string = this.getTypeCompiler().interfaceName();
        LocalField localField = expressionClassBuilder.newFieldDeclaration(2, string);
        expressionClassBuilder.generateDataValue(methodBuilder, this.getTypeCompiler(), this.getTypeServices().getCollationType(), localField);
    }

    public String toString() {
        return "";
    }

    protected boolean isEquivalent(ValueNode valueNode) {
        if (this.isSameNodeType(valueNode)) {
            SpecialFunctionNode specialFunctionNode = (SpecialFunctionNode)valueNode;
            return this.methodName.equals(specialFunctionNode.methodName);
        }
        return false;
    }
}

