/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.ValidationException;
import javax.validation.metadata.BeanDescriptor;
import org.apache.bval.DynamicMetaBean;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.jsr303.ApacheFactoryContext;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.BeanDescriptorImpl;
import org.apache.bval.jsr303.CascadingPropertyValidator;
import org.apache.bval.jsr303.ConstraintValidationListener;
import org.apache.bval.jsr303.GroupValidationContext;
import org.apache.bval.jsr303.GroupValidationContextImpl;
import org.apache.bval.jsr303.IncompatiblePropertyValueException;
import org.apache.bval.jsr303.UnknownPropertyException;
import org.apache.bval.jsr303.groups.Group;
import org.apache.bval.jsr303.groups.Groups;
import org.apache.bval.jsr303.groups.GroupsComputer;
import org.apache.bval.jsr303.util.ClassHelper;
import org.apache.bval.jsr303.util.NodeImpl;
import org.apache.bval.jsr303.util.PathImpl;
import org.apache.bval.jsr303.util.PathNavigation;
import org.apache.bval.jsr303.util.ValidationContextTraversal;
import org.apache.bval.model.FeaturesCapable;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.AccessStrategy;
import org.apache.bval.util.ValidationHelper;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassValidator
implements CascadingPropertyValidator {
    private static final Object VALIDATE_PROPERTY = new Object(){

        public String toString() {
            return "VALIDATE_PROPERTY";
        }
    };
    protected final ApacheFactoryContext factoryContext;
    protected final GroupsComputer groupsComputer = new GroupsComputer();
    private boolean treatMapsLikeBeans = false;

    public ClassValidator(ApacheFactoryContext factoryContext) {
        this.factoryContext = factoryContext;
    }

    public ClassValidator(ApacheValidatorFactory factory) {
        this(factory.usingContext());
    }

    protected MetaBeanFinder getMetaBeanFinder() {
        return this.factoryContext.getMetaBeanFinder();
    }

    public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("cannot validate null");
        }
        this.checkGroups(groups);
        try {
            Class<?> objectClass = object.getClass();
            MetaBean objectMetaBean = this.getMetaBeanFinder().findForClass(objectClass);
            GroupValidationContext<T> context = this.createContext(objectMetaBean, object, objectClass, groups);
            ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
            Groups sequence = context.getGroups();
            for (Group group : sequence.getGroups()) {
                context.setCurrentGroup(group);
                this.validateBeanNet(context);
            }
            for (List list : sequence.getSequences()) {
                for (Group current : list) {
                    context.setCurrentGroup(current);
                    this.validateBeanNet(context);
                    if (result.isEmpty()) continue;
                    break;
                }
                if (result.isEmpty()) continue;
                break;
            }
            return result.getConstraintViolations();
        }
        catch (RuntimeException ex) {
            throw ClassValidator.unrecoverableValidationError(ex, object);
        }
    }

    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
        return this.validateProperty(object, propertyName, false, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, boolean cascade, Class<?> ... groups) {
        if (object == null) {
            throw new IllegalArgumentException("cannot validate null");
        }
        Set<ConstraintViolation<T>> result = this.validateValueImpl(object.getClass(), object, propertyName, VALIDATE_PROPERTY, cascade, groups);
        return result;
    }

    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
        return this.validateValue(beanType, propertyName, value, false, groups);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, boolean cascade, Class<?> ... groups) {
        return this.validateValueImpl(this.checkBeanType(beanType), null, propertyName, value, cascade, groups);
    }

    public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        try {
            MetaBean metaBean = this.getMetaBeanFinder().findForClass(clazz);
            BeanDescriptorImpl edesc = (BeanDescriptorImpl)metaBean.getFeature("BeanDescriptor");
            if (edesc == null) {
                edesc = this.createBeanDescriptor(metaBean);
                metaBean.putFeature("BeanDescriptor", edesc);
            }
            return edesc;
        }
        catch (RuntimeException ex) {
            throw new ValidationException("error retrieving constraints for " + clazz, (Throwable)ex);
        }
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            ClassValidator result = this;
            return (T)result;
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            return this.newInstance(type);
        }
        try {
            Class cls = ClassUtils.getClass((String)(type.getName() + "Impl"));
            if (type.isAssignableFrom(cls)) {
                Class implClass = cls;
                return this.newInstance(implClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    private <T> T newInstance(final Class<T> cls) {
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    Constructor cons = cls.getConstructor(ApacheFactoryContext.class);
                    if (!cons.isAccessible()) {
                        cons.setAccessible(true);
                    }
                    return cons.newInstance(ClassValidator.this.factoryContext);
                }
                catch (Exception ex) {
                    throw new ValidationException("Cannot instantiate : " + cls, (Throwable)ex);
                }
            }
        });
    }

    protected void validateBeanNet(GroupValidationContext<?> context) {
        if (context.getBean() == null) {
            return;
        }
        if (!context.collectValidated()) {
            return;
        }
        if (context.getCurrentGroup().isDefault()) {
            List<Group> defaultGroups = this.expandDefaultGroup(context);
            ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
            if (defaultGroups != null && defaultGroups.size() > 1) {
                int numViolations = result.violationsSize();
                Group currentGroup = context.getCurrentGroup();
                for (Group group : defaultGroups) {
                    context.setCurrentGroup(group);
                    ValidationHelper.validateBean(context);
                    if (result.violationsSize() <= numViolations) continue;
                    break;
                }
                context.setCurrentGroup(currentGroup);
            } else {
                ArrayList classHierarchy = new ArrayList();
                ClassHelper.fillFullClassHierarchyAsList(classHierarchy, context.getMetaBean().getBeanClass());
                Class<?> initialOwner = context.getCurrentOwner();
                block1: for (Class clazz : classHierarchy) {
                    context.setCurrentOwner(clazz);
                    int numViolations = result.violationsSize();
                    List ownerDefaultGroups = (List)context.getMetaBean().getFeature("{GroupSequence:" + clazz.getCanonicalName() + "}");
                    for (Group each : ownerDefaultGroups) {
                        context.setCurrentGroup(each);
                        ValidationHelper.validateBean(context);
                        if (result.violationsSize() <= numViolations) continue;
                        continue block1;
                    }
                }
                context.setCurrentOwner(initialOwner);
                context.setCurrentGroup(Group.DEFAULT);
            }
        } else {
            ValidationHelper.validateBean(context);
        }
        for (MetaProperty prop : context.getMetaBean().getProperties()) {
            this.validateCascadedBean(context, prop);
        }
    }

    private void validateCascadedBean(GroupValidationContext<?> context, MetaProperty prop) {
        AccessStrategy[] access = (AccessStrategy[])prop.getFeature("refCascade");
        if (access != null) {
            Object bean = context.getBean();
            MetaBean mbean = context.getMetaBean();
            for (AccessStrategy each : access) {
                if (!this.isCascadable(context, prop, each)) continue;
                context.moveDown(prop, each);
                ValidationHelper.validateContext(context, new Jsr303ValidationCallback(context), this.treatMapsLikeBeans);
                context.moveUp(bean, mbean);
            }
        }
    }

    private boolean isCascadable(GroupValidationContext<?> context, MetaProperty prop, AccessStrategy access) {
        PathImpl beanPath = context.getPropertyPath();
        NodeImpl node = new NodeImpl(prop.getName());
        if (beanPath == null) {
            beanPath = PathImpl.create(null);
        }
        try {
            if (!context.getTraversableResolver().isReachable(context.getBean(), (Path.Node)node, context.getRootMetaBean().getBeanClass(), (Path)beanPath, access.getElementType())) {
                return false;
            }
        }
        catch (RuntimeException e) {
            throw new ValidationException("Error in TraversableResolver.isReachable() for " + context.getBean(), (Throwable)e);
        }
        try {
            if (!context.getTraversableResolver().isCascadable(context.getBean(), (Path.Node)node, context.getRootMetaBean().getBeanClass(), (Path)beanPath, access.getElementType())) {
                return false;
            }
        }
        catch (RuntimeException e) {
            throw new ValidationException("Error TraversableResolver.isCascadable() for " + context.getBean(), (Throwable)e);
        }
        return true;
    }

    private List<Group> expandDefaultGroup(GroupValidationContext<?> context) {
        if (context.getCurrentGroup().isDefault()) {
            List groupSeq = (List)context.getMetaBean().getFeature("GroupSequence");
            if (groupSeq != null) {
                context.getGroups().assertDefaultGroupSequenceIsExpandable(groupSeq);
            }
            return groupSeq;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static RuntimeException unrecoverableValidationError(RuntimeException ex, Object object) {
        if (ex instanceof UnknownPropertyException || ex instanceof IncompatiblePropertyValueException) {
            return new IllegalArgumentException(ex.getMessage(), ex);
        }
        if (ex instanceof ValidationException) {
            return ex;
        }
        String objectId = "";
        try {
            if (object != null) {
                objectId = object.toString();
            }
            objectId = "<null>";
            return objectId;
        }
        catch (Exception e) {
            objectId = "<unknown>";
            return objectId;
        }
        finally {
            return new ValidationException("error during validation of " + objectId, (Throwable)ex);
        }
    }

    private void validatePropertyInGroup(final GroupValidationContext<?> context) {
        Runnable helper = context.getMetaProperty() == null ? new Runnable(){

            public void run() {
                ValidationHelper.validateBean(context);
            }
        } : new Runnable(){

            public void run() {
                ValidationHelper.validateProperty(context);
            }
        };
        Group currentGroup = context.getCurrentGroup();
        List<Group> defaultGroups = this.expandDefaultGroup(context);
        if (defaultGroups != null) {
            for (Group each : defaultGroups) {
                context.setCurrentGroup(each);
                helper.run();
            }
            context.setCurrentGroup(currentGroup);
        } else {
            helper.run();
        }
    }

    protected <T> GroupValidationContext<T> createContext(MetaBean metaBean, T object, Class<T> objectClass, Class<?> ... groups) {
        ConstraintValidationListener<T> listener = new ConstraintValidationListener<T>(object, objectClass);
        GroupValidationContextImpl<T> context = new GroupValidationContextImpl<T>(listener, this.factoryContext.getMessageInterpolator(), this.factoryContext.getTraversableResolver(), metaBean);
        context.setBean(object, metaBean);
        context.setGroups(this.groupsComputer.computeGroups(groups));
        return context;
    }

    protected BeanDescriptorImpl createBeanDescriptor(MetaBean metaBean) {
        return new BeanDescriptorImpl(this.factoryContext, metaBean);
    }

    public boolean isTreatMapsLikeBeans() {
        return this.treatMapsLikeBeans;
    }

    public void setTreatMapsLikeBeans(boolean treatMapsLikeBeans) {
        this.treatMapsLikeBeans = treatMapsLikeBeans;
    }

    private <T> Class<T> checkBeanType(Class<T> beanType) {
        if (beanType == null) {
            throw new IllegalArgumentException("Bean type cannot be null.");
        }
        return beanType;
    }

    private void checkPropertyName(String propertyName) {
        if (propertyName == null || propertyName.trim().length() == 0) {
            throw new IllegalArgumentException("Property path cannot be null or empty.");
        }
    }

    private void checkGroups(Class<?>[] groups) {
        if (groups == null) {
            throw new IllegalArgumentException("Groups cannot be null.");
        }
    }

    protected ValidationContextTraversal createValidationContextTraversal(GroupValidationContext<?> validationContext) {
        return new ValidationContextTraversal(validationContext);
    }

    private <T> Set<ConstraintViolation<T>> validateValueImpl(Class<T> beanType, T object, String propertyName, Object value, boolean cascade, Class<?> ... groups) {
        assert (object == null ^ value == VALIDATE_PROPERTY);
        this.checkPropertyName(propertyName);
        this.checkGroups(groups);
        try {
            DynamicMetaBean initialMetaBean = new DynamicMetaBean(this.getMetaBeanFinder());
            initialMetaBean.setBeanClass(beanType);
            GroupValidationContext<T> context = this.createContext(initialMetaBean, object, beanType, groups);
            ValidationContextTraversal contextTraversal = this.createValidationContextTraversal(context);
            PathNavigation.navigate(propertyName, contextTraversal);
            MetaProperty prop = context.getMetaProperty();
            boolean fixed = false;
            if (value != VALIDATE_PROPERTY) {
                assert (!context.getPropertyPath().isRootPath());
                if (prop == null && value != null) {
                    context.setMetaBean(this.getMetaBeanFinder().findForClass(value.getClass()));
                }
                if (!cascade) {
                    FeaturesCapable meta;
                    FeaturesCapable featuresCapable = meta = prop == null ? context.getMetaBean() : prop;
                    if (ArrayUtils.isEmpty((Object[])meta.getValidations())) {
                        return Collections.emptySet();
                    }
                }
                if (!TypeUtils.isAssignable(value == null ? null : value.getClass(), (Type)contextTraversal.getType())) {
                    throw new IncompatiblePropertyValueException(String.format("%3$s is not a valid value for property %2$s of type %1$s", beanType, propertyName, value));
                }
                if (prop == null) {
                    context.setBean(value);
                } else {
                    context.setFixedValue(value);
                    fixed = true;
                }
            }
            boolean doCascade = cascade && (prop == null || prop.getMetaBean() != null);
            Object bean = context.getBean();
            ConstraintValidationListener result = (ConstraintValidationListener)context.getListener();
            Groups sequence = context.getGroups();
            for (Group current : sequence.getGroups()) {
                context.setCurrentGroup(current);
                if (!doCascade || prop != null) {
                    this.validatePropertyInGroup(context);
                }
                if (!doCascade) continue;
                contextTraversal.moveDownIfNecessary();
                if (context.getMetaBean() instanceof DynamicMetaBean) {
                    context.setMetaBean(context.getMetaBean().resolveMetaBean(ObjectUtils.defaultIfNull((Object)context.getBean(), contextTraversal.getRawType())));
                }
                this.validateBeanNet(context);
                if (prop == null) continue;
                context.moveUp(bean, prop.getParentMetaBean());
                context.setMetaProperty(prop);
                if (!fixed) continue;
                context.setFixedValue(value);
            }
            int groupViolations = result.getConstraintViolations().size();
            block3: for (List<Group> eachSeq : sequence.getSequences()) {
                for (Group current : eachSeq) {
                    context.setCurrentGroup(current);
                    if (!doCascade || prop != null) {
                        this.validatePropertyInGroup(context);
                    }
                    if (doCascade) {
                        contextTraversal.moveDownIfNecessary();
                        if (context.getMetaBean() instanceof DynamicMetaBean) {
                            context.setMetaBean(context.getMetaBean().resolveMetaBean(ObjectUtils.defaultIfNull((Object)context.getBean(), contextTraversal.getRawType())));
                        }
                        this.validateBeanNet(context);
                        if (prop != null) {
                            context.moveUp(bean, prop.getParentMetaBean());
                            context.setMetaProperty(prop);
                            if (fixed) {
                                context.setFixedValue(value);
                            }
                        }
                    }
                    if (result.getConstraintViolations().size() <= groupViolations) continue;
                    break block3;
                }
            }
            return result.getConstraintViolations();
        }
        catch (RuntimeException ex) {
            throw ClassValidator.unrecoverableValidationError(ex, ObjectUtils.defaultIfNull(object, (Object)value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Jsr303ValidationCallback
    implements ValidationHelper.ValidateCallback {
        private final GroupValidationContext<?> context;

        public Jsr303ValidationCallback(GroupValidationContext<?> context) {
            this.context = context;
        }

        @Override
        public void validate() {
            ClassValidator.this.validateBeanNet(this.context);
        }
    }
}

