/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationImpl;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.eclipse.equinox.internal.cm.SerializedTaskQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.util.tracker.ServiceTracker;

class ManagedServiceTracker
extends ServiceTracker {
    final ConfigurationAdminFactory configurationAdminFactory;
    private final ConfigurationStore configurationStore;
    private final Map managedServices;
    private final Map managedServiceReferences;
    private final SerializedTaskQueue queue;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ManagedServiceTracker(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, BundleContext context) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(context, clazz.getName(), null);
        this.managedServices = new HashMap();
        this.managedServiceReferences = new HashMap();
        this.queue = new SerializedTaskQueue("ManagedService Update Queue");
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
    }

    protected void notifyDeleted(ConfigurationImpl config) {
        config.checkLocked();
        String pid = config.getPid(false);
        ServiceReference reference = this.getManagedServiceReference(pid);
        if (reference != null && config.bind(reference.getBundle())) {
            this.asynchUpdated(this.getManagedService(pid), null);
        }
    }

    protected void notifyUpdated(ConfigurationImpl config) {
        config.checkLocked();
        String pid = config.getPid();
        ServiceReference reference = this.getManagedServiceReference(pid);
        if (reference != null && config.bind(reference.getBundle())) {
            Dictionary properties = config.getProperties();
            this.configurationAdminFactory.modifyConfiguration(reference, properties);
            this.asynchUpdated(this.getManagedService(pid), properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        String pid = (String)reference.getProperty("service.pid");
        if (pid == null) {
            return null;
        }
        ManagedService service = (ManagedService)this.context.getService(reference);
        if (service == null) {
            return null;
        }
        ConfigurationStore configurationStore = this.configurationStore;
        synchronized (configurationStore) {
            this.add(reference, pid, service);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference reference, Object service) {
        String pid = (String)reference.getProperty("service.pid");
        ConfigurationStore configurationStore = this.configurationStore;
        synchronized (configurationStore) {
            if (this.getManagedService(pid) == service) {
                return;
            }
            String previousPid = this.getPidForManagedService(service);
            this.remove(reference, previousPid);
            this.addingService(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object service) {
        String pid = (String)reference.getProperty("service.pid");
        ConfigurationStore configurationStore = this.configurationStore;
        synchronized (configurationStore) {
            this.remove(reference, pid);
        }
        this.context.ungetService(reference);
    }

    private void add(ServiceReference reference, String pid, ManagedService service) {
        block14: {
            ConfigurationImpl config = this.configurationStore.findConfiguration(pid);
            if (config == null) {
                if (this.trackManagedService(pid, reference, service)) {
                    this.asynchUpdated(service, null);
                }
            } else {
                try {
                    config.lock();
                    if (!this.trackManagedService(pid, reference, service)) break block14;
                    if (config.getFactoryPid() != null) {
                        StringBuffer stringBuffer = new StringBuffer("Configuration for service.pid=").append(pid).append(" should only be used by a ");
                        Class<?> clazz = class$1;
                        if (clazz == null) {
                            try {
                                clazz = class$1 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        this.configurationAdminFactory.log(2, stringBuffer.append(clazz.getName()).toString());
                        break block14;
                    }
                    if (config.isDeleted()) {
                        this.asynchUpdated(service, null);
                    } else if (config.bind(reference.getBundle())) {
                        Dictionary properties = config.getProperties();
                        this.configurationAdminFactory.modifyConfiguration(reference, properties);
                        this.asynchUpdated(service, properties);
                    } else {
                        this.configurationAdminFactory.log(2, "Configuration for service.pid=" + pid + " could not be bound to " + reference.getBundle().getLocation());
                    }
                }
                finally {
                    config.unlock();
                }
            }
        }
    }

    private void remove(ServiceReference reference, String pid) {
        ConfigurationImpl config = this.configurationStore.findConfiguration(pid);
        if (config == null) {
            this.untrackManagedService(pid, reference);
        } else {
            try {
                config.lock();
                this.untrackManagedService(pid, reference);
            }
            finally {
                config.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean trackManagedService(String pid, ServiceReference reference, ManagedService service) {
        Map map = this.managedServiceReferences;
        synchronized (map) {
            block7: {
                if (!this.managedServiceReferences.containsKey(pid)) break block7;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.osgi.service.cm.ManagedService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                String message = String.valueOf(clazz.getName()) + " already registered for " + "service.pid" + "=" + pid;
                this.configurationAdminFactory.log(2, message);
                return false;
            }
            this.managedServiceReferences.put(pid, reference);
            this.managedServices.put(pid, service);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackManagedService(String pid, ServiceReference reference) {
        Map map = this.managedServiceReferences;
        synchronized (map) {
            this.managedServiceReferences.remove(pid);
            this.managedServices.remove(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedService getManagedService(String pid) {
        Map map = this.managedServiceReferences;
        synchronized (map) {
            return (ManagedService)this.managedServices.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceReference getManagedServiceReference(String pid) {
        Map map = this.managedServiceReferences;
        synchronized (map) {
            return (ServiceReference)this.managedServiceReferences.get(pid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPidForManagedService(Object service) {
        Map map = this.managedServiceReferences;
        synchronized (map) {
            Iterator it = this.managedServices.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() != service) continue;
                return (String)entry.getKey();
            }
            return null;
        }
    }

    private void asynchUpdated(final ManagedService service, final Dictionary properties) {
        this.queue.put(new Runnable(){

            public void run() {
                try {
                    service.updated(properties);
                }
                catch (ConfigurationException e) {
                    Throwable cause = e.getCause();
                    ManagedServiceTracker.this.configurationAdminFactory.log(1, e.getMessage(), cause != null ? cause : e);
                }
                catch (Throwable t) {
                    ManagedServiceTracker.this.configurationAdminFactory.log(1, t.getMessage(), t);
                }
            }
        });
    }
}

