/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.impl;

import com.sun.faces.facelets.Facelet;
import com.sun.faces.facelets.impl.DefaultFaceletContext;
import com.sun.faces.facelets.impl.DefaultFaceletFactory;
import com.sun.faces.facelets.impl.IdMapper;
import com.sun.faces.facelets.impl.XMLFrontMatterSaver;
import com.sun.faces.facelets.tag.jsf.ComponentSupport;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ExpressionFactory;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;

final class DefaultFacelet
extends Facelet
implements XMLFrontMatterSaver {
    private static final Logger log = FacesLogger.FACELETS_FACELET.getLogger();
    private static final String APPLIED_KEY = "com.sun.faces.facelets.APPLIED";
    private static final String JAVAX_FACES_ERROR_XHTML = "javax.faces.error.xhtml";
    private final String alias;
    private final ExpressionFactory elFactory;
    private final DefaultFaceletFactory factory;
    private final long createTime;
    private final long refreshPeriod;
    private final Map<String, URL> relativePaths;
    private final FaceletHandler root;
    private final URL src;
    private IdMapper mapper;
    private String savedDoctype;
    private String savedXMLDecl;

    public DefaultFacelet(DefaultFaceletFactory factory, ExpressionFactory el, URL src, String alias, FaceletHandler root) {
        String XMLDECL;
        this.factory = factory;
        this.elFactory = el;
        this.src = src;
        this.root = root;
        this.alias = alias;
        this.mapper = factory.idMappers.get(alias);
        this.createTime = System.currentTimeMillis();
        this.refreshPeriod = this.factory.getRefreshPeriod();
        this.relativePaths = new WeakHashMap<String, URL>();
        String DOCTYPE = Util.getDOCTYPEFromFacesContextAttributes(FacesContext.getCurrentInstance());
        if (null != DOCTYPE) {
            this.setSavedDoctype(DOCTYPE);
        }
        if (null != (XMLDECL = Util.getXMLDECLFromFacesContextAttributes(FacesContext.getCurrentInstance()))) {
            this.setSavedXMLDecl(XMLDECL);
        }
    }

    public void apply(FacesContext facesContext, UIComponent parent) throws IOException {
        IdMapper idMapper = IdMapper.getMapper(facesContext);
        boolean mapperSet = false;
        if (idMapper == null) {
            IdMapper.setMapper(facesContext, this.mapper);
            mapperSet = true;
        }
        DefaultFaceletContext ctx = new DefaultFaceletContext(facesContext, this);
        this.refresh(parent);
        ComponentSupport.markForDeletion(parent);
        this.root.apply((FaceletContext)ctx, parent);
        ComponentSupport.finalizeForDeletion(parent);
        this.markApplied(parent);
        if (mapperSet) {
            IdMapper.setMapper(facesContext, null);
        }
    }

    private void refresh(UIComponent c) {
        if (this.refreshPeriod > 0L) {
            int sz = c.getChildCount();
            if (sz > 0) {
                List cl = c.getChildren();
                while (--sz >= 0) {
                    ApplyToken token;
                    UIComponent cc = (UIComponent)cl.get(sz);
                    if (cc.isTransient() || (token = (ApplyToken)cc.getAttributes().get(APPLIED_KEY)) == null || token.time >= this.createTime || !token.alias.equals(this.alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        DateFormat df = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this.alias + "] was modified @ " + df.format(new Date(this.createTime)) + ", flushing component applied @ " + df.format(new Date(token.time)));
                    }
                    cl.remove(sz);
                }
            }
            if (c.getFacets().size() > 0) {
                Collection col = c.getFacets().values();
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    ApplyToken token;
                    UIComponent fc = (UIComponent)itr.next();
                    if (fc.isTransient() || (token = (ApplyToken)fc.getAttributes().get(APPLIED_KEY)) == null || token.time >= this.createTime || !token.alias.equals(this.alias)) continue;
                    if (log.isLoggable(Level.INFO)) {
                        DateFormat df = SimpleDateFormat.getTimeInstance();
                        log.info("Facelet[" + this.alias + "] was modified @ " + df.format(new Date(this.createTime)) + ", flushing component applied @ " + df.format(new Date(token.time)));
                    }
                    itr.remove();
                }
            }
        }
    }

    private void markApplied(UIComponent parent) {
        if (this.refreshPeriod > 0L) {
            Iterator itr = parent.getFacetsAndChildren();
            ApplyToken token = new ApplyToken(this.alias, System.currentTimeMillis() + this.refreshPeriod);
            while (itr.hasNext()) {
                Map attr;
                UIComponent c = (UIComponent)itr.next();
                if (c.isTransient() || (attr = c.getAttributes()).containsKey(APPLIED_KEY)) continue;
                attr.put(APPLIED_KEY, token);
            }
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public ExpressionFactory getExpressionFactory() {
        return this.elFactory;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    private URL getRelativePath(String path) throws IOException {
        URL url = this.relativePaths.get(path);
        if (url == null) {
            url = this.factory.resolveURL(this.src, path);
            this.relativePaths.put(path, url);
        }
        return url;
    }

    public URL getSource() {
        return this.src;
    }

    private void include(DefaultFaceletContext ctx, UIComponent parent) throws IOException {
        this.refresh(parent);
        this.root.apply((FaceletContext)new DefaultFaceletContext(ctx, this), parent);
        this.markApplied(parent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void include(DefaultFaceletContext ctx, UIComponent parent, String path) throws IOException {
        URL url;
        if (path.equals(JAVAX_FACES_ERROR_XHTML)) {
            if (!this.isDevelopment(ctx)) return;
            url = this.getErrorFacelet(DefaultFacelet.class.getClassLoader());
            if (url == null) {
                url = this.getErrorFacelet(Util.getCurrentLoader(this));
            }
        } else {
            url = this.getRelativePath(path);
        }
        this.include(ctx, parent, url);
    }

    public void include(DefaultFaceletContext ctx, UIComponent parent, URL url) throws IOException {
        DefaultFacelet f = (DefaultFacelet)this.factory.getFacelet(url);
        f.include(ctx, parent);
    }

    public String toString() {
        return this.alias;
    }

    public String getSavedDoctype() {
        return this.savedDoctype;
    }

    public void setSavedDoctype(String savedDoctype) {
        this.savedDoctype = savedDoctype;
    }

    public String getSavedXMLDecl() {
        return this.savedXMLDecl;
    }

    public void setSavedXMLDecl(String savedXMLDecl) {
        this.savedXMLDecl = savedXMLDecl;
    }

    private boolean isDevelopment(FaceletContext ctx) {
        return ctx.getFacesContext().isProjectStage(ProjectStage.Development);
    }

    private URL getErrorFacelet(ClassLoader loader) {
        return loader.getResource("META-INF/error-include.xhtml");
    }

    private static class ApplyToken
    implements Externalizable {
        public String alias;
        public long time;

        public ApplyToken() {
        }

        public ApplyToken(String alias, long time) {
            this.alias = alias;
            this.time = time;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.alias = in.readUTF();
            this.time = in.readLong();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.alias);
            out.writeLong(this.time);
        }
    }
}

