/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.remoteserviceadmin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.osgi.service.remoteserviceadmin.EndpointPermission;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EndpointPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 662615640374640621L;
    private Map<String, EndpointPermission> permissions = new HashMap<String, EndpointPermission>();
    private boolean all_allowed = false;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", class$java$util$HashMap == null ? (class$java$util$HashMap = EndpointPermissionCollection.class$("java.util.HashMap")) : class$java$util$HashMap), new ObjectStreamField("all_allowed", Boolean.TYPE)};
    static /* synthetic */ Class class$java$util$HashMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof EndpointPermission)) {
            throw new IllegalArgumentException(((Object)new StringBuffer().append("invalid permission: ").append(permission)).toString());
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        EndpointPermission ep = (EndpointPermission)permission;
        if (ep.endpoint != null) {
            throw new IllegalArgumentException(((Object)new StringBuffer().append("cannot add to collection: ").append(ep)).toString());
        }
        String name = ep.getName();
        EndpointPermissionCollection endpointPermissionCollection = this;
        synchronized (endpointPermissionCollection) {
            Map<String, EndpointPermission> pc = this.permissions;
            EndpointPermission existing = pc.get(name);
            if (existing != null) {
                int oldMask = existing.action_mask;
                int newMask = ep.action_mask;
                if (oldMask != newMask) {
                    pc.put(name, new EndpointPermission(name, oldMask | newMask));
                }
            } else {
                pc.put(name, ep);
            }
            if (!this.all_allowed && name.equals("*")) {
                this.all_allowed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        Collection<EndpointPermission> perms;
        if (!(permission instanceof EndpointPermission)) {
            return false;
        }
        EndpointPermission requested = (EndpointPermission)permission;
        if (requested.filter != null) {
            return false;
        }
        int effective = 0;
        EndpointPermissionCollection endpointPermissionCollection = this;
        synchronized (endpointPermissionCollection) {
            EndpointPermission ep;
            int desired = requested.action_mask;
            if (this.all_allowed && (ep = this.permissions.get("*")) != null && ((effective |= ep.action_mask) & desired) == desired) {
                return true;
            }
            perms = this.permissions.values();
        }
        Iterator<EndpointPermission> iter = perms.iterator();
        while (iter.hasNext()) {
            if (!iter.next().implies0(requested, effective)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Enumeration<Permission> elements() {
        ArrayList<EndpointPermission> all = new ArrayList<EndpointPermission>(this.permissions.values());
        return Collections.enumeration(all);
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField pfields = out.putFields();
        pfields.put("permissions", this.permissions);
        pfields.put("all_allowed", this.all_allowed);
        out.writeFields();
    }

    private synchronized void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gfields = in.readFields();
        this.permissions = (HashMap)gfields.get("permissions", new HashMap());
        this.all_allowed = gfields.get("all_allowed", false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

