/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractAnnotated;
import org.apache.webbeans.portable.AnnotatedTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAnnotatedMember<X>
extends AbstractAnnotated
implements AnnotatedMember<X> {
    private final AnnotatedType<X> declaringType;
    protected final Member javaMember;

    AbstractAnnotatedMember(WebBeansContext webBeansContext, Type baseType, Member javaMember, AnnotatedType<X> declaringType) {
        super(webBeansContext, baseType);
        this.javaMember = javaMember;
        if (declaringType == null) {
            this.declaringType = this.getWebBeansContext().getAnnotatedElementFactory().newAnnotatedType(this.javaMember.getDeclaringClass());
            AnnotatedTypeImpl impl = (AnnotatedTypeImpl)this.declaringType;
            if (this.javaMember instanceof Constructor) {
                impl.addAnnotatedConstructor((AnnotatedConstructor)this);
            } else if (this.javaMember instanceof Method) {
                impl.addAnnotatedMethod((AnnotatedMethod)this);
            } else if (this.javaMember instanceof Field) {
                impl.addAnnotatedField((AnnotatedField)this);
            }
        } else {
            this.declaringType = declaringType;
        }
    }

    public AnnotatedType<X> getDeclaringType() {
        return this.declaringType;
    }

    public Member getJavaMember() {
        return this.javaMember;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.javaMember.getModifiers());
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(",");
        builder.append("Java Member Name : " + this.javaMember.getName());
        return builder.toString();
    }
}

