/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.ejb.common.interceptor.OpenWebBeansEjbInterceptor;
import org.apache.webbeans.inject.AbstractInjectable;
import org.apache.webbeans.inject.OWBInjector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CdiDefaultEjbInjector {
    private final ConcurrentMap<Object, List<CreationalContextImpl<Object>>> injectedNonContextuals = new ConcurrentHashMap<Object, List<CreationalContextImpl<Object>>>();
    private final ConcurrentMap<Object, CreationalContextImpl<Object>> injectedContextuals = new ConcurrentHashMap<Object, CreationalContextImpl<Object>>();
    private final BeanManagerImpl beanManager;
    private final WebBeansContext webBeansContext = WebBeansContext.getInstance();

    public CdiDefaultEjbInjector() {
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
    }

    public void injectDependenciesOfEjbInstance(Object ejbInstance, Object mapKey) throws Exception {
        BaseEjbBean<Object> ejbBean = OpenWebBeansEjbInterceptor.getEjbBean();
        if (ejbBean != null) {
            CreationalContextImpl contextualCc = (CreationalContextImpl)OpenWebBeansEjbInterceptor.getThreadCreationalContext();
            this.injectDependenciesOfContextualEjb(ejbInstance, ejbBean, (CreationalContext<Object>)contextualCc);
            this.injectedContextuals.putIfAbsent(mapKey, (CreationalContextImpl<Object>)contextualCc);
        } else {
            this.injectDependenciesOfNonContextualEjb(ejbInstance, mapKey);
        }
    }

    public void injectDependenciesOfEjbInterceptor(Object ejbInstance, Object interceptorInstance, Object mapKey) throws Exception {
        OWBInjector owbInjector = new OWBInjector(this.webBeansContext);
        CreationalContextImpl cc = null;
        if (this.injectedContextuals.containsKey(mapKey)) {
            cc = (CreationalContextImpl)this.injectedContextuals.get(mapKey);
            owbInjector.inject(interceptorInstance, (CreationalContext)cc);
        } else {
            cc = (CreationalContextImpl)this.beanManager.createCreationalContext(null);
            owbInjector.inject(interceptorInstance, (CreationalContext)cc);
            ((List)this.injectedNonContextuals.get(mapKey)).add(cc);
        }
    }

    public void releaseNonContextualDependents(Object mapKey) throws Exception {
        if (this.injectedContextuals.containsKey(mapKey)) {
            this.injectedContextuals.remove(mapKey);
        } else {
            List ccList = (List)this.injectedNonContextuals.remove(mapKey);
            if (ccList != null) {
                for (CreationalContextImpl cc : ccList) {
                    cc.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void injectDependenciesOfContextualEjb(Object instance, BaseEjbBean<Object> bean, CreationalContext<Object> ctx) throws Exception {
        if (!(ctx instanceof CreationalContextImpl)) {
            ctx = this.webBeansContext.getCreationalContextFactory().wrappedCreationalContext(ctx, bean);
        }
        Object oldInstanceUnderInjection = AbstractInjectable.instanceUnderInjection.get();
        boolean isInjectionToAnotherBean = false;
        try {
            Contextual contextual = null;
            if (ctx instanceof CreationalContextImpl) {
                contextual = ((CreationalContextImpl)ctx).getBean();
                boolean bl = isInjectionToAnotherBean = contextual != bean;
            }
            if (!isInjectionToAnotherBean) {
                AbstractInjectable.instanceUnderInjection.set(instance);
            }
            bean.injectSuperFields(instance, ctx);
            bean.injectSuperMethods(instance, ctx);
            bean.injectFields(instance, ctx);
            bean.injectMethods(instance, ctx);
        }
        finally {
            if (oldInstanceUnderInjection != null) {
                AbstractInjectable.instanceUnderInjection.set(oldInstanceUnderInjection);
            } else {
                AbstractInjectable.instanceUnderInjection.set(null);
                AbstractInjectable.instanceUnderInjection.remove();
            }
        }
    }

    private void injectDependenciesOfNonContextualEjb(Object instance, Object mapKey) throws Exception {
        OWBInjector owbInjector = new OWBInjector(this.webBeansContext);
        CreationalContextImpl cc = (CreationalContextImpl)this.beanManager.createCreationalContext(null);
        owbInjector.inject(instance, (CreationalContext)cc);
        ArrayList<CreationalContextImpl> ccList = (ArrayList<CreationalContextImpl>)this.injectedNonContextuals.get(mapKey);
        if (ccList == null) {
            ccList = new ArrayList<CreationalContextImpl>();
        }
        ccList.add(cc);
        this.injectedNonContextuals.putIfAbsent(mapKey, ccList);
    }
}

