/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Provider;
import org.apache.webbeans.component.EventBean;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.InstanceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansAnnotatedTypeUtil;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OWBInjector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CreationalContextImpl<?> ownerCreationalContext = null;
    private Object javaEEInstance;
    private final WebBeansContext webBeansContext;

    public OWBInjector() {
        this(WebBeansContext.getInstance());
    }

    public OWBInjector(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public OWBInjector inject(Object javaEeComponentInstance) throws Exception {
        return this.inject(javaEeComponentInstance, null);
    }

    public OWBInjector inject(Object javaEeComponentInstance, CreationalContext<?> creationalContext) throws Exception {
        Class<?> injectableComponentClass;
        InjectionTargetWrapper<?> wrapper;
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        this.javaEEInstance = javaEeComponentInstance;
        if (creationalContext == null) {
            this.ownerCreationalContext = (CreationalContextImpl)beanManager.createCreationalContext(null);
        }
        if ((wrapper = beanManager.getInjectionTargetWrapper(injectableComponentClass = javaEeComponentInstance.getClass())) != null) {
            wrapper.inject(javaEeComponentInstance, this.ownerCreationalContext);
            return this;
        }
        AnnotatedType<?> annotated = beanManager.createAnnotatedType(injectableComponentClass);
        Set<InjectionPoint> injectionPoints = WebBeansAnnotatedTypeUtil.getJavaEeComponentInstanceInjectionPoints(this.webBeansContext, annotated);
        if (injectionPoints != null && injectionPoints.size() > 0) {
            for (InjectionPoint injectionPoint : injectionPoints) {
                if (injectionPoint.getMember() instanceof Method) {
                    Method method = (Method)injectionPoint.getMember();
                    List<Object> parameters = this.getInjectedMethodParameterReferences(injectionPoint, beanManager, injectionPoints);
                    ClassUtil.callInstanceMethod(method, javaEeComponentInstance, parameters.toArray(new Object[parameters.size()]));
                    continue;
                }
                if (!(injectionPoint.getMember() instanceof Field)) continue;
                Object object = this.getInjectedObjectReference(injectionPoint, beanManager);
                Field field = (Field)injectionPoint.getMember();
                this.setField(javaEeComponentInstance, field, object);
            }
            return this;
        }
        return null;
    }

    public void destroy() {
        BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
        InjectionTargetWrapper<?> wrapper = beanManager.getInjectionTargetWrapper(this.javaEEInstance.getClass());
        if (wrapper != null) {
            wrapper.dispose(this.javaEEInstance);
            this.javaEEInstance = null;
            this.ownerCreationalContext = null;
        } else if (this.ownerCreationalContext != null) {
            this.ownerCreationalContext.release();
            this.ownerCreationalContext = null;
        }
    }

    private void setField(Object instance, Field field, Object value) {
        if (!field.isAccessible()) {
            this.webBeansContext.getSecurityService().doPrivilegedSetAccessible((AccessibleObject)field, true);
        }
        try {
            field.set(instance, value);
        }
        catch (IllegalArgumentException e) {
            throw new WebBeansException(e);
        }
        catch (IllegalAccessException e) {
            throw new WebBeansException(e);
        }
    }

    private Object getInjectedObjectReference(InjectionPoint injectionPoint, BeanManagerImpl beanManager) {
        Object object = null;
        InjectionResolver injectionResolver = beanManager.getInjectionResolver();
        Bean<?> injectedBean = injectionResolver.getInjectionPointBean(injectionPoint);
        if (this.isInstanceProviderInjection(injectionPoint)) {
            InstanceBean.local.set(injectionPoint);
        } else if (this.isEventProviderInjection(injectionPoint)) {
            EventBean.local.set(injectionPoint);
        } else if (WebBeansUtil.isDependent(injectedBean) && !InjectionPoint.class.isAssignableFrom(ClassUtil.getClass(injectionPoint.getType()))) {
            InjectionPointBean.local.set(injectionPoint);
        }
        object = beanManager.getInjectableReference(injectionPoint, this.ownerCreationalContext);
        return object;
    }

    private List<Object> getInjectedMethodParameterReferences(InjectionPoint injectionPoint, BeanManagerImpl beanManager, Set<InjectionPoint> injectionPoints) {
        Method method = (Method)injectionPoint.getMember();
        List<InjectionPoint> injectedPoints = this.getInjectedPoints(method, injectionPoints);
        ArrayList<Object> list = new ArrayList<Object>();
        block0: for (int i = 0; i < injectedPoints.size(); ++i) {
            for (InjectionPoint point : injectedPoints) {
                AnnotatedParameter parameter = (AnnotatedParameter)point.getAnnotated();
                if (parameter.getPosition() != i) continue;
                Object instance = this.getInjectedObjectReference(injectionPoint, beanManager);
                list.add(instance);
                continue block0;
            }
        }
        return list;
    }

    private List<InjectionPoint> getInjectedPoints(Method method, Set<InjectionPoint> injectionPoints) {
        ArrayList<InjectionPoint> points = new ArrayList<InjectionPoint>();
        for (InjectionPoint ip : injectionPoints) {
            if (!ip.getMember().equals(method)) continue;
            points.add(ip);
        }
        return points;
    }

    private boolean isInstanceProviderInjection(InjectionPoint injectionPoint) {
        ParameterizedType pt;
        Class clazz;
        Type type = injectionPoint.getType();
        return type instanceof ParameterizedType && Provider.class.isAssignableFrom(clazz = (Class)(pt = (ParameterizedType)type).getRawType());
    }

    private boolean isEventProviderInjection(InjectionPoint injectionPoint) {
        ParameterizedType pt;
        Class clazz;
        Type type = injectionPoint.getType();
        return type instanceof ParameterizedType && (clazz = (Class)(pt = (ParameterizedType)type).getRawType()).isAssignableFrom(Event.class);
    }
}

