/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.renderkit.ClientSideStateHelper;
import com.sun.faces.renderkit.ServerSideStateHelper;
import com.sun.faces.renderkit.StateHelper;
import com.sun.faces.util.RequestStateManager;
import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;

public class ResponseStateManagerImpl
extends ResponseStateManager {
    private StateHelper helper;

    public ResponseStateManagerImpl() {
        WebConfiguration webConfig = WebConfiguration.getInstance();
        String stateMode = webConfig.getOptionValue(WebConfiguration.WebContextInitParameter.StateSavingMethod);
        this.helper = "client".equals(stateMode) ? new ClientSideStateHelper() : new ServerSideStateHelper();
    }

    public boolean isPostback(FacesContext context) {
        return context.getExternalContext().getRequestParameterMap().containsKey("javax.faces.ViewState");
    }

    public Object getState(FacesContext context, String viewId) {
        Object state = RequestStateManager.get(context, "com.sun.faces.FACES_VIEW_STATE");
        if (state == null) {
            try {
                state = this.helper.getState(context, viewId);
                if (state != null) {
                    RequestStateManager.set(context, "com.sun.faces.FACES_VIEW_STATE", state);
                }
            }
            catch (IOException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return state;
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        this.helper.writeState(context, state, null);
    }

    public String getViewState(FacesContext context, Object state) {
        StringBuilder sb = new StringBuilder(32);
        try {
            this.helper.writeState(context, state, sb);
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        return sb.toString();
    }

    public Object getTreeStructureToRestore(FacesContext context, String viewId) {
        Object[] state = (Object[])this.getState(context, viewId);
        if (state != null) {
            return state[0];
        }
        return null;
    }
}

