/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.migrator.properties;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.viatra.query.tooling.ui.migrator.MigratorConstants;

public class QueryProjectVersionTester
extends PropertyTester {
    private static final String VERSION_TESTER = "outdated";

    private boolean hasIncorrectBuildCommandOrdering(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int xtextIndex = -1;
        int iqIndex = -1;
        int jdtIndex = -1;
        int i = 0;
        while (i < commands.length) {
            String id = commands[i].getBuilderName();
            if ("org.eclipse.viatra.query.tooling.ui.projectbuilder".equals(id)) {
                iqIndex = i;
            } else if ("org.eclipse.xtext.ui.shared.xtextBuilder".equals(id)) {
                xtextIndex = i;
            } else if ("org.eclipse.jdt.core.javabuilder".equals(id)) {
                jdtIndex = i;
            }
            ++i;
        }
        return jdtIndex < xtextIndex || jdtIndex < iqIndex;
    }

    private boolean hasLog4jDependency(IProject project) throws JavaModelException {
        return JavaCore.create((IProject)project).findType(Logger.class.getName()) == null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        try {
            String ID;
            if (!VERSION_TESTER.equals(property)) return false;
            if (!(receiver instanceof IProject)) return false;
            if (!((IProject)receiver).isAccessible()) return false;
            IProject project = (IProject)receiver;
            Iterator iterator = MigratorConstants.INCORRECT_NATURE_IDS.iterator();
            do {
                if (iterator.hasNext()) continue;
                if (!project.hasNature("org.eclipse.viatra.query.projectnature")) return ProjectGenerationHelper.isOpenPDEProject((IProject)project);
                if (project.findMember("queries/globalEiqModel.xmi") != null) return true;
                if (this.hasIncorrectBuildCommandOrdering(project)) return true;
                if (this.hasLog4jDependency(project)) return true;
                return false;
            } while (!project.hasNature(ID = (String)iterator.next()));
            return true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

