/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.crossovers;

import java.util.Random;
import org.eclipse.viatra.dse.base.DesignSpaceManager;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.interfaces.ICrossover;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class SwapTransitionCrossover
implements ICrossover {
    private Random random = new Random();
    private Object[] parent1t;
    private Object[] parent2t;
    private int p1Size;
    private int p2Size;
    private int index1;
    private int index2;
    private DesignSpaceManager dsm;

    @Override
    public boolean mutate(TrajectoryFitness parent1, TrajectoryFitness parent2, ThreadContext context) {
        this.dsm = context.getDesignSpaceManager();
        this.parent1t = parent1.trajectory;
        this.parent2t = parent2.trajectory;
        this.p1Size = this.parent1t.length;
        this.p2Size = this.parent2t.length;
        if (this.p1Size < 2 || this.p2Size < 2) {
            return false;
        }
        this.index1 = this.random.nextInt(this.p1Size);
        this.index2 = this.random.nextInt(this.p2Size);
        this.dsm.executeTrajectoryWithMinimalBacktrackWithoutStateCoding(this.parent1t, this.index1);
        this.dsm.tryFireActivation(this.parent2t[this.index2]);
        context.executeTrajectoryByTryingWithoutStateCoding(this.parent1t, this.index1 + 1, this.p1Size);
        return true;
    }

    @Override
    public boolean mutateAlternate(TrajectoryFitness parent1, TrajectoryFitness parent2, ThreadContext context) {
        this.dsm.executeTrajectoryWithMinimalBacktrackWithoutStateCoding(this.parent2t, this.index2);
        this.dsm.tryFireActivation(this.parent1t[this.index1]);
        context.executeTrajectoryByTryingWithoutStateCoding(this.parent2t, this.index2 + 1, this.p2Size);
        return true;
    }

    @Override
    public ICrossover createNew() {
        return new SwapTransitionCrossover();
    }
}

