/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.zest.sources;

import java.util.Collection;
import java.util.stream.Stream;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.AbstractViewerStateListener;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.IViewerLabelListener;
import org.eclipse.viatra.addon.viewers.runtime.model.listeners.IViewerStateListener;
import org.eclipse.viatra.addon.viewers.runtime.notation.Containment;
import org.eclipse.viatra.addon.viewers.runtime.notation.Edge;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.integration.zest.viewer.IGraphEdgeContentProvider;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.zest.core.viewers.GraphViewer;

public class ZestContentProvider
extends AbstractViewerStateListener
implements IGraphEdgeContentProvider,
IViewerLabelListener {
    protected GraphViewer viewer;
    protected ViewerState state;
    protected boolean displayContainment;

    public ZestContentProvider() {
        this(false);
    }

    public ZestContentProvider(boolean displayContainment) {
        this.displayContainment = displayContainment;
    }

    public Object[] getElements(Object input) {
        if (this.state != null) {
            Collection items = this.state.getItems();
            return items.toArray(new Item[items.size()]);
        }
        return new Object[0];
    }

    public Object[] getRelationships(Object input) {
        if (this.state != null) {
            Stream stream = this.displayContainment ? Stream.concat(this.state.getEdges().stream(), this.state.getContainments().stream()) : this.state.getEdges().stream();
            return stream.toArray(Edge[]::new);
        }
        return new Object[0];
    }

    public Object getSource(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getSource();
        }
        return null;
    }

    public Object getDestination(Object edge) {
        if (edge instanceof Edge) {
            return ((Edge)edge).getTarget();
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof GraphViewer));
        this.viewer = (GraphViewer)viewer;
        if (oldInput instanceof ViewerState) {
            ((ViewerState)oldInput).removeStateListener((IViewerStateListener)this);
            ((ViewerState)oldInput).removeLabelListener((IViewerLabelListener)this);
        }
        if (newInput == null) {
            this.state = null;
        } else if (newInput instanceof ViewerState) {
            this.state = (ViewerState)newInput;
            if (this.state.isDisposed()) {
                this.state = null;
            } else {
                this.state.addStateListener((IViewerStateListener)this);
                this.state.addLabelListener((IViewerLabelListener)this);
            }
        } else {
            throw new IllegalArgumentException(String.format("Invalid input type %s for Zest Viewer.", newInput.getClass().getName()));
        }
    }

    public void itemAppeared(Item item) {
        this.viewer.addNode((Object)item);
    }

    public void itemDisappeared(Item item) {
        this.viewer.removeNode((Object)item);
    }

    public void edgeAppeared(Edge edge) {
        this.viewer.addRelationship((Object)edge);
    }

    public void edgeDisappeared(Edge edge) {
        this.viewer.removeRelationship((Object)edge);
    }

    public void containmentAppeared(Containment containment) {
        if (this.displayContainment) {
            this.edgeAppeared((Edge)containment);
        }
    }

    public void containmentDisappeared(Containment containment) {
        if (this.displayContainment) {
            this.edgeDisappeared((Edge)containment);
        }
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removeStateListener((IViewerStateListener)this);
        }
    }

    public void labelUpdated(Item item, String newLabel) {
        this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.refresh((Object)item));
    }

    public void labelUpdated(Edge edge, String newLabel) {
        this.viewer.getControl().getDisplay().syncExec(() -> this.viewer.refresh((Object)edge));
    }
}

