/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.NotifyingList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.base.api.DataTypeListener;
import org.eclipse.viatra.query.runtime.base.api.EMFBaseIndexChangeListener;
import org.eclipse.viatra.query.runtime.base.api.FeatureListener;
import org.eclipse.viatra.query.runtime.base.api.IEClassifierProcessor;
import org.eclipse.viatra.query.runtime.base.api.IEMFIndexingErrorListener;
import org.eclipse.viatra.query.runtime.base.api.IStructuralFeatureInstanceProcessor;
import org.eclipse.viatra.query.runtime.base.api.IndexingLevel;
import org.eclipse.viatra.query.runtime.base.api.InstanceListener;
import org.eclipse.viatra.query.runtime.base.api.LightweightEObjectObserver;
import org.eclipse.viatra.query.runtime.base.api.NavigationHelper;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexObjectFilter;
import org.eclipse.viatra.query.runtime.base.api.filters.IBaseIndexResourceFilter;
import org.eclipse.viatra.query.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.viatra.query.runtime.base.comprehension.EMFVisitor;
import org.eclipse.viatra.query.runtime.base.core.EMFBaseIndexInstanceStore;
import org.eclipse.viatra.query.runtime.base.core.EMFBaseIndexMetaStore;
import org.eclipse.viatra.query.runtime.base.core.EMFBaseIndexStatisticsStore;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperContentAdapter;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperSetting;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperVisitor;
import org.eclipse.viatra.query.runtime.base.core.profiler.ProfilingNavigationHelperContentAdapter;
import org.eclipse.viatra.query.runtime.base.exception.ViatraBaseException;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class NavigationHelperImpl
implements NavigationHelper {
    protected IndexingLevel wildcardMode;
    protected Set<Notifier> modelRoots;
    private boolean expansionAllowed;
    private boolean traversalDescendsAlongCrossResourceContainment;
    protected NavigationHelperContentAdapter contentAdapter;
    protected final Logger logger;
    protected Map<Object, IndexingLevel> directlyObservedClasses = new HashMap<Object, IndexingLevel>();
    protected Map<Object, IndexingLevel> allObservedClasses = null;
    protected Map<Object, IndexingLevel> observedDataTypes;
    protected Map<Object, IndexingLevel> observedFeatures;
    protected Set<Object> ignoreResolveNotificationFeatures;
    protected boolean delayTraversals = false;
    protected Map<Object, IndexingLevel> delayedClasses = new HashMap<Object, IndexingLevel>();
    protected Map<Object, IndexingLevel> delayedFeatures = new HashMap<Object, IndexingLevel>();
    protected Map<Object, IndexingLevel> delayedDataTypes = new HashMap<Object, IndexingLevel>();
    protected IMultiLookup<EObject, EReference> delayedProxyResolutions = CollectionsFactory.createMultiLookup(Object.class, (CollectionsFactory.MemoryType)CollectionsFactory.MemoryType.SETS, Object.class);
    protected Set<Resource> resolutionDelayingResources = new HashSet<Resource>();
    protected Queue<Runnable> traversalCallbacks = new LinkedList<Runnable>();
    private final Set<EMFBaseIndexChangeListener> baseIndexChangeListeners;
    private final Map<EObject, Set<LightweightEObjectObserver>> lightweightObservers;
    private final Map<InstanceListener, Set<EClass>> subscribedInstanceListeners;
    private final Map<FeatureListener, Set<EStructuralFeature>> subscribedFeatureListeners;
    private final Map<DataTypeListener, Set<EDataType>> subscribedDataTypeListeners;
    private Map<Object, Map<InstanceListener, Set<EClass>>> instanceListeners;
    private Map<Object, Map<FeatureListener, Set<EStructuralFeature>>> featureListeners;
    private Map<Object, Map<DataTypeListener, Set<EDataType>>> dataTypeListeners;
    private final Set<IEMFIndexingErrorListener> errorListeners;
    private final BaseIndexOptions baseIndexOptions;
    private EMFModelComprehension comprehension;
    private boolean loggedRegistrationMessage = false;
    EMFBaseIndexMetaStore metaStore;
    EMFBaseIndexInstanceStore instanceStore;
    EMFBaseIndexStatisticsStore statsStore;
    boolean notificationErrorReported = false;

    <T> Set<T> setMinus(Collection<? extends T> a, Collection<T> b) {
        HashSet<T> result = new HashSet<T>(a);
        result.removeAll(b);
        return result;
    }

    <T extends EObject> Set<T> resolveAllInternal(Set<? extends T> a) {
        if (a == null) {
            a = Collections.emptySet();
        }
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject eObject : a) {
            if (eObject.eIsProxy()) {
                result.add(EcoreUtil.resolve((EObject)eObject, null));
                continue;
            }
            result.add(eObject);
        }
        return result;
    }

    Set<Object> resolveClassifiersToKey(Set<? extends EClassifier> classes) {
        Set<? extends EClassifier> resolveds = this.resolveAllInternal(classes);
        HashSet<Object> result = new HashSet<Object>();
        for (EClassifier eClassifier : resolveds) {
            result.add(this.toKey(eClassifier));
        }
        return result;
    }

    Set<Object> resolveFeaturesToKey(Set<? extends EStructuralFeature> features) {
        Set<? extends EStructuralFeature> resolveds = this.resolveAllInternal(features);
        HashSet<Object> result = new HashSet<Object>();
        for (EStructuralFeature eStructuralFeature : resolveds) {
            result.add(this.toKey(eStructuralFeature));
        }
        return result;
    }

    @Override
    public boolean isInWildcardMode() {
        return this.isInWildcardMode(IndexingLevel.FULL);
    }

    @Override
    public boolean isInWildcardMode(IndexingLevel level) {
        return this.wildcardMode.providesLevel(level);
    }

    @Override
    public boolean isInDynamicEMFMode() {
        return this.baseIndexOptions.isDynamicEMFMode();
    }

    public BaseIndexOptions getBaseIndexOptions() {
        return this.baseIndexOptions.copy();
    }

    public EMFModelComprehension getComprehension() {
        return this.comprehension;
    }

    public NavigationHelperImpl(Notifier emfRoot, BaseIndexOptions options, Logger logger) {
        this.baseIndexOptions = options.copy();
        this.logger = logger;
        assert (logger != null);
        this.comprehension = this.initModelComprehension();
        this.wildcardMode = this.baseIndexOptions.getWildcardLevel();
        this.subscribedInstanceListeners = new HashMap<InstanceListener, Set<EClass>>();
        this.subscribedFeatureListeners = new HashMap<FeatureListener, Set<EStructuralFeature>>();
        this.subscribedDataTypeListeners = new HashMap<DataTypeListener, Set<EDataType>>();
        this.lightweightObservers = CollectionsFactory.createMap();
        this.observedFeatures = new HashMap<Object, IndexingLevel>();
        this.ignoreResolveNotificationFeatures = new HashSet<Object>();
        this.observedDataTypes = new HashMap<Object, IndexingLevel>();
        this.metaStore = this.initMetaStore();
        this.instanceStore = this.initInstanceStore();
        this.statsStore = this.initStatStore();
        this.contentAdapter = this.initContentAdapter();
        this.baseIndexChangeListeners = new HashSet<EMFBaseIndexChangeListener>();
        this.errorListeners = new LinkedHashSet<IEMFIndexingErrorListener>();
        this.modelRoots = new HashSet<Notifier>();
        this.expansionAllowed = false;
        this.traversalDescendsAlongCrossResourceContainment = false;
        if (emfRoot != null) {
            this.addRootInternal(emfRoot);
        }
    }

    @Override
    public IndexingLevel getWildcardLevel() {
        return this.wildcardMode;
    }

    @Override
    public void setWildcardLevel(IndexingLevel level) {
        try {
            IndexingLevel mergedLevel = this.wildcardMode.merge(level);
            if (mergedLevel != this.wildcardMode) {
                this.wildcardMode = mergedLevel;
                NavigationHelperVisitor.TraversingVisitor visitor = this.initTraversingVisitor(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
                this.coalesceTraversals(() -> this.traverse(visitor));
            }
        }
        catch (InvocationTargetException ex) {
            this.processingFatal(ex.getCause(), "Setting wildcard level: " + (Object)((Object)level));
        }
        catch (Exception ex) {
            this.processingFatal(ex, "Setting wildcard level: " + (Object)((Object)level));
        }
    }

    public NavigationHelperContentAdapter getContentAdapter() {
        return this.contentAdapter;
    }

    public Map<Object, IndexingLevel> getObservedFeaturesInternal() {
        return this.observedFeatures;
    }

    public boolean isFeatureResolveIgnored(EStructuralFeature feature) {
        return this.ignoreResolveNotificationFeatures.contains(this.toKey(feature));
    }

    @Override
    public void dispose() {
        this.ensureNoListenersForDispose();
        for (Notifier root : this.modelRoots) {
            this.contentAdapter.removeAdapter(root);
        }
    }

    @Override
    public Set<Object> getDataTypeInstances(EDataType type) {
        Object typeKey = this.toKey((EClassifier)type);
        return Collections.unmodifiableSet(this.instanceStore.getDistinctDataTypeInstances(typeKey));
    }

    @Override
    public boolean isInstanceOfDatatype(Object value, EDataType type) {
        Object typeKey = this.toKey((EClassifier)type);
        Set<Object> valMap = this.instanceStore.getDistinctDataTypeInstances(typeKey);
        return valMap.contains(value);
    }

    protected EMFBaseIndexInstanceStore.FeatureData featureData(EStructuralFeature feature) {
        return this.instanceStore.getFeatureData(this.toKey(feature));
    }

    @Override
    public Set<EStructuralFeature.Setting> findByAttributeValue(Object value_) {
        Object value = this.toCanonicalValueRepresentation(value_);
        return this.getSettingsForTarget(value);
    }

    @Override
    public Set<EStructuralFeature.Setting> findByAttributeValue(Object value_, Collection<EAttribute> attributes) {
        Object value = this.toCanonicalValueRepresentation(value_);
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        for (EAttribute attr : attributes) {
            for (EObject holder : this.featureData((EStructuralFeature)attr).getDistinctHoldersOfValue(value)) {
                retSet.add(new NavigationHelperSetting((EStructuralFeature)attr, holder, value));
            }
        }
        return retSet;
    }

    @Override
    public Set<EObject> findByAttributeValue(Object value_, EAttribute attribute) {
        Object value = this.toCanonicalValueRepresentation(value_);
        Set<EObject> holders = this.featureData((EStructuralFeature)attribute).getDistinctHoldersOfValue(value);
        return Collections.unmodifiableSet(holders);
    }

    @Override
    public void processAllFeatureInstances(EStructuralFeature feature, IStructuralFeatureInstanceProcessor processor) {
        this.featureData(feature).forEach(processor);
    }

    @Override
    public void processDirectInstances(EClass type, IEClassifierProcessor.IEClassProcessor processor) {
        Object typeKey = this.toKey((EClassifier)type);
        this.processDirectInstancesInternal(type, processor, typeKey);
    }

    @Override
    public void processAllInstances(EClass type, IEClassifierProcessor.IEClassProcessor processor) {
        Object typeKey = this.toKey((EClassifier)type);
        Set<Object> subTypes = this.metaStore.getSubTypeMap().get(typeKey);
        if (subTypes != null) {
            for (Object subTypeKey : subTypes) {
                this.processDirectInstancesInternal(type, processor, subTypeKey);
            }
        }
        this.processDirectInstancesInternal(type, processor, typeKey);
    }

    @Override
    public void processDataTypeInstances(EDataType type, IEClassifierProcessor.IEDataTypeProcessor processor) {
        Object typeKey = this.toKey((EClassifier)type);
        for (Object value : this.instanceStore.getDistinctDataTypeInstances(typeKey)) {
            processor.process(type, value);
        }
    }

    protected void processDirectInstancesInternal(EClass type, IEClassifierProcessor.IEClassProcessor processor, Object typeKey) {
        Set<EObject> instances = this.instanceStore.getInstanceSet(typeKey);
        if (instances != null) {
            for (EObject eObject : instances) {
                processor.process(type, eObject);
            }
        }
    }

    @Override
    public Set<EStructuralFeature.Setting> getInverseReferences(EObject target) {
        return this.getSettingsForTarget(target);
    }

    protected Set<EStructuralFeature.Setting> getSettingsForTarget(Object target) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        for (Object featureKey : this.instanceStore.getFeatureKeysPointingTo(target)) {
            Set<EObject> holders = this.instanceStore.getFeatureData(featureKey).getDistinctHoldersOfValue(target);
            for (EObject holder : holders) {
                EStructuralFeature feature = this.metaStore.getKnownFeatureForKey(featureKey);
                retSet.add(new NavigationHelperSetting(feature, holder, target));
            }
        }
        return retSet;
    }

    @Override
    public Set<EStructuralFeature.Setting> getInverseReferences(EObject target, Collection<EReference> references) {
        HashSet<EStructuralFeature.Setting> retSet = new HashSet<EStructuralFeature.Setting>();
        for (EReference ref : references) {
            Set<EObject> holders = this.featureData((EStructuralFeature)ref).getDistinctHoldersOfValue(target);
            for (EObject source : holders) {
                retSet.add(new NavigationHelperSetting((EStructuralFeature)ref, source, target));
            }
        }
        return retSet;
    }

    @Override
    public Set<EObject> getInverseReferences(EObject target, EReference reference) {
        Set<EObject> holders = this.featureData((EStructuralFeature)reference).getDistinctHoldersOfValue(target);
        return Collections.unmodifiableSet(holders);
    }

    @Override
    public Set<EObject> getReferenceValues(EObject source, EReference reference) {
        Set<Object> targets = this.getFeatureTargets(source, (EStructuralFeature)reference);
        return targets;
    }

    @Override
    public Set<Object> getFeatureTargets(EObject source, EStructuralFeature _feature) {
        return Collections.unmodifiableSet(this.featureData(_feature).getDistinctValuesOfHolder(source));
    }

    @Override
    public boolean isFeatureInstance(EObject source, Object target, EStructuralFeature _feature) {
        return this.featureData(_feature).isInstance(source, target);
    }

    @Override
    public Set<EObject> getDirectInstances(EClass type) {
        Object typeKey = this.toKey((EClassifier)type);
        Set<EObject> valSet = this.instanceStore.getInstanceSet(typeKey);
        if (valSet == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(valSet);
    }

    protected Object toKey(EClassifier eClassifier) {
        return this.metaStore.toKey(eClassifier);
    }

    protected Object toKey(EStructuralFeature feature) {
        return this.metaStore.toKey(feature);
    }

    @Override
    public Object toCanonicalValueRepresentation(Object value) {
        return this.metaStore.toInternalValueRepresentation(value);
    }

    @Override
    public Set<EObject> getAllInstances(EClass type) {
        Set<EObject> instances;
        HashSet<EObject> retSet = new HashSet<EObject>();
        Object typeKey = this.toKey((EClassifier)type);
        Set<Object> subTypes = this.metaStore.getSubTypeMap().get(typeKey);
        if (subTypes != null) {
            for (Object subTypeKey : subTypes) {
                Set<EObject> instances2 = this.instanceStore.getInstanceSet(subTypeKey);
                if (instances2 == null) continue;
                retSet.addAll(instances2);
            }
        }
        if ((instances = this.instanceStore.getInstanceSet(typeKey)) != null) {
            retSet.addAll(instances);
        }
        return retSet;
    }

    @Override
    public boolean isInstanceOfUnscoped(EObject object, EClass clazz) {
        Object candidateTypeKey = this.toKey((EClassifier)clazz);
        Object typeKey = this.toKey((EClassifier)object.eClass());
        return this.doCalculateInstanceOf(candidateTypeKey, typeKey);
    }

    @Override
    public boolean isInstanceOfScoped(EObject object, EClass clazz) {
        Object typeKey = this.toKey((EClassifier)object.eClass());
        if (!this.doCalculateInstanceOf(this.toKey((EClassifier)clazz), typeKey)) {
            return false;
        }
        Set<EObject> instances = this.instanceStore.getInstanceSet(typeKey);
        return instances != null && instances.contains(object);
    }

    protected boolean doCalculateInstanceOf(Object candidateTypeKey, Object typeKey) {
        if (candidateTypeKey.equals(typeKey)) {
            return true;
        }
        if (this.metaStore.getEObjectClassKey().equals(candidateTypeKey)) {
            return true;
        }
        Set<Object> superTypes = this.metaStore.getSuperTypeMap().get(typeKey);
        return superTypes.contains(candidateTypeKey);
    }

    @Override
    public Set<EObject> findByFeatureValue(Object value_, EStructuralFeature _feature) {
        Object value = this.toCanonicalValueRepresentation(value_);
        return Collections.unmodifiableSet(this.featureData(_feature).getDistinctHoldersOfValue(value));
    }

    @Override
    public Set<EObject> getHoldersOfFeature(EStructuralFeature _feature) {
        Object feature = this.toKey(_feature);
        return Collections.unmodifiableSet(this.instanceStore.getHoldersOfFeature(feature));
    }

    @Override
    public Set<Object> getValuesOfFeature(EStructuralFeature _feature) {
        Object feature = this.toKey(_feature);
        return Collections.unmodifiableSet(this.instanceStore.getValuesOfFeature(feature));
    }

    @Override
    public void addInstanceListener(Collection<EClass> classes, InstanceListener listener) {
        Set registered = this.subscribedInstanceListeners.computeIfAbsent(listener, l -> new HashSet());
        Set<EClass> delta = this.setMinus(classes, registered);
        if (!delta.isEmpty()) {
            registered.addAll(delta);
            if (this.instanceListeners != null) {
                for (EClass subscriptionType : delta) {
                    Object superElementTypeKey = this.toKey((EClassifier)subscriptionType);
                    this.addInstanceListenerInternal(listener, subscriptionType, superElementTypeKey);
                    Set<Object> subTypeKeys = this.metaStore.getSubTypeMap().get(superElementTypeKey);
                    if (subTypeKeys == null) continue;
                    for (Object subTypeKey : subTypeKeys) {
                        this.addInstanceListenerInternal(listener, subscriptionType, subTypeKey);
                    }
                }
            }
        }
    }

    @Override
    public void removeInstanceListener(Collection<EClass> classes, InstanceListener listener) {
        Set<EClass> restriction = this.subscribedInstanceListeners.get(listener);
        if (restriction != null) {
            boolean changed = restriction.removeAll(classes);
            if (restriction.size() == 0) {
                this.subscribedInstanceListeners.remove(listener);
            }
            if (changed) {
                this.instanceListeners = null;
            }
        }
    }

    @Override
    public void addFeatureListener(Collection<? extends EStructuralFeature> features, FeatureListener listener) {
        Set registered = this.subscribedFeatureListeners.computeIfAbsent(listener, l -> new HashSet());
        Set<? extends EStructuralFeature> delta = this.setMinus(features, registered);
        if (!delta.isEmpty()) {
            registered.addAll(delta);
            if (this.featureListeners != null) {
                for (EStructuralFeature eStructuralFeature : delta) {
                    this.addFeatureListenerInternal(listener, eStructuralFeature, this.toKey(eStructuralFeature));
                }
            }
        }
    }

    @Override
    public void removeFeatureListener(Collection<? extends EStructuralFeature> features, FeatureListener listener) {
        Collection restriction = this.subscribedFeatureListeners.get(listener);
        if (restriction != null) {
            boolean changed = restriction.removeAll(features);
            if (restriction.size() == 0) {
                this.subscribedFeatureListeners.remove(listener);
            }
            if (changed) {
                this.featureListeners = null;
            }
        }
    }

    @Override
    public void addDataTypeListener(Collection<EDataType> types, DataTypeListener listener) {
        Set registered = this.subscribedDataTypeListeners.computeIfAbsent(listener, l -> new HashSet());
        Set<EDataType> delta = this.setMinus(types, registered);
        if (!delta.isEmpty()) {
            registered.addAll(delta);
            if (this.dataTypeListeners != null) {
                for (EDataType subscriptionType : delta) {
                    this.addDatatypeListenerInternal(listener, subscriptionType, this.toKey((EClassifier)subscriptionType));
                }
            }
        }
    }

    @Override
    public void removeDataTypeListener(Collection<EDataType> types, DataTypeListener listener) {
        Collection restriction = this.subscribedDataTypeListeners.get(listener);
        if (restriction != null) {
            boolean changed = restriction.removeAll(types);
            if (restriction.size() == 0) {
                this.subscribedDataTypeListeners.remove(listener);
            }
            if (changed) {
                this.dataTypeListeners = null;
            }
        }
    }

    public Map<Object, IndexingLevel> getObservedDataTypesInternal() {
        return this.observedDataTypes;
    }

    @Override
    public boolean addLightweightEObjectObserver(LightweightEObjectObserver observer, EObject observedObject) {
        Set observers = this.lightweightObservers.computeIfAbsent(observedObject, CollectionsFactory::emptySet);
        return observers.add(observer);
    }

    @Override
    public boolean removeLightweightEObjectObserver(LightweightEObjectObserver observer, EObject observedObject) {
        boolean result = false;
        Set<LightweightEObjectObserver> observers = this.lightweightObservers.get(observedObject);
        if (observers != null) {
            result = observers.remove(observer);
            if (observers.isEmpty()) {
                this.lightweightObservers.remove(observedObject);
            }
        }
        return result;
    }

    public void notifyBaseIndexChangeListeners() {
        this.notifyBaseIndexChangeListeners(this.instanceStore.isDirty);
        if (this.instanceStore.isDirty) {
            this.instanceStore.isDirty = false;
        }
    }

    protected void notifyBaseIndexChangeListeners(boolean baseIndexChanged) {
        if (!this.baseIndexChangeListeners.isEmpty()) {
            for (EMFBaseIndexChangeListener listener : new ArrayList<EMFBaseIndexChangeListener>(this.baseIndexChangeListeners)) {
                try {
                    if (listener.onlyOnIndexChange() && !baseIndexChanged) continue;
                    listener.notifyChanged(baseIndexChanged);
                }
                catch (Exception ex) {
                    this.notifyFatalListener("VIATRA Base encountered an error in delivering notifications about changes. ", ex);
                }
            }
        }
    }

    void notifyDataTypeListeners(Object typeKey, Object value, boolean isInsertion, boolean firstOrLastOccurrence) {
        for (Map.Entry entry : this.getDataTypeListeners().getOrDefault(typeKey, Collections.emptyMap()).entrySet()) {
            DataTypeListener listener = (DataTypeListener)entry.getKey();
            for (EDataType subscriptionType : (Set)entry.getValue()) {
                if (isInsertion) {
                    listener.dataTypeInstanceInserted(subscriptionType, value, firstOrLastOccurrence);
                    continue;
                }
                listener.dataTypeInstanceDeleted(subscriptionType, value, firstOrLastOccurrence);
            }
        }
    }

    void notifyFeatureListeners(EObject host, Object featureKey, Object value, boolean isInsertion) {
        for (Map.Entry entry : this.getFeatureListeners().getOrDefault(featureKey, Collections.emptyMap()).entrySet()) {
            FeatureListener listener = (FeatureListener)entry.getKey();
            for (EStructuralFeature subscriptionType : (Set)entry.getValue()) {
                if (isInsertion) {
                    listener.featureInserted(host, subscriptionType, value);
                    continue;
                }
                listener.featureDeleted(host, subscriptionType, value);
            }
        }
    }

    void notifyInstanceListeners(Object clazzKey, EObject instance, boolean isInsertion) {
        for (Map.Entry entry : this.getInstanceListeners().getOrDefault(clazzKey, Collections.emptyMap()).entrySet()) {
            InstanceListener listener = (InstanceListener)entry.getKey();
            for (EClass subscriptionType : (Set)entry.getValue()) {
                if (isInsertion) {
                    listener.instanceInserted(subscriptionType, instance);
                    continue;
                }
                listener.instanceDeleted(subscriptionType, instance);
            }
        }
    }

    void notifyLightweightObservers(EObject host, EStructuralFeature feature, Notification notification) {
        if (this.lightweightObservers.containsKey(host)) {
            Set<LightweightEObjectObserver> observers = this.lightweightObservers.get(host);
            for (LightweightEObjectObserver observer : observers) {
                observer.notifyFeatureChanged(host, feature, notification);
            }
        }
    }

    @Override
    public void addBaseIndexChangeListener(EMFBaseIndexChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Cannot add null listener!");
        this.baseIndexChangeListeners.add(listener);
    }

    @Override
    public void removeBaseIndexChangeListener(EMFBaseIndexChangeListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (String)"Cannot remove null listener!");
        this.baseIndexChangeListeners.remove(listener);
    }

    @Override
    public boolean addIndexingErrorListener(IEMFIndexingErrorListener listener) {
        return this.errorListeners.add(listener);
    }

    @Override
    public boolean removeIndexingErrorListener(IEMFIndexingErrorListener listener) {
        return this.errorListeners.remove(listener);
    }

    protected void processingFatal(Throwable ex, String task) {
        this.notifyFatalListener(this.logTaskFormat(task), ex);
    }

    protected void processingError(Throwable ex, String task) {
        this.notifyErrorListener(this.logTaskFormat(task), ex);
    }

    public void notifyErrorListener(String message, Throwable t) {
        this.logger.error((Object)message, t);
        for (IEMFIndexingErrorListener listener : new ArrayList<IEMFIndexingErrorListener>(this.errorListeners)) {
            listener.error(message, t);
        }
    }

    public void notifyFatalListener(String message, Throwable t) {
        this.logger.fatal((Object)message, t);
        for (IEMFIndexingErrorListener listener : new ArrayList<IEMFIndexingErrorListener>(this.errorListeners)) {
            listener.fatal(message, t);
        }
    }

    protected String logTaskFormat(String task) {
        return "VIATRA Query encountered an error in processing the EMF model. This happened while trying to " + task;
    }

    protected void considerForExpansion(EObject obj) {
        Resource eResource;
        if (this.expansionAllowed && (eResource = obj.eResource()) != null && eResource.getResourceSet() == null) {
            this.expandToAdditionalRoot((Notifier)eResource);
        }
    }

    protected void expandToAdditionalRoot(Notifier root) {
        if (this.modelRoots.contains(root)) {
            return;
        }
        if (root instanceof ResourceSet) {
            this.expansionAllowed = true;
        } else if (root instanceof Resource) {
            IBaseIndexResourceFilter resourceFilter = this.baseIndexOptions.getResourceFilterConfiguration();
            if (resourceFilter != null && resourceFilter.isResourceFiltered((Resource)root)) {
                return;
            }
        } else {
            this.traversalDescendsAlongCrossResourceContainment = true;
        }
        IBaseIndexObjectFilter objectFilter = this.baseIndexOptions.getObjectFilterConfiguration();
        if (objectFilter != null && objectFilter.isFiltered(root)) {
            return;
        }
        this.modelRoots.add(root);
        this.contentAdapter.addAdapter(root);
        this.notifyBaseIndexChangeListeners();
    }

    public boolean isExpansionAllowed() {
        return this.expansionAllowed;
    }

    public boolean traversalDescendsAlongCrossResourceContainment() {
        return this.traversalDescendsAlongCrossResourceContainment;
    }

    public Set<Object> getDirectlyObservedClassesInternal() {
        return this.directlyObservedClasses.keySet();
    }

    boolean isObservedInternal(Object clazzKey) {
        return this.isInWildcardMode() || this.getAllObservedClassesInternal().containsKey(clazzKey);
    }

    protected static <V> boolean putIntoMapMerged(Map<V, IndexingLevel> map, V key, IndexingLevel level) {
        IndexingLevel l = map.get(key);
        IndexingLevel merged = level.merge(l);
        if (merged != l) {
            map.put((IndexingLevel)((Object)key), merged);
            return true;
        }
        return false;
    }

    protected boolean addObservedClassesInternal(Object eClassKey, IndexingLevel level) {
        boolean changed = NavigationHelperImpl.putIntoMapMerged(this.allObservedClasses, eClassKey, level);
        if (!changed) {
            return false;
        }
        Set<Object> subTypes = this.metaStore.getSubTypeMap().get(eClassKey);
        if (subTypes != null) {
            for (Object subType : subTypes) {
                NavigationHelperImpl.putIntoMapMerged(this.allObservedClasses, subType, level);
            }
        }
        return true;
    }

    public Map<Object, IndexingLevel> getAllObservedClassesInternal() {
        if (this.allObservedClasses == null) {
            this.allObservedClasses = new HashMap<Object, IndexingLevel>();
            for (Map.Entry<Object, IndexingLevel> entry : this.directlyObservedClasses.entrySet()) {
                Object eClassKey = entry.getKey();
                IndexingLevel level = entry.getValue();
                this.addObservedClassesInternal(eClassKey, level);
            }
        }
        return this.allObservedClasses;
    }

    Map<Object, Map<InstanceListener, Set<EClass>>> getInstanceListeners() {
        if (this.instanceListeners == null) {
            this.instanceListeners = CollectionsFactory.createMap();
            for (Map.Entry<InstanceListener, Set<EClass>> subscription : this.subscribedInstanceListeners.entrySet()) {
                InstanceListener listener = subscription.getKey();
                for (EClass subscriptionType : subscription.getValue()) {
                    Object superElementTypeKey = this.toKey((EClassifier)subscriptionType);
                    this.addInstanceListenerInternal(listener, subscriptionType, superElementTypeKey);
                    Set<Object> subTypeKeys = this.metaStore.getSubTypeMap().get(superElementTypeKey);
                    if (subTypeKeys == null) continue;
                    for (Object subTypeKey : subTypeKeys) {
                        this.addInstanceListenerInternal(listener, subscriptionType, subTypeKey);
                    }
                }
            }
        }
        return this.instanceListeners;
    }

    Map<Object, Map<InstanceListener, Set<EClass>>> peekInstanceListeners() {
        return this.instanceListeners;
    }

    void addInstanceListenerInternal(InstanceListener listener, EClass subscriptionType, Object elementTypeKey) {
        Set subscriptionTypes = this.instanceListeners.computeIfAbsent(elementTypeKey, k -> CollectionsFactory.createMap()).computeIfAbsent(listener, k -> CollectionsFactory.createSet());
        subscriptionTypes.add(subscriptionType);
    }

    Map<Object, Map<FeatureListener, Set<EStructuralFeature>>> getFeatureListeners() {
        if (this.featureListeners == null) {
            this.featureListeners = CollectionsFactory.createMap();
            for (Map.Entry<FeatureListener, Set<EStructuralFeature>> subscription : this.subscribedFeatureListeners.entrySet()) {
                FeatureListener listener = subscription.getKey();
                for (EStructuralFeature subscriptionType : subscription.getValue()) {
                    Object elementTypeKey = this.toKey(subscriptionType);
                    this.addFeatureListenerInternal(listener, subscriptionType, elementTypeKey);
                }
            }
        }
        return this.featureListeners;
    }

    void addFeatureListenerInternal(FeatureListener listener, EStructuralFeature subscriptionType, Object elementTypeKey) {
        Set subscriptionTypes = this.featureListeners.computeIfAbsent(elementTypeKey, k -> CollectionsFactory.createMap()).computeIfAbsent(listener, k -> CollectionsFactory.createSet());
        subscriptionTypes.add(subscriptionType);
    }

    Map<Object, Map<DataTypeListener, Set<EDataType>>> getDataTypeListeners() {
        if (this.dataTypeListeners == null) {
            this.dataTypeListeners = CollectionsFactory.createMap();
            for (Map.Entry<DataTypeListener, Set<EDataType>> subscription : this.subscribedDataTypeListeners.entrySet()) {
                DataTypeListener listener = subscription.getKey();
                for (EDataType subscriptionType : subscription.getValue()) {
                    Object elementTypeKey = this.toKey((EClassifier)subscriptionType);
                    this.addDatatypeListenerInternal(listener, subscriptionType, elementTypeKey);
                }
            }
        }
        return this.dataTypeListeners;
    }

    void addDatatypeListenerInternal(DataTypeListener listener, EDataType subscriptionType, Object elementTypeKey) {
        Set subscriptionTypes = this.dataTypeListeners.computeIfAbsent(elementTypeKey, k -> CollectionsFactory.createMap()).computeIfAbsent(listener, k -> CollectionsFactory.createSet());
        subscriptionTypes.add(subscriptionType);
    }

    public void registerObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<? extends EStructuralFeature> features) {
        this.registerObservedTypes(classes, dataTypes, features, IndexingLevel.FULL);
    }

    @Override
    public void registerObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<? extends EStructuralFeature> features, IndexingLevel level) {
        if (this.isRegistrationNecessary(level) && (classes != null || features != null || dataTypes != null)) {
            Set<Object> resolvedFeatures = this.resolveFeaturesToKey(features);
            Set<Object> resolvedClasses = this.resolveClassifiersToKey(classes);
            Set<Object> resolvedDatatypes = this.resolveClassifiersToKey(dataTypes);
            try {
                this.coalesceTraversals(() -> {
                    Function<Object, IndexingLevel> f = input -> level;
                    this.delayedFeatures.putAll(resolvedFeatures.stream().collect(Collectors.toMap(Function.identity(), f)));
                    this.delayedDataTypes.putAll(resolvedDatatypes.stream().collect(Collectors.toMap(Function.identity(), f)));
                    this.delayedClasses.putAll(resolvedClasses.stream().collect(Collectors.toMap(Function.identity(), f)));
                });
            }
            catch (InvocationTargetException ex) {
                this.processingFatal(ex.getCause(), "register en masse the observed EClasses " + resolvedClasses + " and EDatatypes " + resolvedDatatypes + " and EStructuralFeatures " + resolvedFeatures);
            }
            catch (Exception ex) {
                this.processingFatal(ex, "register en masse the observed EClasses " + resolvedClasses + " and EDatatypes " + resolvedDatatypes + " and EStructuralFeatures " + resolvedFeatures);
            }
        }
    }

    @Override
    public void unregisterObservedTypes(Set<EClass> classes, Set<EDataType> dataTypes, Set<? extends EStructuralFeature> features) {
        this.unregisterEClasses(classes);
        this.unregisterEDataTypes(dataTypes);
        this.unregisterEStructuralFeatures(features);
    }

    @Override
    public void registerEStructuralFeatures(Set<? extends EStructuralFeature> features, IndexingLevel level) {
        if (this.isRegistrationNecessary(level) && features != null) {
            Set<Object> resolved = this.resolveFeaturesToKey(features);
            try {
                this.coalesceTraversals(() -> resolved.forEach(o -> {
                    IndexingLevel indexingLevel2 = this.delayedFeatures.put(o, level);
                }));
            }
            catch (InvocationTargetException ex) {
                this.processingFatal(ex.getCause(), "register the observed EStructuralFeatures: " + resolved);
            }
            catch (Exception ex) {
                this.processingFatal(ex, "register the observed EStructuralFeatures: " + resolved);
            }
        }
    }

    @Override
    public void unregisterEStructuralFeatures(Set<? extends EStructuralFeature> features) {
        if (this.isRegistrationNecessary(IndexingLevel.FULL) && features != null) {
            Set<Object> resolved = this.resolveFeaturesToKey(features);
            this.ensureNoListeners(resolved, this.getFeatureListeners());
            this.observedFeatures.keySet().removeAll(resolved);
            this.delayedFeatures.keySet().removeAll(resolved);
            for (Object f : resolved) {
                this.instanceStore.forgetFeature(f);
                this.statsStore.removeType(f);
            }
        }
    }

    @Override
    public void registerEClasses(Set<EClass> classes, IndexingLevel level) {
        if (this.isRegistrationNecessary(level) && classes != null) {
            Set<Object> resolvedClasses = this.resolveClassifiersToKey(classes);
            try {
                this.coalesceTraversals(() -> resolvedClasses.forEach(o -> {
                    IndexingLevel indexingLevel2 = this.delayedClasses.put(o, level);
                }));
            }
            catch (InvocationTargetException ex) {
                this.processingFatal(ex.getCause(), "register the observed EClasses: " + resolvedClasses);
            }
            catch (Exception ex) {
                this.processingFatal(ex, "register the observed EClasses: " + resolvedClasses);
            }
        }
    }

    protected boolean startObservingClasses(Map<Object, IndexingLevel> requestedClassObservations) {
        boolean warrantsTraversal = false;
        this.getAllObservedClassesInternal();
        for (Map.Entry<Object, IndexingLevel> request : requestedClassObservations.entrySet()) {
            if (!NavigationHelperImpl.putIntoMapMerged(this.directlyObservedClasses, request.getKey(), request.getValue()) || !this.addObservedClassesInternal(request.getKey(), request.getValue())) continue;
            warrantsTraversal = true;
        }
        return warrantsTraversal;
    }

    @Override
    public void unregisterEClasses(Set<EClass> classes) {
        if (this.isRegistrationNecessary(IndexingLevel.FULL) && classes != null) {
            Set<Object> resolved = this.resolveClassifiersToKey(classes);
            this.ensureNoListeners(resolved, this.getInstanceListeners());
            this.directlyObservedClasses.keySet().removeAll(resolved);
            this.allObservedClasses = null;
            this.delayedClasses.keySet().removeAll(resolved);
            for (Object c : resolved) {
                this.instanceStore.removeInstanceSet(c);
                this.statsStore.removeType(c);
            }
        }
    }

    @Override
    public void registerEDataTypes(Set<EDataType> dataTypes, IndexingLevel level) {
        if (this.isRegistrationNecessary(level) && dataTypes != null) {
            Set<Object> resolved = this.resolveClassifiersToKey(dataTypes);
            try {
                this.coalesceTraversals(() -> resolved.forEach(o -> {
                    IndexingLevel indexingLevel2 = this.delayedDataTypes.put(o, level);
                }));
            }
            catch (InvocationTargetException ex) {
                this.processingFatal(ex.getCause(), "register the observed EDataTypes: " + resolved);
            }
            catch (Exception ex) {
                this.processingFatal(ex, "register the observed EDataTypes: " + resolved);
            }
        }
    }

    @Override
    public void unregisterEDataTypes(Set<EDataType> dataTypes) {
        if (this.isRegistrationNecessary(IndexingLevel.FULL) && dataTypes != null) {
            Set<Object> resolved = this.resolveClassifiersToKey(dataTypes);
            this.ensureNoListeners(resolved, this.getDataTypeListeners());
            this.observedDataTypes.keySet().removeAll(resolved);
            this.delayedDataTypes.keySet().removeAll(resolved);
            for (Object dataType : resolved) {
                this.instanceStore.removeDataTypeMap(dataType);
                this.statsStore.removeType(dataType);
            }
        }
    }

    @Override
    public boolean isCoalescing() {
        return this.delayTraversals;
    }

    public void coalesceTraversals(Runnable runnable) throws InvocationTargetException {
        this.coalesceTraversals(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        V finalResult = null;
        if (this.delayTraversals) {
            try {
                finalResult = callable.call();
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
            return finalResult;
        }
        boolean firstRun = true;
        while (callable != null) {
            try {
                this.delayTraversals = true;
                V result = callable.call();
                if (firstRun) {
                    firstRun = false;
                    finalResult = result;
                }
                while (!this.delayedProxyResolutions.isEmpty() && this.resolutionDelayingResources.isEmpty()) {
                    EObject toResolveObject = (EObject)this.delayedProxyResolutions.distinctKeys().iterator().next();
                    EReference toResolveReference = (EReference)this.delayedProxyResolutions.lookup((Object)toResolveObject).iterator().next();
                    this.delayedProxyResolutions.removePair((Object)toResolveObject, (Object)toResolveReference);
                    this.comprehension.tryResolveReference(toResolveObject, toResolveReference);
                }
                this.delayTraversals = false;
                callable = this.considerRevisit();
            }
            catch (Exception e) {
                this.notifyFatalListener("VIATRA Base encountered an error while traversing the EMF model to gather new information. ", e);
                throw new InvocationTargetException(e);
            }
        }
        this.executeTraversalCallbacks();
        return finalResult;
    }

    protected <V> Callable<V> considerRevisit() {
        if (!(this.delayedClasses.isEmpty() && this.delayedFeatures.isEmpty() && this.delayedDataTypes.isEmpty())) {
            IndexingLevel merged;
            IndexingLevel old;
            Object typekey;
            HashMap<Object, IndexingLevel> toGatherClasses = new HashMap<Object, IndexingLevel>(this.delayedClasses.size());
            final HashMap<Object, IndexingLevel> toGatherFeatures = new HashMap<Object, IndexingLevel>(this.delayedFeatures.size());
            HashMap<Object, IndexingLevel> toGatherDataTypes = new HashMap<Object, IndexingLevel>(this.delayedDataTypes.size());
            for (Map.Entry<Object, IndexingLevel> requested : this.delayedFeatures.entrySet()) {
                typekey = requested.getKey();
                old = this.observedFeatures.get(typekey);
                merged = requested.getValue().merge(old);
                if (merged == old) continue;
                toGatherFeatures.put(typekey, merged);
            }
            for (Map.Entry<Object, IndexingLevel> requested : this.delayedClasses.entrySet()) {
                typekey = requested.getKey();
                old = this.directlyObservedClasses.get(typekey);
                merged = requested.getValue().merge(old);
                if (merged == old) continue;
                toGatherClasses.put(typekey, merged);
            }
            for (Map.Entry<Object, IndexingLevel> requested : this.delayedDataTypes.entrySet()) {
                typekey = requested.getKey();
                old = this.observedDataTypes.get(typekey);
                merged = requested.getValue().merge(old);
                if (merged == old) continue;
                toGatherDataTypes.put(typekey, merged);
            }
            this.delayedClasses.clear();
            this.delayedFeatures.clear();
            this.delayedDataTypes.clear();
            if (!(toGatherClasses.isEmpty() && toGatherFeatures.isEmpty() && toGatherDataTypes.isEmpty())) {
                HashMap<Object, IndexingLevel> oldClasses = new HashMap<Object, IndexingLevel>(this.directlyObservedClasses);
                toGatherClasses.forEach((key, value) -> {
                    IndexingLevel oldIndexingLevel = this.getIndexingLevel(this.metaStore.getKnownClassifierForKey(key));
                    if (value.hasInstances() && oldIndexingLevel.hasStatistics() && !oldIndexingLevel.hasInstances()) {
                        this.statsStore.removeType(key);
                    }
                });
                toGatherFeatures.forEach((key, value) -> {
                    IndexingLevel oldIndexingLevel = this.getIndexingLevel(this.metaStore.getKnownFeatureForKey(key));
                    if (value.hasInstances() && oldIndexingLevel.hasStatistics() && !oldIndexingLevel.hasInstances()) {
                        this.statsStore.removeType(key);
                    }
                });
                toGatherDataTypes.forEach((key, value) -> {
                    IndexingLevel oldIndexingLevel = this.getIndexingLevel(this.metaStore.getKnownClassifierForKey(key));
                    if (value.hasInstances() && oldIndexingLevel.hasStatistics() && !oldIndexingLevel.hasInstances()) {
                        this.statsStore.removeType(key);
                    }
                });
                boolean classesWarrantTraversal = this.startObservingClasses(toGatherClasses);
                this.observedDataTypes.putAll(toGatherDataTypes);
                this.observedFeatures.putAll(toGatherFeatures);
                if (classesWarrantTraversal || !toGatherFeatures.isEmpty() || !toGatherDataTypes.isEmpty()) {
                    final NavigationHelperVisitor.TraversingVisitor visitor = this.initTraversingVisitor(toGatherClasses, toGatherFeatures, toGatherDataTypes, oldClasses);
                    return new Callable<V>(){

                        @Override
                        public V call() throws Exception {
                            NavigationHelperImpl.this.ignoreResolveNotificationFeatures.addAll(toGatherFeatures.keySet());
                            try {
                                NavigationHelperImpl.this.traverse(visitor);
                            }
                            finally {
                                NavigationHelperImpl.this.ignoreResolveNotificationFeatures.removeAll(toGatherFeatures.keySet());
                            }
                            return null;
                        }
                    };
                }
            }
        }
        return null;
    }

    protected void executeTraversalCallbacks() throws InvocationTargetException {
        Runnable[] callbacks = this.traversalCallbacks.toArray(new Runnable[this.traversalCallbacks.size()]);
        this.traversalCallbacks.clear();
        if (callbacks.length > 0) {
            this.coalesceTraversals(() -> Arrays.stream(callbacks).forEach(Runnable::run));
        }
    }

    protected void traverse(NavigationHelperVisitor visitor) {
        for (Notifier root : new HashSet<Notifier>(this.modelRoots)) {
            this.comprehension.traverseModel(visitor, root);
        }
        this.notifyBaseIndexChangeListeners();
    }

    protected Stream<Notifier> getModelRoots() {
        return this.modelRoots.stream();
    }

    @Override
    public void addRoot(Notifier emfRoot) {
        this.addRootInternal(emfRoot);
    }

    protected void removeRoot(Notifier root) {
        IBaseIndexResourceFilter resourceFilter;
        if (!(root instanceof EObject || root instanceof Resource || root instanceof ResourceSet)) {
            throw new ViatraBaseException("Emf navigation helper can only be attached on the contents of an EMF EObject, Resource, or ResourceSet.");
        }
        if (!this.modelRoots.contains(root)) {
            return;
        }
        if (root instanceof Resource && (resourceFilter = this.getBaseIndexOptions().getResourceFilterConfiguration()) != null && resourceFilter.isResourceFiltered((Resource)root)) {
            return;
        }
        IBaseIndexObjectFilter objectFilter = this.getBaseIndexOptions().getObjectFilterConfiguration();
        if (objectFilter != null && objectFilter.isFiltered(root)) {
            return;
        }
        this.modelRoots.remove(root);
        this.contentAdapter.removeAdapter(root);
        this.notifyBaseIndexChangeListeners();
    }

    @Override
    public <T extends EObject> void cheapMoveTo(T element, EList<T> targetContainmentReferenceList) {
        if (element.eAdapters().contains((Object)this.contentAdapter) && targetContainmentReferenceList instanceof NotifyingList) {
            Object listNotifier = ((NotifyingList)targetContainmentReferenceList).getNotifier();
            if (listNotifier instanceof Notifier && ((Notifier)listNotifier).eAdapters().contains((Object)this.contentAdapter)) {
                this.contentAdapter.ignoreInsertionAndDeletion = element;
                try {
                    targetContainmentReferenceList.add(element);
                }
                finally {
                    this.contentAdapter.ignoreInsertionAndDeletion = null;
                }
            } else {
                targetContainmentReferenceList.add(element);
            }
        } else {
            targetContainmentReferenceList.add(element);
        }
    }

    @Override
    public void cheapMoveTo(EObject element, EObject parent, EReference containmentFeature) {
        this.metaStore.maintainMetamodel((EStructuralFeature)containmentFeature);
        if (containmentFeature.isMany()) {
            this.cheapMoveTo(element, (EList)parent.eGet((EStructuralFeature)containmentFeature));
        } else if (element.eAdapters().contains((Object)this.contentAdapter) && parent.eAdapters().contains((Object)this.contentAdapter)) {
            this.contentAdapter.ignoreInsertionAndDeletion = element;
            try {
                parent.eSet((EStructuralFeature)containmentFeature, (Object)element);
            }
            finally {
                this.contentAdapter.ignoreInsertionAndDeletion = null;
            }
        } else {
            parent.eSet((EStructuralFeature)containmentFeature, (Object)element);
        }
    }

    protected void addRootInternal(Notifier emfRoot) {
        if (!(emfRoot instanceof EObject || emfRoot instanceof Resource || emfRoot instanceof ResourceSet)) {
            throw new ViatraBaseException("Emf navigation helper can only be attached on the contents of an EMF EObject, Resource, or ResourceSet.");
        }
        this.expandToAdditionalRoot(emfRoot);
    }

    @Override
    public Set<EClass> getAllCurrentClasses() {
        return this.instanceStore.getAllCurrentClasses();
    }

    protected boolean isRegistrationNecessary(IndexingLevel level) {
        boolean inWildcardMode = this.isInWildcardMode(level);
        if (inWildcardMode && !this.loggedRegistrationMessage) {
            this.loggedRegistrationMessage = true;
            this.logger.warn((Object)"Type registration/unregistration not required in wildcard mode. This message will not be repeated for future occurences.");
        }
        return !inWildcardMode;
    }

    protected <X, Y> void ensureNoListeners(Set<Object> unobservedTypes, Map<Object, Map<X, Set<Y>>> listenerRegistry) {
        if (!Collections.disjoint(unobservedTypes, listenerRegistry.keySet())) {
            throw new IllegalStateException("Cannot unregister observed types for which there are active listeners");
        }
    }

    protected void ensureNoListenersForDispose() {
        if (!(this.baseIndexChangeListeners.isEmpty() && this.subscribedFeatureListeners.isEmpty() && this.subscribedDataTypeListeners.isEmpty() && this.subscribedInstanceListeners.isEmpty())) {
            throw new IllegalStateException("Cannot dispose while there are active listeners");
        }
    }

    @Override
    public void resampleDerivedFeatures() {
        if (!this.baseIndexOptions.isTraverseOnlyWellBehavingDerivedFeatures()) {
            Set<EClass> allCurrentClasses = this.instanceStore.getAllCurrentClasses();
            HashSet<EStructuralFeature> featuresToSample = new HashSet<EStructuralFeature>();
            for (EClass cls : allCurrentClasses) {
                EList features = cls.getEAllStructuralFeatures();
                for (EStructuralFeature f : features) {
                    if (!this.comprehension.onlySamplingFeature(f)) continue;
                    featuresToSample.add(f);
                }
            }
            EMFVisitor removalVisitor = this.contentAdapter.getVisitorForChange(false);
            EMFVisitor insertionVisitor = this.contentAdapter.getVisitorForChange(true);
            for (EStructuralFeature f : featuresToSample) {
                EClass containingClass = f.getEContainingClass();
                this.processAllInstances(containingClass, (type, instance) -> this.resampleFeatureValueForHolder((EObject)instance, f, insertionVisitor, removalVisitor));
            }
            this.notifyBaseIndexChangeListeners();
        }
    }

    protected void resampleFeatureValueForHolder(EObject source, EStructuralFeature feature, EMFVisitor insertionVisitor, EMFVisitor removalVisitor) {
        Object newValue = source.eGet(feature);
        Set<Object> oldValues = this.instanceStore.getOldValuesForHolderAndFeature(source, this.toKey(feature));
        if (feature.isMany()) {
            this.resampleManyFeatureValueForHolder(source, feature, newValue, oldValues, insertionVisitor, removalVisitor);
        } else {
            this.resampleSingleFeatureValueForHolder(source, feature, newValue, oldValues, insertionVisitor, removalVisitor);
        }
    }

    protected void resampleManyFeatureValueForHolder(EObject source, EStructuralFeature feature, Object newValue, Set<Object> oldValues, EMFVisitor insertionVisitor, EMFVisitor removalVisitor) {
        InternalEObject internalEObject = (InternalEObject)source;
        Collection newValues = (Collection)newValue;
        HashSet newValueSet = new HashSet(newValues);
        newValueSet.removeAll(oldValues);
        oldValues.removeAll(newValues);
        if (!oldValues.isEmpty()) {
            for (Object ov : oldValues) {
                this.comprehension.traverseFeature(removalVisitor, source, feature, ov, null);
            }
            ENotificationImpl removeNotification = new ENotificationImpl(internalEObject, 6, feature, oldValues, null);
            this.notifyLightweightObservers(source, feature, (Notification)removeNotification);
        }
        if (!newValueSet.isEmpty()) {
            for (Object nv : newValueSet) {
                this.comprehension.traverseFeature(insertionVisitor, source, feature, nv, null);
            }
            ENotificationImpl addNotification = new ENotificationImpl(internalEObject, 5, feature, null, newValueSet);
            this.notifyLightweightObservers(source, feature, (Notification)addNotification);
        }
    }

    protected void resampleSingleFeatureValueForHolder(EObject source, EStructuralFeature feature, Object newValue, Set<Object> oldValues, EMFVisitor insertionVisitor, EMFVisitor removalVisitor) {
        InternalEObject internalEObject = (InternalEObject)source;
        Object oldValue = oldValues.stream().findFirst().orElse(null);
        if (!Objects.equals(oldValue, newValue)) {
            this.comprehension.traverseFeature(removalVisitor, source, feature, oldValue, null);
            this.comprehension.traverseFeature(insertionVisitor, source, feature, newValue, null);
            ENotificationImpl notification = new ENotificationImpl(internalEObject, 1, feature, oldValue, newValue);
            this.notifyLightweightObservers(source, feature, (Notification)notification);
        }
    }

    @Override
    public int countAllInstances(EClass type) {
        int result = 0;
        Object typeKey = this.toKey((EClassifier)type);
        Set<Object> subTypes = this.metaStore.getSubTypeMap().get(typeKey);
        if (subTypes != null) {
            for (Object subTypeKey : subTypes) {
                result += this.statsStore.countInstances(subTypeKey);
            }
        }
        return result += this.statsStore.countInstances(typeKey);
    }

    @Override
    public int countDataTypeInstances(EDataType dataType) {
        return this.statsStore.countInstances(this.toKey((EClassifier)dataType));
    }

    @Override
    public int countFeatureTargets(EObject seedSource, EStructuralFeature feature) {
        return this.featureData(feature).getDistinctValuesOfHolder(seedSource).size();
    }

    @Override
    public int countFeatures(EStructuralFeature feature) {
        return this.statsStore.countFeatures(this.toKey(feature));
    }

    protected IndexingLevel getIndexingLevel(Object type) {
        if (type instanceof EClass) {
            return this.getIndexingLevel((EClass)type);
        }
        if (type instanceof EDataType) {
            return this.getIndexingLevel((EDataType)type);
        }
        if (type instanceof EStructuralFeature) {
            return this.getIndexingLevel((EStructuralFeature)type);
        }
        throw new IllegalArgumentException("Unexpected type descriptor " + type.toString());
    }

    @Override
    public IndexingLevel getIndexingLevel(EClass type) {
        Object key = this.toKey((EClassifier)type);
        IndexingLevel level = this.directlyObservedClasses.get(key);
        if (level == null) {
            level = this.delayedClasses.get(key);
        }
        return this.wildcardMode.merge(level);
    }

    @Override
    public IndexingLevel getIndexingLevel(EDataType type) {
        Object key = this.toKey((EClassifier)type);
        IndexingLevel level = this.observedDataTypes.get(key);
        if (level == null) {
            level = this.delayedDataTypes.get(key);
        }
        return this.wildcardMode.merge(level);
    }

    @Override
    public IndexingLevel getIndexingLevel(EStructuralFeature feature) {
        Object key = this.toKey(feature);
        IndexingLevel level = this.observedFeatures.get(key);
        if (level == null) {
            level = this.delayedFeatures.get(key);
        }
        return this.wildcardMode.merge(level);
    }

    @Override
    public void executeAfterTraversal(Runnable traversalCallback) throws InvocationTargetException {
        this.coalesceTraversals(() -> this.traversalCallbacks.add(traversalCallback));
    }

    protected void logIncident(Supplier<String> msgProvider) {
        if (this.baseIndexOptions.isStrictNotificationMode()) {
            String msg = msgProvider.get();
            this.notifyFatalListener(msg, new IllegalStateException(msg));
        } else if (this.notificationErrorReported) {
            if (this.logger.isDebugEnabled()) {
                String msg = msgProvider.get();
                this.logger.debug((Object)msg);
            }
        } else {
            this.notificationErrorReported = true;
            String msg = msgProvider.get();
            this.logger.error((Object)msg);
        }
    }

    protected NavigationHelperContentAdapter initContentAdapter() {
        switch (this.baseIndexOptions.getIndexerProfilerMode()) {
            case START_DISABLED: {
                return new ProfilingNavigationHelperContentAdapter(this, false);
            }
            case START_ENABLED: {
                return new ProfilingNavigationHelperContentAdapter(this, true);
            }
        }
        return new NavigationHelperContentAdapter(this);
    }

    protected EMFBaseIndexStatisticsStore initStatStore() {
        return new EMFBaseIndexStatisticsStore(this, this.logger);
    }

    protected EMFBaseIndexInstanceStore initInstanceStore() {
        return new EMFBaseIndexInstanceStore(this, this.logger);
    }

    protected EMFBaseIndexMetaStore initMetaStore() {
        return new EMFBaseIndexMetaStore(this);
    }

    protected EMFModelComprehension initModelComprehension() {
        return new EMFModelComprehension(this.baseIndexOptions);
    }

    protected NavigationHelperVisitor.TraversingVisitor initTraversingVisitor(Map<Object, IndexingLevel> toGatherClasses, Map<Object, IndexingLevel> toGatherFeatures, Map<Object, IndexingLevel> toGatherDataTypes, Map<Object, IndexingLevel> oldClasses) {
        return new NavigationHelperVisitor.TraversingVisitor(this, toGatherFeatures, toGatherClasses, oldClasses, toGatherDataTypes);
    }

    protected void logIncidentAdapterRemoval(Notifier notifier) {
        this.logIncident(() -> String.format("Erroneous removal of unattached notification adapter from notifier %s", notifier));
    }

    protected void logIncidentFeatureTupleInsertion(Object value, EObject holder, Object featureKey) {
        this.logIncident(() -> String.format("Error: trying to add duplicate value %s to the unique feature %s of host object %s. This indicates some errors in underlying model representation.", value, featureKey, holder));
    }

    protected void logIncidentFeatureTupleRemoval(Object value, EObject holder, Object featureKey) {
        this.logIncident(() -> String.format("Error: trying to remove duplicate value %s from the unique feature %s of host object %s. This indicates some errors in underlying model representation.", value, featureKey, holder));
    }

    protected void logIncidentInstanceInsertion(Object keyClass, EObject value) {
        this.logIncident(() -> String.format("Notification received to index %s as a %s, but it already exists in the index. This indicates some errors in underlying model representation.", value, keyClass));
    }

    protected void logIncidentInstanceRemoval(Object keyClass, EObject value) {
        this.logIncident(() -> String.format("Notification received to remove %s as a %s, but it is missing from the index. This indicates some errors in underlying model representation.", value, keyClass));
    }

    protected void logIncidentStatRemoval(Object key) {
        this.logIncident(() -> String.format("No instances of %s is registered before calling removeInstance method.", key));
    }
}

