/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.base;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public enum DseIdPoolHelper {
    INSTANCE;

    private ConcurrentHashMap<Thread, HashMap<BatchTransformationRule<?, ?>, IdProvider>> idProviders = new ConcurrentHashMap();

    public int getId(BatchTransformationRule<?, ?> rule) {
        Thread currentThread = Thread.currentThread();
        HashMap<BatchTransformationRule<?, ?>, IdProvider> ruleMap = this.idProviders.get(currentThread);
        if (ruleMap == null) {
            throw new DSEException("There is no registered id provider");
        }
        IdProvider idProvider = ruleMap.get(rule);
        return idProvider.getId();
    }

    public void registerRules(IGetRuleExecutions getRuleExecutions, Collection<BatchTransformationRule<?, ?>> rules) {
        Thread currentThread = Thread.currentThread();
        HashMap ruleMap = new HashMap();
        for (BatchTransformationRule<?, ?> rule : rules) {
            IdProvider idProvider = new IdProvider(getRuleExecutions, rule);
            ruleMap.put(rule, idProvider);
        }
        this.idProviders.put(currentThread, ruleMap);
    }

    public void disposeByThread() {
        Thread currentThread = Thread.currentThread();
        this.idProviders.remove(currentThread);
    }

    public static interface IGetRuleExecutions {
        public int getRuleExecutions(BatchTransformationRule<?, ?> var1);
    }

    public static class IdProvider {
        private final BatchTransformationRule<?, ?> rule;
        private IGetRuleExecutions getRuleExecutions;

        public IdProvider(IGetRuleExecutions getRuleExecutions, BatchTransformationRule<?, ?> rule) {
            this.getRuleExecutions = getRuleExecutions;
            this.rule = rule;
        }

        public int getId() {
            return this.getRuleExecutions.getRuleExecutions(this.rule);
        }
    }
}

