/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.filters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;

public class MatchParameterPredicateFilter
implements EventFilter<IPatternMatch> {
    private Map<String, Predicate<Object>> filterMap;

    public MatchParameterPredicateFilter(String name, Predicate<Object> parameterMatcher) {
        this.filterMap = new HashMap<String, Predicate<Object>>();
        this.filterMap.put(name, parameterMatcher);
    }

    public MatchParameterPredicateFilter(Map<String, Predicate<Object>> parameterMatchers) {
        this.filterMap = new HashMap<String, Predicate<Object>>();
        this.filterMap.putAll(this.filterMap);
    }

    @SafeVarargs
    public MatchParameterPredicateFilter(Map.Entry<String, Predicate<Object>> ... parameters) {
        this.filterMap = Arrays.stream(parameters).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean isProcessable(IPatternMatch eventAtom) {
        return eventAtom.parameterNames().stream().noneMatch(it -> this.filterMap.containsKey(it) && !this.filterMap.get(it).test(eventAtom.get(it)));
    }
}

