/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.planar.AbstractArcBasedGeometry;
import org.eclipse.gef4.geometry.planar.AbstractRectangleBasedGeometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Arc;
import org.eclipse.gef4.geometry.planar.BezierCurve;
import org.eclipse.gef4.geometry.planar.CubicCurve;
import org.eclipse.gef4.geometry.planar.CurveUtils;
import org.eclipse.gef4.geometry.planar.CurvedPolygon;
import org.eclipse.gef4.geometry.planar.Ellipse;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.IShape;
import org.eclipse.gef4.geometry.planar.Line;
import org.eclipse.gef4.geometry.planar.Path;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;
import org.eclipse.gef4.geometry.planar.Rectangle;
import org.eclipse.gef4.geometry.planar.ShapeUtils;
import org.eclipse.gef4.geometry.utils.PrecisionUtils;

public class Pie
extends AbstractArcBasedGeometry<Pie, Path>
implements IShape {
    private static final long serialVersionUID = 1L;

    public Pie(AbstractRectangleBasedGeometry<?, ?> r, Angle startAngle, Angle angularExtent) {
        super(r.x, r.y, r.width, r.height, startAngle, angularExtent);
    }

    public Pie(Arc arc) {
        super(arc.x, arc.y, arc.width, arc.height, arc.startAngle, arc.angularExtent);
    }

    public Pie(double x, double y, double width, double height, Angle startAngle, Angle angularExtent) {
        super(x, y, width, height, startAngle, angularExtent);
    }

    @Override
    public boolean contains(IGeometry g) {
        return ShapeUtils.contains((IShape)this, g);
    }

    @Override
    public boolean contains(Point p) {
        Angle pAngle = new Vector(1.0, 0.0).getAngleCCW(new Vector(this.getCenter(), p));
        if (!PrecisionUtils.greater(pAngle.rad(), this.startAngle.rad()) || !PrecisionUtils.smaller(pAngle.rad(), this.startAngle.getAdded(this.angularExtent).rad())) {
            return false;
        }
        return new Ellipse(this.x, this.y, this.width, this.height).contains(p);
    }

    @Override
    public Rectangle getBounds() {
        return this.getOutline().getBounds();
    }

    @Override
    public Pie getCopy() {
        return new Pie(this.x, this.y, this.width, this.height, this.startAngle, this.angularExtent);
    }

    @Override
    public PolyBezier getOutline() {
        return new PolyBezier(this.getOutlineSegments());
    }

    public BezierCurve[] getOutlineSegments() {
        CubicCurve[] arcSegs = this.computeBezierApproximation();
        BezierCurve[] outlineSegs = new BezierCurve[arcSegs.length + 2];
        int i = 0;
        while (i < arcSegs.length) {
            outlineSegs[i] = arcSegs[i];
            ++i;
        }
        outlineSegs[outlineSegs.length - 2] = new Line(outlineSegs[outlineSegs.length - 3].getP2(), this.getCenter());
        outlineSegs[outlineSegs.length - 1] = new Line(this.getCenter(), outlineSegs[0].getP1());
        return outlineSegs;
    }

    @Override
    public Path getRotatedCCW(Angle angle) {
        return this.getRotatedCCW(angle, this.getCenter());
    }

    @Override
    public Path getRotatedCCW(Angle angle, double cx, double cy) {
        return new PolyBezier(this.computeBezierApproximation()).rotateCCW(angle, cx, cy).toPath();
    }

    @Override
    public Path getRotatedCCW(Angle angle, Point center) {
        return new PolyBezier(this.computeBezierApproximation()).rotateCCW(angle, center).toPath();
    }

    @Override
    public Path getRotatedCW(Angle angle) {
        return this.getRotatedCW(angle, this.getCenter());
    }

    @Override
    public Path getRotatedCW(Angle angle, double cx, double cy) {
        return new PolyBezier(this.computeBezierApproximation()).rotateCW(angle, cx, cy).toPath();
    }

    @Override
    public Path getRotatedCW(Angle angle, Point center) {
        return new PolyBezier(this.computeBezierApproximation()).rotateCW(angle, center).toPath();
    }

    @Override
    public CurvedPolygon getTransformed(AffineTransform t) {
        return new CurvedPolygon(this.getOutlineSegments()).getTransformed(t);
    }

    @Override
    public Path toPath() {
        CubicCurve[] arc = this.computeBezierApproximation();
        Line endToMid = new Line(arc[arc.length - 1].getP2(), this.getCenter());
        Line midToStart = new Line(this.getCenter(), arc[0].getP1());
        ICurve[] curves = new ICurve[arc.length + 2];
        int i = 0;
        while (i < arc.length) {
            curves[i] = arc[i];
            ++i;
        }
        curves[arc.length] = endToMid;
        curves[arc.length + 1] = midToStart;
        return CurveUtils.toPath(curves);
    }
}

