/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import org.eclipse.gef4.layout.PropertyStoreSupport;
import org.eclipse.gef4.layout.interfaces.ConnectionLayout;
import org.eclipse.gef4.layout.interfaces.NodeLayout;
import org.eclipse.gef4.zest.core.widgets.GraphConnection;
import org.eclipse.gef4.zest.core.widgets.InternalLayoutContext;
import org.eclipse.gef4.zest.core.widgets.ZestStyles;

class InternalConnectionLayout
implements ConnectionLayout {
    private final GraphConnection graphConnection;
    private InternalLayoutContext layoutContext;
    private PropertyStoreSupport ps = new PropertyStoreSupport();

    InternalConnectionLayout(GraphConnection graphConnection, InternalLayoutContext layoutContext) {
        this.graphConnection = graphConnection;
        this.layoutContext = layoutContext;
        this.setProperty("visible", graphConnection.isVisible());
    }

    public NodeLayout getSource() {
        return this.graphConnection.getSource().getLayout();
    }

    public NodeLayout getTarget() {
        return this.graphConnection.getDestination().getLayout();
    }

    public double getWeight() {
        return this.graphConnection.getWeightInLayout();
    }

    public boolean isDirected() {
        return !ZestStyles.checkStyle(this.graphConnection.getConnectionStyle(), 2);
    }

    public boolean isVisible() {
        return (Boolean)this.getProperty("visible");
    }

    public void setVisible(boolean visible) {
        this.layoutContext.checkChangesAllowed();
        this.setProperty("visible", visible);
    }

    void applyLayout() {
        boolean visible = this.isVisible();
        if (this.graphConnection.isVisible() != visible) {
            this.graphConnection.setVisible(visible);
        }
    }

    public void setProperty(String name, Object value) {
        this.ps.setProperty(name, value);
    }

    public Object getProperty(String name) {
        return this.ps.getProperty(name);
    }
}

