/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets;

import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.layout.interfaces.EntityLayout;
import org.eclipse.gef4.layout.interfaces.LayoutContext;
import org.eclipse.gef4.layout.interfaces.NodeLayout;
import org.eclipse.gef4.zest.core.widgets.DefaultSubgraph;

public abstract class FigureSubgraph
extends DefaultSubgraph {
    protected IFigure figure;
    private Point location;
    private boolean isLayoutBeingApplied = false;

    protected abstract void createFigure();

    protected abstract void updateFigure();

    public IFigure getFigure() {
        if (this.figure == null) {
            this.createFigure();
            this.updateFigure();
            this.figure.addFigureListener((FigureListener)new SubgraphFigrueListener());
            this.context.container.addSubgraphFigure(this.figure);
        }
        return this.figure;
    }

    protected FigureSubgraph(NodeLayout[] nodes, LayoutContext context) {
        super(context);
        this.addNodes(nodes);
    }

    public void addNodes(NodeLayout[] nodes) {
        int initialCount = this.nodes.size();
        super.addNodes(nodes);
        if (this.nodes.size() > initialCount && this.figure != null) {
            this.updateFigure();
            if (this.location != null) {
                int i = 0;
                while (i < nodes.length) {
                    nodes[i].setLocation(this.location.x, this.location.y);
                    ++i;
                }
            }
        }
    }

    public void removeNodes(NodeLayout[] nodes) {
        int initialCount = this.nodes.size();
        super.removeNodes(nodes);
        if (this.nodes.size() < initialCount && this.figure != null && !this.disposed) {
            this.updateFigure();
        }
    }

    public EntityLayout[] getSuccessingEntities() {
        return super.getSuccessingEntities();
    }

    public EntityLayout[] getPredecessingEntities() {
        return super.getPredecessingEntities();
    }

    public org.eclipse.gef4.geometry.planar.Dimension getSize() {
        Dimension size = this.getFigure().getSize();
        return new org.eclipse.gef4.geometry.planar.Dimension((double)size.width, (double)size.height);
    }

    public Point getLocation() {
        if (this.location == null) {
            org.eclipse.draw2d.geometry.Point location2 = this.getFigure().getBounds().getLocation();
            Dimension size = this.getFigure().getSize();
            return new Point((double)(location2.x + size.width / 2), (double)(location2.y + size.height / 2));
        }
        return new Point(this.location);
    }

    public void setLocation(double x, double y) {
        super.setLocation(x, y);
        for (NodeLayout node : this.nodes) {
            node.setLocation(x, y);
        }
        if (this.location != null) {
            this.location.x = x;
            this.location.y = y;
        } else {
            this.location = new Point(x, y);
            this.applyLayoutChanges();
        }
    }

    protected void refreshLocation() {
        Rectangle bounds = this.figure.getBounds();
        if (this.location == null) {
            this.location = new Point(0.0, 0.0);
        }
        this.location.x = bounds.x + bounds.width / 2;
        this.location.y = bounds.y + bounds.height / 2;
    }

    public boolean isGraphEntity() {
        return true;
    }

    public boolean isMovable() {
        return true;
    }

    protected void dispose() {
        if (!this.disposed) {
            super.dispose();
            if (this.figure != null) {
                this.context.container.getGraph().removeSubgraphFigure(this.figure);
            }
        }
    }

    protected void applyLayoutChanges() {
        this.getFigure();
        if (this.location != null) {
            this.isLayoutBeingApplied = true;
            Dimension size = this.figure.getSize();
            this.figure.setLocation((org.eclipse.draw2d.geometry.Point)new PrecisionPoint(this.location.x - (double)(size.width / 2), this.location.y - (double)(size.height / 2)));
            this.isLayoutBeingApplied = false;
        }
    }

    protected class SubgraphFigrueListener
    implements FigureListener {
        private Rectangle previousBounds;

        protected SubgraphFigrueListener() {
            this.previousBounds = FigureSubgraph.this.figure.getBounds().getCopy();
        }

        public void figureMoved(IFigure source) {
            if (Animation.isAnimating() || FigureSubgraph.this.isLayoutBeingApplied) {
                return;
            }
            Rectangle newBounds = FigureSubgraph.this.figure.getBounds();
            if (!newBounds.getSize().equals((Object)this.previousBounds.getSize())) {
                FigureSubgraph.this.context.fireSubgraphResizedEvent(FigureSubgraph.this);
            } else if (!newBounds.getLocation().equals((Object)this.previousBounds.getLocation())) {
                FigureSubgraph.this.context.fireSubgraphMovedEvent(FigureSubgraph.this);
            }
            this.previousBounds = newBounds.getCopy();
        }
    }
}

