/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

public abstract class AbstractCharArray {
    public abstract int tryGetLength();

    public abstract int getLength();

    public abstract boolean isValidOffset(int var1);

    public abstract long getContentsHash();

    public abstract char get(int var1);

    public abstract void arraycopy(int var1, char[] var2, int var3, int var4);

    public CharSequence subSequence(int start, int end) {
        return new SubArray(start, end);
    }

    public abstract boolean hasError();

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int pos = 0;
        while (this.isValidOffset(pos)) {
            buf.append(this.get(pos));
            ++pos;
        }
        return buf.toString();
    }

    private class SubArray
    implements CharSequence {
        private final int start;
        private final int end;

        SubArray(int start, int end) {
            this.checkStartEnd(start, end);
            this.start = start;
            this.end = end;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            return AbstractCharArray.this.get(this.start + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            this.checkStartEnd(start, end);
            if (end > this.end - this.start) {
                throw new IndexOutOfBoundsException(String.valueOf(end));
            }
            return new SubArray(this.start + start, this.start + end);
        }

        private void checkStartEnd(int start, int end) {
            if (start < 0) {
                throw new IndexOutOfBoundsException(String.valueOf(start));
            }
            if (end < start) {
                throw new IndexOutOfBoundsException(String.valueOf(end) + " < " + String.valueOf(start));
            }
        }
    }
}

