/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader;

import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDTestFacility;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfUml2SDSyncLoaderPagesTest {
    private static Uml2SDTestFacility fFacility;

    @BeforeClass
    public static void setUpClass() {
        fFacility = Uml2SDTestFacility.getInstance();
        fFacility.init();
        fFacility.selectExperiment();
    }

    @AfterClass
    public static void tearDownClass() {
        fFacility.disposeExperiment();
        fFacility.dispose();
        fFacility = null;
    }

    @Test
    public void verifyPagesCount() {
        Assert.assertEquals((long)9L, (long)fFacility.getLoader().pagesCount());
    }

    @Test
    public void verifyNextPage() {
        int i = 0;
        while (i < 7) {
            fFacility.nextPage();
            if (i + 1 == 4) {
                TmfUml2SDSyncLoaderPagesTest.verifyPage(i + 1, 10000, true, true, 3);
            } else {
                TmfUml2SDSyncLoaderPagesTest.verifyPage(i + 1, 10000, true, true);
            }
            ++i;
        }
        fFacility.nextPage();
        TmfUml2SDSyncLoaderPagesTest.verifyPage(8, 32, false, true);
        try {
            fFacility.getLoader().nextPage();
        }
        catch (Exception e) {
            Assert.fail();
        }
        fFacility.firstPage();
    }

    @Test
    public void verifyPrevPage() {
        fFacility.lastPage();
        Assert.assertEquals((long)8L, (long)fFacility.getLoader().currentPage());
        Assert.assertEquals((long)32L, (long)fFacility.getSdView().getFrame().syncMessageCount());
        Assert.assertFalse((boolean)fFacility.getLoader().hasNextPage());
        Assert.assertTrue((boolean)fFacility.getLoader().hasPrevPage());
        Assert.assertEquals((long)2L, (long)fFacility.getSdView().getFrame().lifeLinesCount());
        int i = 7;
        while (i > 0) {
            fFacility.prevPage();
            if (i == 4) {
                TmfUml2SDSyncLoaderPagesTest.verifyPage(i, 10000, true, true, 3);
            } else {
                TmfUml2SDSyncLoaderPagesTest.verifyPage(i, 10000, true, true);
            }
            --i;
        }
        fFacility.prevPage();
        TmfUml2SDSyncLoaderPagesTest.verifyPage(0, 10000, true, false);
        try {
            fFacility.getLoader().prevPage();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void verifyFirstPage() {
        fFacility.lastPage();
        fFacility.firstPage();
        TmfUml2SDSyncLoaderPagesTest.verifyPage(0, 10000, true, false);
    }

    @Test
    public void verifyLastPage() {
        fFacility.lastPage();
        TmfUml2SDSyncLoaderPagesTest.verifyPage(8, 32, false, true);
        fFacility.firstPage();
    }

    @Test
    public void verifyPageNumberChanged() {
        fFacility.setPage(4);
        TmfUml2SDSyncLoaderPagesTest.verifyPage(4, 10000, true, true, 3);
        fFacility.firstPage();
    }

    private static void verifyPage(int currentPage, int numMsg, boolean hasNext, boolean hasPrev) {
        TmfUml2SDSyncLoaderPagesTest.verifyPage(currentPage, numMsg, hasNext, hasPrev, 2);
    }

    private static void verifyPage(int currentPage, int numMsg, boolean hasNext, boolean hasPrev, int lifelineCount) {
        Assert.assertEquals((String)"currentPage", (long)currentPage, (long)fFacility.getLoader().currentPage());
        Assert.assertEquals((String)"syncMessageCount, ", (long)numMsg, (long)fFacility.getSdView().getFrame().syncMessageCount());
        if (hasNext) {
            Assert.assertTrue((String)"hasNextpage", (boolean)fFacility.getLoader().hasNextPage());
        } else {
            Assert.assertFalse((String)"hasNextPage", (boolean)fFacility.getLoader().hasNextPage());
        }
        if (hasPrev) {
            Assert.assertTrue((String)"hasPrevPage", (boolean)fFacility.getLoader().hasPrevPage());
        } else {
            Assert.assertFalse((String)"hasPrevPage", (boolean)fFacility.getLoader().hasPrevPage());
        }
        Assert.assertEquals((String)"lifeLinesCount", (long)lifelineCount, (long)fFacility.getSdView().getFrame().lifeLinesCount());
    }
}

