/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.repository.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ease.service.IScriptService;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ui.PlatformUI;

public class InputStreamParser {
    private static final int MAX_LINES = 50;
    private static final Pattern CONTENT_TYPE_PATTERN = Pattern.compile(".*script-type:\\s*(.*)", 2);

    protected static IRepositoryService getRepositoryService() {
        return (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
    }

    protected static ScriptType getScriptType(InputStream contents) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(contents));
        try {
            String line = reader.readLine();
            int lineCount = 50;
            while (line != null && lineCount-- > 0) {
                IScriptService scriptService;
                ScriptType scriptType;
                Matcher matcher = CONTENT_TYPE_PATTERN.matcher(line);
                if (!matcher.matches() || (scriptType = (ScriptType)(scriptService = (IScriptService)PlatformUI.getWorkbench().getService(IScriptService.class)).getAvailableScriptTypes().get(matcher.group(1))) == null) continue;
                return scriptType;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

