/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.IDataDrivenRuntimeObject;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.values.DataDrivenValue;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public interface DataDrivenCondition
extends IDataDrivenRuntimeObject {
    public static final DataDrivenCondition TRUE_CONDITION = (e, s, c) -> true;

    public boolean test(ITmfEvent var1, DataDrivenScenarioInfo var2, IAnalysisDataContainer var3);

    public static enum ConditionOperator implements Predicate<Integer>
    {
        EQ(i -> i == 0),
        NE(i -> i != 0),
        GE(i -> i >= 0),
        GT(i -> i > 0),
        LE(i -> i <= 0),
        LT(i -> i < 0);

        private final Function<Integer, Boolean> fCmpFunction;

        private ConditionOperator(Function<Integer, Boolean> cmpFunction) {
            this.fCmpFunction = cmpFunction;
        }

        @Override
        public boolean test(Integer cmpValue) {
            return Objects.requireNonNull(this.fCmpFunction.apply(cmpValue));
        }
    }

    public static class DataDrivenAndCondition
    implements DataDrivenCondition {
        private final List<DataDrivenCondition> fConditions;

        public DataDrivenAndCondition(List<DataDrivenCondition> conditions) {
            this.fConditions = conditions;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            for (DataDrivenCondition cond : this.fConditions) {
                if (cond.test(event, scenarioInfo, container)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return Objects.hash(DataDrivenAndCondition.class, this.fConditions);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof DataDrivenAndCondition)) {
                return false;
            }
            DataDrivenAndCondition other = (DataDrivenAndCondition)obj;
            return Objects.equals(this.fConditions, other.fConditions);
        }

        public String toString() {
            return "AND: " + this.fConditions.toString();
        }
    }

    public static class DataDrivenComparisonCondition
    implements DataDrivenCondition {
        private final ConditionOperator fOperator;
        private final DataDrivenValue fFirstValue;
        private final DataDrivenValue fSecondValue;

        public DataDrivenComparisonCondition(DataDrivenValue firstValue, DataDrivenValue secondValue, ConditionOperator operator) {
            this.fFirstValue = firstValue;
            this.fSecondValue = secondValue;
            this.fOperator = operator;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            Object firstValue = this.fFirstValue.getValue(event, -1, scenarioInfo, container);
            Object secondValue = this.fSecondValue.getValue(event, -1, scenarioInfo, container);
            Integer cmpVal = null;
            cmpVal = firstValue instanceof Integer && secondValue instanceof Number ? Integer.valueOf(((Integer)firstValue).compareTo(((Number)secondValue).intValue())) : (firstValue instanceof Long && secondValue instanceof Number ? Integer.valueOf(((Long)firstValue).compareTo(((Number)secondValue).longValue())) : Integer.valueOf(String.valueOf(firstValue).compareTo(String.valueOf(secondValue))));
            return this.fOperator.test(cmpVal);
        }

        public int hashCode() {
            return Objects.hash(this.fOperator, this.fFirstValue, this.fSecondValue);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof DataDrivenComparisonCondition)) {
                return false;
            }
            DataDrivenComparisonCondition other = (DataDrivenComparisonCondition)obj;
            return Objects.equals(this.fOperator, other.fOperator) && Objects.equals(this.fFirstValue, other.fFirstValue) && Objects.equals(this.fSecondValue, other.fSecondValue);
        }

        public String toString() {
            return String.valueOf(this.fFirstValue.toString()) + ' ' + this.fOperator.toString() + ' ' + this.fSecondValue.toString();
        }
    }

    public static class DataDrivenElapsedTimeCondition
    implements DataDrivenCondition {
        private final ConditionOperator fOperator;
        private final String fReference;
        private final long fValue;

        public DataDrivenElapsedTimeCondition(ConditionOperator operator, String reference, long value) {
            this.fOperator = operator;
            this.fReference = reference;
            this.fValue = value;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            long ts = event.getTimestamp().toNanos();
            long referenceTs = scenarioInfo.getStateStartTime(container, this.fReference);
            if (referenceTs < 0L) {
                return false;
            }
            return this.fOperator.test(Long.compare(ts - referenceTs, this.fValue));
        }

        public int hashCode() {
            return Objects.hash(this.fOperator, this.fReference, this.fValue);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof DataDrivenElapsedTimeCondition)) {
                return false;
            }
            DataDrivenElapsedTimeCondition other = (DataDrivenElapsedTimeCondition)obj;
            return Objects.equals(this.fOperator, other.fOperator) && Objects.equals(this.fReference, other.fReference) && this.fValue == other.fValue;
        }

        public String toString() {
            return "Elapsed time condition: " + this.fOperator.toString() + ' ' + this.fReference + ',' + this.fValue;
        }
    }

    public static class DataDrivenNotCondition
    implements DataDrivenCondition {
        private final DataDrivenCondition fCondition;

        public DataDrivenNotCondition(DataDrivenCondition condition) {
            this.fCondition = condition;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            return !this.fCondition.test(event, scenarioInfo, container);
        }

        public int hashCode() {
            return Objects.hash(DataDrivenNotCondition.class, this.fCondition);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof DataDrivenNotCondition)) {
                return false;
            }
            DataDrivenNotCondition other = (DataDrivenNotCondition)obj;
            return Objects.equals(this.fCondition, other.fCondition);
        }

        public String toString() {
            return "NOT: " + this.fCondition.toString();
        }
    }

    public static class DataDrivenOrCondition
    implements DataDrivenCondition {
        private final List<DataDrivenCondition> fConditions;

        public DataDrivenOrCondition(List<DataDrivenCondition> conditions) {
            this.fConditions = conditions;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            for (DataDrivenCondition cond : this.fConditions) {
                if (!cond.test(event, scenarioInfo, container)) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(DataDrivenOrCondition.class, this.fConditions);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof DataDrivenOrCondition)) {
                return false;
            }
            DataDrivenOrCondition other = (DataDrivenOrCondition)obj;
            return Objects.equals(this.fConditions, other.fConditions);
        }

        public String toString() {
            return "OR: " + this.fConditions.toString();
        }
    }

    public static class DataDrivenRegexCondition
    implements DataDrivenCondition {
        private final Pattern fPattern;
        private final DataDrivenValue fValue;

        public DataDrivenRegexCondition(Pattern pattern, DataDrivenValue value) {
            this.fPattern = pattern;
            this.fValue = value;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            Object value = this.fValue.getValue(event, -1, scenarioInfo, container);
            if (value == null) {
                return false;
            }
            return this.fPattern.matcher(String.valueOf(value)).matches();
        }

        public int hashCode() {
            return Objects.hash(String.valueOf(this.fPattern), this.fValue);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof DataDrivenRegexCondition)) {
                return false;
            }
            DataDrivenRegexCondition other = (DataDrivenRegexCondition)obj;
            return Objects.equals(String.valueOf(this.fPattern), String.valueOf(other.fPattern)) && Objects.equals(this.fValue, other.fValue);
        }

        public String toString() {
            return String.valueOf(this.fValue.toString()) + " matches " + this.fPattern;
        }
    }

    public static class DataDrivenTimeRangeCondition
    implements DataDrivenCondition {
        private final TimeRangeOperator fOperator;
        private final long fBegin;
        private final long fEnd;

        public DataDrivenTimeRangeCondition(TimeRangeOperator operator, long begin, long end) {
            this.fOperator = operator;
            this.fBegin = begin;
            this.fEnd = end;
        }

        @Override
        public boolean test(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
            long ts = event.getTimestamp().toNanos();
            return this.fOperator.test(ts >= this.fBegin && ts <= this.fEnd);
        }

        public int hashCode() {
            return Objects.hash(this.fOperator, this.fBegin, this.fEnd);
        }

        public boolean equals(@Nullable Object obj) {
            if (!(obj instanceof DataDrivenTimeRangeCondition)) {
                return false;
            }
            DataDrivenTimeRangeCondition other = (DataDrivenTimeRangeCondition)obj;
            return Objects.equals(this.fOperator, other.fOperator) && this.fBegin == other.fBegin && this.fEnd == other.fEnd;
        }

        public String toString() {
            return "Time range conditions: " + this.fOperator.toString() + ' ' + this.fBegin + ',' + this.fEnd;
        }
    }

    public static enum TimeRangeOperator implements Predicate<Boolean>
    {
        IN(i -> i),
        OUT(i -> i == false);

        private final Function<Boolean, Boolean> fResultFunction;

        private TimeRangeOperator(Function<Boolean, Boolean> cmpFunction) {
            this.fResultFunction = cmpFunction;
        }

        @Override
        public boolean test(Boolean t) {
            return Objects.requireNonNull(this.fResultFunction.apply(t));
        }
    }
}

