/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.data.xy;

import org.jfree.data.Range;
import org.jfree.data.xy.XYSeries;

public class XYScaledSeries
extends XYSeries {
    private static final long serialVersionUID = 5321740573688656080L;
    private final Range scaledXRange;
    private final Range scaledYRange;

    public XYScaledSeries(Comparable<?> key, Range XScale, Range YScale) {
        this(key, XScale, YScale, true, true);
    }

    public XYScaledSeries(Comparable<?> key, Range XScale, Range YScale, boolean autoSort) {
        this(key, XScale, YScale, autoSort, true);
    }

    public XYScaledSeries(Comparable<?> key, Range XScale, Range YScale, boolean autoSort, boolean allowDuplicateXValues) {
        super(key, autoSort, allowDuplicateXValues);
        this.scaledXRange = XScale;
        this.scaledYRange = YScale;
    }

    public double getMinX() {
        return this.scaledXRange == null ? super.getMinX() : this.scaledXRange.getLowerBound();
    }

    public double getMinY() {
        return this.scaledYRange == null ? super.getMinY() : this.scaledYRange.getLowerBound();
    }

    public double getMaxX() {
        return this.scaledXRange == null ? super.getMaxX() : this.scaledXRange.getUpperBound();
    }

    public double getMaxY() {
        return this.scaledYRange == null ? super.getMaxY() : this.scaledYRange.getUpperBound();
    }

    public Number getX(int index) {
        Number original = super.getX(index);
        if (original == null || this.scaledXRange == null) {
            return original;
        }
        double originalPercentage = (original.doubleValue() - super.getMinX()) / (super.getMaxX() - super.getMinX());
        return this.scaledXRange.getLowerBound() + originalPercentage * this.scaledXRange.getLength();
    }

    public Number getY(int index) {
        Number original = super.getY(index);
        if (original == null || this.scaledYRange == null) {
            return original;
        }
        double originalPercentage = (original.doubleValue() - super.getMinY()) / (super.getMaxY() - super.getMinY());
        return this.scaledYRange.getLowerBound() + originalPercentage * this.scaledYRange.getLength();
    }

    public double getUnscaledMinX() {
        return super.getMinX();
    }

    public double getUnscaledMinY() {
        return super.getMinY();
    }

    public double getUnscaledMaxX() {
        return super.getMaxX();
    }

    public double getUnscaledMaxY() {
        return super.getMaxY();
    }

    public Range getUnscaledRangeX() {
        return new Range(this.getUnscaledMinX(), this.getUnscaledMaxX());
    }

    public Range getUnscaledRangeY() {
        return new Range(this.getUnscaledMinY(), this.getUnscaledMaxY());
    }

    public Number getUnscaledX(int index) {
        return super.getX(index);
    }

    public Number getUnscaledY(int index) {
        return super.getY(index);
    }
}

