/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.analysis.signal.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.trace4cps.analysis.signal.impl.LinearSignalFragment;
import org.eclipse.trace4cps.core.IInterval;
import org.eclipse.trace4cps.core.IPsop;
import org.eclipse.trace4cps.core.impl.Interval;
import org.eclipse.trace4cps.core.impl.Psop;
import org.eclipse.trace4cps.core.impl.PsopFragment;

public final class EventSignalUtil {
    private EventSignalUtil() {
    }

    public static void sortStartAsc(List<LinearSignalFragment> events) {
        Collections.sort(events, new Comparator<LinearSignalFragment>(){

            @Override
            public int compare(LinearSignalFragment o1, LinearSignalFragment o2) {
                return Double.compare(o1.getT0(), o2.getT0());
            }
        });
    }

    public static Psop toIPsop(List<LinearSignalFragment> events) {
        Psop r = new Psop();
        for (LinearSignalFragment e : events) {
            Interval i = new Interval(e.getT0(), false, e.getT1(), true);
            r.add(new PsopFragment(e.getY0(), e.getCoefficient(), 0.0, i));
        }
        return r;
    }

    public static List<LinearSignalFragment> computeInstantaneous(List<LinearSignalFragment> eventSignal, double scale, IInterval dom) {
        List<Event> events = EventSignalUtil.createEventList(eventSignal);
        List<LinearSignalFragment> r = EventSignalUtil.createConstantSignal(scale, events);
        return EventSignalUtil.setDomain(r, dom, true);
    }

    public static final IPsop convoluteScaleAndProject(List<LinearSignalFragment> events, double scale, double w, Interval dom) {
        List<LinearSignalFragment> cl = EventSignalUtil.convolution(events, w);
        cl = EventSignalUtil.scale(cl, scale);
        return EventSignalUtil.toIPsop(EventSignalUtil.setDomain(cl, dom, true));
    }

    public static List<LinearSignalFragment> divide(List<LinearSignalFragment> dividend, List<LinearSignalFragment> divisor, double undefinedValue) {
        List<Event> l1 = EventSignalUtil.createEventList(dividend);
        List<Event> l2 = EventSignalUtil.createEventList(divisor);
        if (l1.isEmpty() || l2.isEmpty()) {
            throw new IllegalArgumentException("cannot divide with empty input");
        }
        Interval dom = new Interval(Math.max(l1.get(0).t, l2.get(0).t), false, Math.min(l1.get(l1.size() - 1).t, l2.get(l2.size() - 1).t), true);
        List<LinearSignalFragment> c1 = EventSignalUtil.createConstantSignal(1.0, l1);
        List<LinearSignalFragment> c2 = EventSignalUtil.createConstantSignal(1.0, l2);
        c1 = EventSignalUtil.setDomain(c1, dom, true);
        c2 = EventSignalUtil.setDomain(c2, dom, true);
        EventSignalUtil.splitAtEvents(c1, l2);
        EventSignalUtil.splitAtEvents(c2, l1);
        ArrayList<LinearSignalFragment> result = new ArrayList<LinearSignalFragment>();
        int i = 0;
        while (i < c1.size()) {
            LinearSignalFragment f1 = c1.get(i);
            LinearSignalFragment f2 = c2.get(i);
            double v1 = f1.getY0();
            double v2 = f2.getY0();
            double v = undefinedValue;
            if (v2 != 0.0) {
                v = v1 / v2;
            }
            result.add(new LinearSignalFragment(f1.getT0(), f1.getT1(), v, v));
            ++i;
        }
        return result;
    }

    private static void splitAtEvents(List<LinearSignalFragment> cl, List<Event> el) {
        int i = 0;
        for (Event e : el) {
            while (cl.get(i).getT1() < e.t) {
                ++i;
            }
            if (!(cl.get(i).getT0() < e.t) || !(e.t < cl.get(i).getT1())) continue;
            EventSignalUtil.doSplit(cl, i, e.t);
        }
    }

    private static List<LinearSignalFragment> createConstantSignal(double scale, List<Event> events) {
        ArrayList<LinearSignalFragment> r = new ArrayList<LinearSignalFragment>();
        Event prev = null;
        double value = 0.0;
        for (Event e : events) {
            if (prev != null) {
                r.add(new LinearSignalFragment(prev.t, e.t, value += prev.delta * scale, value));
            }
            prev = e;
        }
        return r;
    }

    private static List<Event> createEventList(List<LinearSignalFragment> eventSignal) {
        List<Event> events = new ArrayList<Event>();
        for (LinearSignalFragment s : eventSignal) {
            if (s.isInstantaneousEvent()) {
                throw new UnsupportedOperationException("instantaneous events not suppprted");
            }
            events.add(new Event(s.getT0(), s.getY0()));
            events.add(new Event(s.getT1(), -s.getY0()));
        }
        Collections.sort(events);
        events = EventSignalUtil.merge(events);
        return events;
    }

    public static List<LinearSignalFragment> scale(List<LinearSignalFragment> fl, double c) {
        ArrayList<LinearSignalFragment> r = new ArrayList<LinearSignalFragment>();
        for (LinearSignalFragment f : fl) {
            r.add(new LinearSignalFragment(f.getT0(), f.getT1(), f.getY0() * c, f.getY1() * c));
        }
        return r;
    }

    private static List<LinearSignalFragment> convolution(List<LinearSignalFragment> fl, double w) {
        ArrayList<LinearSignalFragment> result = new ArrayList<LinearSignalFragment>();
        ArrayList<LinearSignalFragment> conv = new ArrayList<LinearSignalFragment>();
        for (LinearSignalFragment f : fl) {
            conv.clear();
            EventSignalUtil.convolutionWithBlock(conv, f, w);
            EventSignalUtil.addTo(result, conv);
        }
        return result;
    }

    private static void addTo(List<LinearSignalFragment> result, List<LinearSignalFragment> l) {
        if (result.isEmpty()) {
            result.addAll(l);
            EventSignalUtil.checkAndPad(result, true);
            return;
        }
        if (l == null || l.isEmpty()) {
            return;
        }
        EventSignalUtil.padToContain(result, l.get(0).getT0(), l.get(l.size() - 1).getT1());
        for (LinearSignalFragment f : l) {
            double t0cl = result.get(0).getT0();
            double t1cl = result.get(result.size() - 1).getT1();
            if (f.getT1() <= t0cl) {
                result.add(0, f);
                continue;
            }
            if (f.getT0() >= t1cl) {
                result.add(f);
                continue;
            }
            EventSignalUtil.split(result, f.getT0());
            EventSignalUtil.split(result, f.getT1());
            int startIndex = EventSignalUtil.findIndex(result, f.getT0());
            int endIndex = EventSignalUtil.findIndex(result, f.getT1());
            if (startIndex == -1) {
                startIndex = 0;
            }
            if (endIndex == -1) {
                endIndex = result.size();
            }
            double offset = f.getY0();
            if (f.getT0() < t0cl) {
                offset += f.getCoefficient() * (t0cl - f.getT0());
            }
            int i = startIndex;
            while (i < endIndex) {
                LinearSignalFragment cf = result.remove(i);
                double y0 = cf.getY0() + offset;
                double y1 = cf.getY1() + offset + f.getCoefficient() * cf.getWidth();
                result.add(i, new LinearSignalFragment(cf.getT0(), cf.getT1(), y0, y1));
                offset += f.getCoefficient() * cf.getWidth();
                ++i;
            }
        }
        EventSignalUtil.checkAndPad(result, true);
    }

    private static void checkAndPad(List<LinearSignalFragment> fl, boolean pad) {
        int i = 0;
        int ub = fl.size() - 1;
        while (i < ub) {
            LinearSignalFragment f1 = fl.get(i);
            LinearSignalFragment f2 = fl.get(i + 1);
            if (f1.getT1() > f2.getT0()) {
                throw new IllegalStateException("not strictly sorted");
            }
            if (pad && f1.getT1() < f2.getT0()) {
                fl.add(i + 1, new LinearSignalFragment(f1.getT1(), f2.getT0(), 0.0, 0.0));
                ++i;
                ++ub;
            }
            ++i;
        }
    }

    private static void convolutionWithBlock(List<LinearSignalFragment> r, LinearSignalFragment f, double w) {
        if (!f.isConstant()) {
            throw new IllegalStateException("convolution only supported for constant signal fragments");
        }
        double b0 = 0.0;
        double b1 = 0.0 + w;
        double fVal = f.getY0();
        if (f.isInstantaneousEvent()) {
            double y = fVal / w;
            r.add(new LinearSignalFragment(f.getT0() + 0.0, f.getT0() + b1, y, y));
        } else {
            double y = Math.min(w, f.getWidth()) * fVal / w;
            double[] ts = new double[]{f.getT0() + 0.0, f.getT0() + b1, f.getT1() + 0.0, f.getT1() + b1};
            Arrays.sort(ts);
            r.add(new LinearSignalFragment(ts[0], ts[1], 0.0, y));
            if (ts[1] < ts[2]) {
                r.add(new LinearSignalFragment(ts[1], ts[2], y, y));
            }
            r.add(new LinearSignalFragment(ts[2], ts[3], y, 0.0));
        }
    }

    private static void padToContain(List<LinearSignalFragment> cl, double t0, double t1) {
        if (t0 < cl.get(0).getT0()) {
            cl.add(new LinearSignalFragment(t0, cl.get(0).getT0(), 0.0, 0.0));
        }
        if (t1 > cl.get(cl.size() - 1).getT1()) {
            cl.add(new LinearSignalFragment(cl.get(cl.size() - 1).getT1(), t1, 0.0, 0.0));
        }
    }

    private static int findIndex(List<LinearSignalFragment> cl, double t) {
        int i = 0;
        while (i < cl.size()) {
            if (cl.get(i).getT0() == t) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static List<Event> merge(List<Event> events) {
        int i = 0;
        ArrayList<Event> r = new ArrayList<Event>();
        while (i < events.size()) {
            Event ei = events.get(i);
            int j = i + 1;
            double extraDelta = 0.0;
            while (j < events.size() && events.get(j).t == ei.t) {
                extraDelta += events.get(j).delta;
                ++j;
            }
            i = j - 1;
            r.add(new Event(ei.t, ei.delta + extraDelta));
            ++i;
        }
        return r;
    }

    private static List<LinearSignalFragment> setDomain(List<LinearSignalFragment> ls, IInterval dom, boolean padWithZeros) {
        double val;
        if (ls.isEmpty()) {
            throw new IllegalArgumentException("cannot set the domain of an empty signal");
        }
        if (EventSignalUtil.getTmin(ls) > dom.lb().doubleValue()) {
            val = padWithZeros ? 0.0 : EventSignalUtil.getYmin(ls);
            ls.add(0, new LinearSignalFragment(dom.lb().doubleValue(), EventSignalUtil.getTmin(ls), val, val));
        }
        if (dom.ub().doubleValue() > EventSignalUtil.getTmax(ls)) {
            val = padWithZeros ? 0.0 : EventSignalUtil.getYmax(ls);
            ls.add(new LinearSignalFragment(EventSignalUtil.getTmax(ls), dom.ub().doubleValue(), val, val));
        }
        return EventSignalUtil.projectTo(ls, dom.lb().doubleValue(), dom.ub().doubleValue());
    }

    private static List<LinearSignalFragment> projectTo(List<LinearSignalFragment> ls, double tmin, double tmax) {
        int i1 = EventSignalUtil.split(ls, tmin);
        int i2 = EventSignalUtil.split(ls, tmax);
        if (i2 == -1) {
            i2 = ls.size() - 1;
        }
        return ls.subList(i1 + 1, i2 + 1);
    }

    private static int split(List<LinearSignalFragment> ls, double t) {
        int i = 0;
        while (i < ls.size()) {
            if (ls.get(i).getT0() < t && t < ls.get(i).getT1()) {
                EventSignalUtil.doSplit(ls, i, t);
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static void doSplit(List<LinearSignalFragment> ls, int i, double t) {
        LinearSignalFragment f = ls.remove(i);
        double valueAtt = f.getY0() + (t - f.getT0()) * f.getCoefficient();
        LinearSignalFragment f1 = new LinearSignalFragment(f.getT0(), t, f.getY0(), valueAtt);
        LinearSignalFragment f2 = new LinearSignalFragment(t, f.getT1(), valueAtt, f.getY1());
        ls.add(i, f1);
        ls.add(i + 1, f2);
    }

    private static double getTmin(List<LinearSignalFragment> ls) {
        return ls.get(0).getT0();
    }

    private static double getYmin(List<LinearSignalFragment> ls) {
        return ls.get(0).getY0();
    }

    private static double getTmax(List<LinearSignalFragment> ls) {
        return ls.get(ls.size() - 1).getT1();
    }

    private static double getYmax(List<LinearSignalFragment> ls) {
        return ls.get(ls.size() - 1).getY1();
    }

    private static final class Event
    implements Comparable<Event> {
        private final double t;
        private final double delta;

        public Event(double t, double delta) {
            this.t = t;
            this.delta = delta;
        }

        @Override
        public int compareTo(Event o) {
            return Double.compare(this.t, o.t);
        }

        public String toString() {
            return "Event [t=" + this.t + ", delta=" + this.delta + "]";
        }
    }
}

