/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.vis.jfree;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.trace4cps.core.IAttributeAware;
import org.eclipse.trace4cps.core.IClaim;
import org.eclipse.trace4cps.core.IDependency;
import org.eclipse.trace4cps.core.IEvent;
import org.eclipse.trace4cps.core.IPsopFragment;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.core.impl.TraceHelper;
import org.eclipse.trace4cps.vis.jfree.ClaimDataItem;
import org.eclipse.trace4cps.vis.jfree.DependencyDataItem;
import org.eclipse.trace4cps.vis.jfree.EventDataItem;
import org.eclipse.trace4cps.vis.jfree.SignalDataItem;
import org.eclipse.trace4cps.vis.jfree.TraceViewConfiguration;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class DefaultToolTipGenerator
implements XYToolTipGenerator {
    private final Supplier<TraceViewConfiguration> viewConfigSupplier;

    public DefaultToolTipGenerator(Supplier<TraceViewConfiguration> viewConfigSupplier) {
        this.viewConfigSupplier = viewConfigSupplier;
    }

    private Collection<String> getDescribingAttributes(TracePart part) {
        return this.viewConfigSupplier.get().getDescribingAttributes(part);
    }

    public String generateToolTip(XYDataset ds, int series, int item) {
        EventDataItem dataItem = EventDataItem.getFrom(ds, series, item);
        if (dataItem != null) {
            IEvent e = dataItem.getEvent();
            return TraceHelper.getValues((IAttributeAware)e, this.getDescribingAttributes(TracePart.EVENT), (boolean)false);
        }
        DependencyDataItem ddataItem = DependencyDataItem.getFrom(ds, series, item);
        if (ddataItem != null) {
            IDependency d = ddataItem.getDependency();
            return TraceHelper.getValues((IAttributeAware)d, this.getDescribingAttributes(TracePart.DEPENDENCY), (boolean)false);
        }
        ClaimDataItem cdataItem = ClaimDataItem.getFrom(ds, series, item);
        if (cdataItem != null) {
            IClaim c = cdataItem.getClaim();
            return TraceHelper.getValues((IAttributeAware)c, this.getDescribingAttributes(TracePart.CLAIM), (boolean)false);
        }
        SignalDataItem sdi = SignalDataItem.getFrom(ds, series, item);
        if (sdi != null) {
            IPsopFragment f = sdi.getFragment();
            return "Signal fragment: " + f.dom() + " : " + f.getC() + "," + f.getB() + "," + f.getA() + " (" + f.getShape() + ")";
        }
        return ds + " " + series + " " + item;
    }
}

