/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.dialog;

import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.trace4cps.ui.dialog.ParameterDialog;

public final class DistanceDialog
extends ParameterDialog {
    private static final String TITLE = "Distance analysis";
    private final Map<String, Integer> traceKeyToIndex;

    public DistanceDialog(Shell parentShell, Map<String, Integer> traceKeyToIndex) {
        super(parentShell, ParameterDialog.class.getName());
        this.traceKeyToIndex = traceKeyToIndex;
    }

    public int getReferenceIndex() {
        String selected = this.getSelection().get(0);
        Integer idx = this.traceKeyToIndex.get(selected);
        if (idx == null) {
            return -1;
        }
        return idx;
    }

    @Override
    protected String getTitle() {
        return TITLE;
    }

    @Override
    protected void draw(Composite composite) {
        this.addSelectionInput(composite, "Select the reference trace", ParameterDialog.SelectionType.EXACTLY_ONE, this.traceKeyToIndex.keySet());
        DistanceDialog.applyDialogFont((Control)composite);
    }
}

