/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * generated by Xtext 2.22.0
 */
package org.eclipse.trace4cps.tl.etl.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.trace4cps.tl.etl.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class EtlFactoryImpl extends EFactoryImpl implements EtlFactory
{
  /**
   * Creates the default factory implementation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static EtlFactory init()
  {
    try
    {
      EtlFactory theEtlFactory = (EtlFactory)EPackage.Registry.INSTANCE.getEFactory(EtlPackage.eNS_URI);
      if (theEtlFactory != null)
      {
        return theEtlFactory;
      }
    }
    catch (Exception exception)
    {
      EcorePlugin.INSTANCE.log(exception);
    }
    return new EtlFactoryImpl();
  }

  /**
   * Creates an instance of the factory.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public EtlFactoryImpl()
  {
    super();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EObject create(EClass eClass)
  {
    switch (eClass.getClassifierID())
    {
      case EtlPackage.ETL_MODEL: return createEtlModel();
      case EtlPackage.TOP_LEVEL_MODEL_ELEMENT: return createTopLevelModelElement();
      case EtlPackage.SIGNAL: return createSignal();
      case EtlPackage.CONV_SPEC: return createConvSpec();
      case EtlPackage.FORMULA: return createFormula();
      case EtlPackage.STL_AP: return createStlAp();
      case EtlPackage.MTL_AP: return createMtlAp();
      case EtlPackage.ATTRIBUTE_FILTER: return createAttributeFilter();
      case EtlPackage.KEY_VAL: return createKeyVal();
      case EtlPackage.ID_STRING: return createIdString();
      case EtlPackage.INTERVAL: return createInterval();
      case EtlPackage.INTERVAL_SS: return createIntervalSS();
      case EtlPackage.INTERVAL_SN: return createIntervalSN();
      case EtlPackage.INTERVAL_NS: return createIntervalNS();
      case EtlPackage.INTERVAL_NN: return createIntervalNN();
      case EtlPackage.SIGNAL_DEF: return createSignalDef();
      case EtlPackage.DEF: return createDef();
      case EtlPackage.CHECK: return createCheck();
      case EtlPackage.TRACE_SIGNAL: return createTraceSignal();
      case EtlPackage.THROUGHPUT_SIGNAL: return createThroughputSignal();
      case EtlPackage.LATENCY_SIGNAL: return createLatencySignal();
      case EtlPackage.WIP_SIGNAL: return createWipSignal();
      case EtlPackage.RESOURCE_AMOUNT_SIGNAL: return createResourceAmountSignal();
      case EtlPackage.RESOURCE_CLIENT_SIGNAL: return createResourceClientSignal();
      case EtlPackage.REFERENCE_FORMULA: return createReferenceFormula();
      case EtlPackage.AP_FORMULA: return createApFormula();
      case EtlPackage.NOT_FORMULA: return createNotFormula();
      case EtlPackage.AND_OR_FORMULA: return createAndOrFormula();
      case EtlPackage.IF_THEN_FORMULA: return createIfThenFormula();
      case EtlPackage.GLOBALLY_UNTIMED_FORMULA: return createGloballyUntimedFormula();
      case EtlPackage.GLOBALLY_FORMULA: return createGloballyFormula();
      case EtlPackage.FINALLY_UNTIMED_FORMULA: return createFinallyUntimedFormula();
      case EtlPackage.FINALLY_FORMULA: return createFinallyFormula();
      case EtlPackage.UNTIL_UNTIMED_FORMULA: return createUntilUntimedFormula();
      case EtlPackage.UNTIL_FORMULA: return createUntilFormula();
      case EtlPackage.STL_AP_DERIV: return createStlApDeriv();
      case EtlPackage.MTL_AP_START: return createMtlApStart();
      case EtlPackage.MTL_AP_END: return createMtlApEnd();
      default:
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Object createFromString(EDataType eDataType, String initialValue)
  {
    switch (eDataType.getClassifierID())
    {
      case EtlPackage.TIME_UNIT_ENUM:
        return createTimeUnitEnumFromString(eDataType, initialValue);
      case EtlPackage.AND_OR:
        return createAndOrFromString(eDataType, initialValue);
      case EtlPackage.COMP_OP:
        return createCompOpFromString(eDataType, initialValue);
      default:
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String convertToString(EDataType eDataType, Object instanceValue)
  {
    switch (eDataType.getClassifierID())
    {
      case EtlPackage.TIME_UNIT_ENUM:
        return convertTimeUnitEnumToString(eDataType, instanceValue);
      case EtlPackage.AND_OR:
        return convertAndOrToString(eDataType, instanceValue);
      case EtlPackage.COMP_OP:
        return convertCompOpToString(eDataType, instanceValue);
      default:
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EtlModel createEtlModel()
  {
    EtlModelImpl etlModel = new EtlModelImpl();
    return etlModel;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public TopLevelModelElement createTopLevelModelElement()
  {
    TopLevelModelElementImpl topLevelModelElement = new TopLevelModelElementImpl();
    return topLevelModelElement;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Signal createSignal()
  {
    SignalImpl signal = new SignalImpl();
    return signal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public ConvSpec createConvSpec()
  {
    ConvSpecImpl convSpec = new ConvSpecImpl();
    return convSpec;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Formula createFormula()
  {
    FormulaImpl formula = new FormulaImpl();
    return formula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public StlAp createStlAp()
  {
    StlApImpl stlAp = new StlApImpl();
    return stlAp;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public MtlAp createMtlAp()
  {
    MtlApImpl mtlAp = new MtlApImpl();
    return mtlAp;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public AttributeFilter createAttributeFilter()
  {
    AttributeFilterImpl attributeFilter = new AttributeFilterImpl();
    return attributeFilter;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public KeyVal createKeyVal()
  {
    KeyValImpl keyVal = new KeyValImpl();
    return keyVal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public IdString createIdString()
  {
    IdStringImpl idString = new IdStringImpl();
    return idString;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Interval createInterval()
  {
    IntervalImpl interval = new IntervalImpl();
    return interval;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public IntervalSS createIntervalSS()
  {
    IntervalSSImpl intervalSS = new IntervalSSImpl();
    return intervalSS;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public IntervalSN createIntervalSN()
  {
    IntervalSNImpl intervalSN = new IntervalSNImpl();
    return intervalSN;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public IntervalNS createIntervalNS()
  {
    IntervalNSImpl intervalNS = new IntervalNSImpl();
    return intervalNS;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public IntervalNN createIntervalNN()
  {
    IntervalNNImpl intervalNN = new IntervalNNImpl();
    return intervalNN;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public SignalDef createSignalDef()
  {
    SignalDefImpl signalDef = new SignalDefImpl();
    return signalDef;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Def createDef()
  {
    DefImpl def = new DefImpl();
    return def;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public Check createCheck()
  {
    CheckImpl check = new CheckImpl();
    return check;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public TraceSignal createTraceSignal()
  {
    TraceSignalImpl traceSignal = new TraceSignalImpl();
    return traceSignal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public ThroughputSignal createThroughputSignal()
  {
    ThroughputSignalImpl throughputSignal = new ThroughputSignalImpl();
    return throughputSignal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public LatencySignal createLatencySignal()
  {
    LatencySignalImpl latencySignal = new LatencySignalImpl();
    return latencySignal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public WipSignal createWipSignal()
  {
    WipSignalImpl wipSignal = new WipSignalImpl();
    return wipSignal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public ResourceAmountSignal createResourceAmountSignal()
  {
    ResourceAmountSignalImpl resourceAmountSignal = new ResourceAmountSignalImpl();
    return resourceAmountSignal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public ResourceClientSignal createResourceClientSignal()
  {
    ResourceClientSignalImpl resourceClientSignal = new ResourceClientSignalImpl();
    return resourceClientSignal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public ReferenceFormula createReferenceFormula()
  {
    ReferenceFormulaImpl referenceFormula = new ReferenceFormulaImpl();
    return referenceFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public ApFormula createApFormula()
  {
    ApFormulaImpl apFormula = new ApFormulaImpl();
    return apFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public NotFormula createNotFormula()
  {
    NotFormulaImpl notFormula = new NotFormulaImpl();
    return notFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public AndOrFormula createAndOrFormula()
  {
    AndOrFormulaImpl andOrFormula = new AndOrFormulaImpl();
    return andOrFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public IfThenFormula createIfThenFormula()
  {
    IfThenFormulaImpl ifThenFormula = new IfThenFormulaImpl();
    return ifThenFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public GloballyUntimedFormula createGloballyUntimedFormula()
  {
    GloballyUntimedFormulaImpl globallyUntimedFormula = new GloballyUntimedFormulaImpl();
    return globallyUntimedFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public GloballyFormula createGloballyFormula()
  {
    GloballyFormulaImpl globallyFormula = new GloballyFormulaImpl();
    return globallyFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public FinallyUntimedFormula createFinallyUntimedFormula()
  {
    FinallyUntimedFormulaImpl finallyUntimedFormula = new FinallyUntimedFormulaImpl();
    return finallyUntimedFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public FinallyFormula createFinallyFormula()
  {
    FinallyFormulaImpl finallyFormula = new FinallyFormulaImpl();
    return finallyFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public UntilUntimedFormula createUntilUntimedFormula()
  {
    UntilUntimedFormulaImpl untilUntimedFormula = new UntilUntimedFormulaImpl();
    return untilUntimedFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public UntilFormula createUntilFormula()
  {
    UntilFormulaImpl untilFormula = new UntilFormulaImpl();
    return untilFormula;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public StlApDeriv createStlApDeriv()
  {
    StlApDerivImpl stlApDeriv = new StlApDerivImpl();
    return stlApDeriv;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public MtlApStart createMtlApStart()
  {
    MtlApStartImpl mtlApStart = new MtlApStartImpl();
    return mtlApStart;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public MtlApEnd createMtlApEnd()
  {
    MtlApEndImpl mtlApEnd = new MtlApEndImpl();
    return mtlApEnd;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public TimeUnitEnum createTimeUnitEnumFromString(EDataType eDataType, String initialValue)
  {
    TimeUnitEnum result = TimeUnitEnum.get(initialValue);
    if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
    return result;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String convertTimeUnitEnumToString(EDataType eDataType, Object instanceValue)
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public AndOr createAndOrFromString(EDataType eDataType, String initialValue)
  {
    AndOr result = AndOr.get(initialValue);
    if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
    return result;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String convertAndOrToString(EDataType eDataType, Object instanceValue)
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public CompOp createCompOpFromString(EDataType eDataType, String initialValue)
  {
    CompOp result = CompOp.get(initialValue);
    if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
    return result;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public String convertCompOpToString(EDataType eDataType, Object instanceValue)
  {
    return instanceValue == null ? null : instanceValue.toString();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public EtlPackage getEtlPackage()
  {
    return (EtlPackage)getEPackage();
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @deprecated
   * @generated
   */
  @Deprecated
  public static EtlPackage getPackage()
  {
    return EtlPackage.eINSTANCE;
  }

} //EtlFactoryImpl
