/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.AxisUtils;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.Section;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.SectionTick;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.StandardTickUnitSource;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.TickLabelEntity;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.text.TextUtils;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.chart.util.Args;
import org.jfree.data.Range;

public class SectionAxis
extends ValueAxis {
    private static final long serialVersionUID = 6418801819447160805L;
    public static final Paint DEFAULT_GRID_BAND_PAINT = new Color(232, 234, 232, 128);
    public static final Paint DEFAULT_GRID_BAND_ALTERNATE_PAINT = new Color(0, 0, 0, 0);
    public static final double DEFAULT_LOWER_MARGIN = 0.0;
    public static final double DEFAULT_UPPER_MARGIN = 0.0;
    public static final double DEFAULT_SECTION_LENGTH = 1.0;
    public static final double DEFAULT_SECTION_GAP = 0.0;
    public static final int NO_TICK_LABEL_MAX_LENGTH = -1;
    private final LinkedList<Section> sections = new LinkedList();
    private double defaultSectionGap;
    private int tickLabelMaxLength;
    private TooltipMode tooltipMode;
    private boolean gridBandsVisible;
    private transient Paint defaultGridBandPaint;
    private transient Paint defaultGridBandAlternatePaint;

    public SectionAxis() {
        this(null);
    }

    public SectionAxis(String label) {
        super(label, (TickUnitSource)new StandardTickUnitSource());
        this.setLowerMargin(0.0);
        this.setUpperMargin(0.0);
        this.gridBandsVisible = true;
        this.defaultGridBandPaint = DEFAULT_GRID_BAND_PAINT;
        this.defaultGridBandAlternatePaint = DEFAULT_GRID_BAND_ALTERNATE_PAINT;
        this.defaultSectionGap = 0.0;
        this.tickLabelMaxLength = -1;
        this.tooltipMode = TooltipMode.MAX_EXCEEDED;
    }

    public int getTickLabelMaxLength() {
        return this.tickLabelMaxLength;
    }

    public void setTickLabelMaxLength(int tickLabelMaxLength) {
        this.tickLabelMaxLength = tickLabelMaxLength;
        this.fireChangeEvent();
    }

    protected String createTickLabel(String sectionLabel) {
        if (sectionLabel == null || this.tickLabelMaxLength < 0 || sectionLabel.length() <= this.tickLabelMaxLength) {
            return sectionLabel;
        }
        return String.valueOf(sectionLabel.substring(0, this.tickLabelMaxLength)) + "...";
    }

    public TooltipMode getTooltipMode() {
        return this.tooltipMode;
    }

    public void setTooltipMode(TooltipMode tooltipMode) {
        Args.nullNotPermitted((Object)((Object)tooltipMode), (String)"TooltipMode");
        this.tooltipMode = tooltipMode;
    }

    public boolean isGridBandsVisible() {
        return this.gridBandsVisible;
    }

    public void setGridBandsVisible(boolean flag) {
        this.gridBandsVisible = flag;
        this.fireChangeEvent();
    }

    public Paint getDefaultGridBandPaint() {
        return this.defaultGridBandPaint;
    }

    public void setDefaultGridBandPaint(Paint paint) {
        Args.nullNotPermitted((Object)paint, (String)"paint");
        this.defaultGridBandPaint = paint;
        this.fireChangeEvent();
    }

    protected Paint getGridBandPaint(Section section) {
        Args.nullNotPermitted((Object)section, (String)"section");
        Paint paint = section.getGridBandPaint();
        if (paint == null) {
            paint = this.getDefaultGridBandPaint();
        }
        return paint;
    }

    public Paint getDefaultGridBandAlternatePaint() {
        return this.defaultGridBandAlternatePaint;
    }

    public void setDefaultGridBandAlternatePaint(Paint paint) {
        Args.nullNotPermitted((Object)paint, (String)"paint");
        this.defaultGridBandAlternatePaint = paint;
        this.fireChangeEvent();
    }

    protected Paint getGridBandAlternatePaint(Section section) {
        Args.nullNotPermitted((Object)section, (String)"section");
        Paint paint = section.getGridBandAlternatePaint();
        if (paint == null) {
            paint = this.getDefaultGridBandAlternatePaint();
        }
        return paint;
    }

    public double getDefaultSectionGap() {
        return this.defaultSectionGap;
    }

    public void setDefaultSectionGap(double sectionGap) {
        this.defaultSectionGap = sectionGap;
    }

    public List<Section> getSections() {
        return Collections.unmodifiableList(this.sections);
    }

    public Section nextSection(String label) {
        return this.nextSection(label, 1.0, this.defaultSectionGap);
    }

    public Section nextSection(String label, double length) {
        return this.nextSection(label, length, this.defaultSectionGap);
    }

    public Section nextSection(String label, double length, double gap) {
        Args.requireGreaterThanZero((double)length, (String)"length");
        Args.requireNonNegative((double)gap, (String)"gap");
        double sectionLowerBound = 0.0;
        if (!this.sections.isEmpty()) {
            sectionLowerBound = this.sections.getLast().getRange().getUpperBound() + gap;
        }
        Section section = new Section(this, new Range(sectionLowerBound, sectionLowerBound + length), label);
        this.sections.add(section);
        return section;
    }

    protected void sectionChanged(Section section) {
        this.fireChangeEvent();
    }

    public double valueToJava2D(double value, Rectangle2D area, RectangleEdge edge) {
        Range range = this.getRange();
        double axisMin = range.getLowerBound();
        double axisMax = range.getUpperBound();
        double min = 0.0;
        double max = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            max = area.getMinY();
            min = area.getMaxY();
        }
        if (this.isInverted()) {
            return max - (value - axisMin) / (axisMax - axisMin) * (max - min);
        }
        return min + (value - axisMin) / (axisMax - axisMin) * (max - min);
    }

    public double java2DToValue(double java2dValue, Rectangle2D area, RectangleEdge edge) {
        Range range = this.getRange();
        double axisMin = range.getLowerBound();
        double axisMax = range.getUpperBound();
        double min = 0.0;
        double max = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            min = area.getMaxY();
            max = area.getY();
        }
        if (this.isInverted()) {
            return axisMax - (java2dValue - min) / (max - min) * (axisMax - axisMin);
        }
        return axisMin + (java2dValue - min) / (max - min) * (axisMax - axisMin);
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public Range calculateAutoRange(boolean adhereToMax) {
        if (this.getPlot() instanceof ValueAxisPlot) {
            double upper;
            double lower;
            if (this.sections.isEmpty()) {
                Range r = this.getDefaultAutoRange();
                lower = r.getLowerBound();
                upper = r.getUpperBound();
            } else {
                lower = this.sections.getFirst().getRange().getLowerBound();
                upper = this.sections.getLast().getRange().getUpperBound();
            }
            double fixedAutoRange = this.getFixedAutoRange();
            if (adhereToMax && fixedAutoRange > 0.0) {
                Range aligned = this.getAutoRangeAlign().align(new Range(lower, upper), fixedAutoRange);
                lower = aligned.getLowerBound();
                upper = aligned.getUpperBound();
            } else {
                double range = upper - lower;
                double minRange = this.getAutoRangeMinimumSize();
                if (range < minRange) {
                    upper = (upper + lower + minRange) / 2.0;
                    lower = (upper + lower - minRange) / 2.0;
                }
                upper += upper * this.getUpperMargin();
                lower -= lower * this.getLowerMargin();
            }
            return new Range(lower, upper);
        }
        return null;
    }

    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        AxisState state = this.drawTickMarksAndLabels(g2, cursor, plotArea, dataArea, edge);
        if (this.gridBandsVisible) {
            this.drawGridBands(g2, plotArea, dataArea, edge);
        }
        state = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), g2, plotArea, dataArea, edge, state) : this.drawLabel(this.getLabel(), g2, plotArea, dataArea, edge, state);
        this.createAndAddEntity(cursor, state, dataArea, edge, plotState);
        this.createTickLabelEntities(g2, cursor, state, dataArea, edge, plotState);
        return state;
    }

    protected void createTickLabelEntities(Graphics2D g2, double cursor, AxisState state, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        if (plotState == null || plotState.getOwner() == null || plotState.getOwner().getEntityCollection() == null) {
            return;
        }
        EntityCollection entityCollection = plotState.getOwner().getEntityCollection();
        for (Object tick : state.getTicks()) {
            if (!(tick instanceof SectionTick) || ((SectionTick)((Object)tick)).getTooltipText() == null) continue;
            Shape tickTextBounds = this.calculateTickTextBounds((SectionTick)((Object)tick), g2, cursor, dataArea, edge);
            entityCollection.add((ChartEntity)new TickLabelEntity(tickTextBounds, ((SectionTick)((Object)tick)).getTooltipText(), null));
        }
    }

    protected void drawGridBands(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        Shape savedClip = g2.getClip();
        g2.clip(dataArea);
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            this.drawGridBandsHorizontal(g2, plotArea, dataArea, edge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            this.drawGridBandsVertical(g2, plotArea, dataArea, edge);
        }
        g2.setClip(savedClip);
    }

    protected void drawGridBandsHorizontal(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        throw new UnsupportedOperationException("This axis does not support horizontal plotting yet!");
    }

    protected void drawGridBandsVertical(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        boolean useAlternatePaint = true;
        double xx = dataArea.getX();
        double outlineStrokeWidth = 1.0;
        Stroke outlineStroke = this.getPlot().getOutlineStroke();
        if (outlineStroke != null && outlineStroke instanceof BasicStroke) {
            outlineStrokeWidth = ((BasicStroke)outlineStroke).getLineWidth();
        }
        for (Section section : this.sections) {
            if (!this.getRange().intersects(section.getRange())) continue;
            double yMin = this.valueToJava2D(section.getRange().getLowerBound(), dataArea, RectangleEdge.LEFT);
            double yMax = this.valueToJava2D(section.getRange().getUpperBound(), dataArea, RectangleEdge.LEFT);
            g2.setPaint(useAlternatePaint ? this.getGridBandAlternatePaint(section) : this.getGridBandPaint(section));
            useAlternatePaint = !useAlternatePaint;
            Rectangle2D.Double band = new Rectangle2D.Double(xx + outlineStrokeWidth, Math.min(yMin, yMax), dataArea.getMaxX() - xx - outlineStrokeWidth, Math.abs(yMax - yMin));
            g2.fill(band);
        }
    }

    public List<ValueTick> refreshTicks(Graphics2D g2, AxisState state, Rectangle2D dataArea, RectangleEdge edge) {
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            return this.refreshTicksHorizontal(g2, dataArea, edge);
        }
        if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            return this.refreshTicksVertical(g2, dataArea, edge);
        }
        return Collections.emptyList();
    }

    protected List<ValueTick> refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        throw new UnsupportedOperationException("This axis does not support horizontal plotting yet!");
    }

    protected List<ValueTick> refreshTicksVertical(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        double angle;
        TextAnchor rotationAnchor;
        TextAnchor textAnchor;
        Font tickLabelFont = this.getTickLabelFont();
        g2.setFont(tickLabelFont);
        double cursor = 0.0;
        if (this.isVerticalTickLabels()) {
            if (edge == RectangleEdge.LEFT) {
                textAnchor = TextAnchor.BOTTOM_CENTER;
                rotationAnchor = TextAnchor.BOTTOM_CENTER;
                angle = -1.5707963267948966;
            } else {
                textAnchor = TextAnchor.BOTTOM_CENTER;
                rotationAnchor = TextAnchor.BOTTOM_CENTER;
                angle = 1.5707963267948966;
            }
        } else if (edge == RectangleEdge.LEFT) {
            textAnchor = TextAnchor.CENTER_RIGHT;
            rotationAnchor = TextAnchor.CENTER_RIGHT;
            angle = 0.0;
        } else {
            textAnchor = TextAnchor.CENTER_LEFT;
            rotationAnchor = TextAnchor.CENTER_LEFT;
            angle = 0.0;
        }
        ArrayList<ValueTick> ticks = new ArrayList<ValueTick>();
        Area ticksTextArea = new Area();
        for (Section section : this.sections) {
            SectionTick sectionTick;
            Shape tickTextBounds;
            if (!this.getRange().contains(section.getRange().getCentralValue()) || this.intersect(ticksTextArea, tickTextBounds = this.calculateTickTextBounds(sectionTick = this.createSectionTick(TickType.MINOR, section.getRange().getCentralValue(), section.getLabel(), textAnchor, rotationAnchor, angle), g2, cursor, dataArea, edge))) continue;
            ticksTextArea.add(new Area(tickTextBounds));
            ticks.add(sectionTick);
        }
        for (Section section : this.sections) {
            ValueAxis gridBandAxis = section.getGridBandAxis();
            if (gridBandAxis == null) continue;
            Range sectionRange = section.getRange();
            double yLower = this.valueToJava2D(sectionRange.getLowerBound(), dataArea, edge);
            double yUpper = this.valueToJava2D(sectionRange.getUpperBound(), dataArea, edge);
            Rectangle2D.Double sectionDataArea = new Rectangle2D.Double(dataArea.getX(), yLower, dataArea.getWidth(), Math.abs(yUpper - yLower));
            Range gridBandRange = gridBandAxis.getRange();
            List sectionTicks = gridBandAxis.refreshTicks(g2, new AxisState(cursor), (Rectangle2D)sectionDataArea, edge);
            for (Object tick : sectionTicks) {
                ValueTick sectionTick = (ValueTick)tick;
                double scaledValue = AxisUtils.scaleValue(sectionTick.getValue(), gridBandRange, sectionRange);
                if (!this.getRange().contains(scaledValue)) continue;
                SectionTick scaledTick = this.createSectionTick(sectionTick.getTickType(), scaledValue, sectionTick.getText(), sectionTick.getTextAnchor(), sectionTick.getRotationAnchor(), sectionTick.getAngle());
                Shape tickTextBounds = this.calculateTickTextBounds(scaledTick, g2, cursor, dataArea, edge);
                if (this.intersect(ticksTextArea, tickTextBounds)) {
                    ticks.add(this.createSectionTick(sectionTick.getTickType(), scaledValue, null, sectionTick.getTextAnchor(), sectionTick.getRotationAnchor(), sectionTick.getAngle()));
                    continue;
                }
                ticksTextArea.add(new Area(tickTextBounds));
                ticks.add(scaledTick);
            }
        }
        return ticks;
    }

    private SectionTick createSectionTick(TickType tickType, double value, String label, TextAnchor textAnchor, TextAnchor rotationAnchor, double angle) {
        String tickLabel = this.createTickLabel(label);
        SectionTick sectionTick = new SectionTick(tickType, value, tickLabel, textAnchor, rotationAnchor, angle);
        switch (this.getTooltipMode()) {
            case MAX_EXCEEDED: {
                if (Objects.equals(label, tickLabel)) break;
            }
            case ALWAYS: {
                sectionTick.setTooltipText(label);
                break;
            }
        }
        return sectionTick;
    }

    private Shape calculateTickTextBounds(ValueTick tick, Graphics2D g2, double cursor, Rectangle2D dataArea, RectangleEdge edge) {
        String tickText = tick.getText();
        if (tickText == null || tickText.isEmpty()) {
            return new Area();
        }
        Font tickLabelFont = this.getTickLabelFont();
        g2.setFont(tickLabelFont);
        float[] anchorPoint = this.calculateAnchorPoint(tick, cursor, dataArea, edge);
        return TextUtils.calculateRotatedStringBounds((String)tickText, (Graphics2D)g2, (float)anchorPoint[0], (float)anchorPoint[1], (TextAnchor)tick.getTextAnchor(), (double)tick.getAngle(), (TextAnchor)tick.getRotationAnchor());
    }

    private boolean intersect(Shape a, Shape b) {
        Area areaA = new Area(a);
        Area areaB = new Area(b);
        areaA.intersect(areaB);
        return !areaA.isEmpty();
    }

    public static enum TooltipMode {
        NEVER,
        ALWAYS,
        MAX_EXCEEDED;

    }
}

