/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.chart.axis;

import java.awt.Paint;
import java.io.Serializable;
import org.eclipse.trace4cps.common.jfreechart.chart.axis.SectionAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.util.Args;
import org.jfree.data.Range;

public class Section
implements Comparable<Section>,
Serializable,
AxisChangeListener {
    private static final long serialVersionUID = 1028149280898345210L;
    private final SectionAxis axis;
    private final Range range;
    private String label;
    private ValueAxis gridBandAxis;
    private transient Paint gridBandPaint;
    private transient Paint gridBandAlternatePaint;

    public Section(SectionAxis axis, Range range, String label) {
        Args.nullNotPermitted((Object)((Object)axis), (String)"axis");
        Args.nullNotPermitted((Object)range, (String)"range");
        this.axis = axis;
        this.range = range;
        this.label = label;
    }

    public SectionAxis getAxis() {
        return this.axis;
    }

    public Range getRange() {
        return this.range;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.fireChangeEvent();
    }

    public Paint getGridBandPaint() {
        return this.gridBandPaint;
    }

    public void setGridBandPaint(Paint paint) {
        this.gridBandPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getGridBandAlternatePaint() {
        return this.gridBandAlternatePaint == null ? this.gridBandPaint : this.gridBandAlternatePaint;
    }

    public void setGridBandAlternatePaint(Paint paint) {
        this.gridBandAlternatePaint = paint;
        this.fireChangeEvent();
    }

    public void setGridBandNumberRange(Range gridBandRange, boolean isInteger) {
        NumberAxis axis = new NumberAxis(this.label);
        if (isInteger) {
            axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        }
        axis.setMinorTickCount(1);
        axis.setRange(gridBandRange, true, false);
        this.setGridBandAxis((ValueAxis)axis);
    }

    public ValueAxis getGridBandAxis() {
        return this.gridBandAxis;
    }

    public void setGridBandAxis(ValueAxis axis) {
        if (this.gridBandAxis != null) {
            this.gridBandAxis.removeChangeListener((AxisChangeListener)this);
        }
        this.gridBandAxis = axis;
        if (this.gridBandAxis != null) {
            this.gridBandAxis.addChangeListener((AxisChangeListener)this);
        }
        this.fireChangeEvent();
    }

    public void axisChanged(AxisChangeEvent event) {
        this.fireChangeEvent();
    }

    protected void fireChangeEvent() {
        this.axis.sectionChanged(this);
    }

    @Override
    public int compareTo(Section o) {
        return Double.compare(this.getRange().getCentralValue(), o.getRange().getCentralValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.axis == null ? 0 : this.axis.hashCode());
        result = 31 * result + (this.range == null ? 0 : this.range.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Section other = (Section)obj;
        if (this.axis == null ? other.axis != null : !this.axis.equals((Object)other.axis)) {
            return false;
        }
        return !(this.range == null ? other.range != null : !this.range.equals((Object)other.range));
    }

    public String toString() {
        return this.label;
    }
}

