/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPairSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CommentSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterSupport;
import org.eclipse.tm4e.registry.TMResource;
import org.eclipse.tm4e.ui.internal.utils.ContentTypeHelper;

public final class LanguageConfigurationDefinition
extends TMResource
implements ILanguageConfigurationDefinition {
    private final IContentType contentType;
    private boolean onEnterEnabled = true;
    private boolean bracketAutoClosingEnabled = true;
    private boolean matchingPairsEnabled = true;
    private @Nullable CharacterPairSupport characterPair;
    private @Nullable OnEnterSupport onEnter;
    private @Nullable CommentSupport comment;

    public LanguageConfigurationDefinition(IContentType contentType, String path) {
        super(path);
        this.contentType = contentType;
    }

    public LanguageConfigurationDefinition(IConfigurationElement ce) throws CoreException {
        super(ce);
        String contentTypeId = ce.getAttribute("contentTypeId");
        IContentType contentType = ContentTypeHelper.getContentTypeById((String)contentTypeId);
        if (contentType == null) {
            throw new CoreException((IStatus)new Status(4, LanguageConfiguration.class, "Cannot load language configuration with unknown content type ID " + contentTypeId));
        }
        this.contentType = contentType;
    }

    public LanguageConfigurationDefinition(IContentType contentType, String path, @Nullable String pluginId, boolean onEnterEnabled, boolean bracketAutoClosingEnabled, boolean matchingPairsEnabled) {
        super(path, pluginId);
        this.contentType = contentType;
        this.onEnterEnabled = onEnterEnabled;
        this.bracketAutoClosingEnabled = bracketAutoClosingEnabled;
        this.matchingPairsEnabled = matchingPairsEnabled;
    }

    @Nullable CharacterPairSupport getCharacterPair() {
        ILanguageConfiguration conf;
        if (this.characterPair == null && (conf = this.getLanguageConfiguration()) != null) {
            this.characterPair = new CharacterPairSupport(conf.getBrackets(), conf.getAutoClosingPairs(), conf.getSurroundingPairs());
        }
        return this.characterPair;
    }

    @Nullable OnEnterSupport getOnEnter() {
        ILanguageConfiguration conf;
        if (this.onEnter == null && (conf = this.getLanguageConfiguration()) != null && (conf.getBrackets() != null || conf.getOnEnterRules() != null)) {
            this.onEnter = new OnEnterSupport(conf.getBrackets(), conf.getOnEnterRules());
        }
        return this.onEnter;
    }

    @Nullable CommentSupport getCommentSupport() {
        ILanguageConfiguration conf;
        if (this.comment == null && (conf = this.getLanguageConfiguration()) != null) {
            this.comment = new CommentSupport(conf.getComments());
        }
        return this.comment;
    }

    @Override
    public IContentType getContentType() {
        return this.contentType;
    }

    @Override
    public @Nullable ILanguageConfiguration getLanguageConfiguration() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream in = this.getInputStream();){
                return LanguageConfiguration.load(new InputStreamReader(in, Charset.defaultCharset()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LanguageConfigurationPlugin plugin = LanguageConfigurationPlugin.getInstance();
            if (plugin != null) {
                plugin.getLog().log((IStatus)new Status(4, "org.eclipse.tm4e.languageconfiguration", e.getMessage(), (Throwable)e));
            }
            return null;
        }
    }

    @Override
    public boolean isOnEnterEnabled() {
        return this.onEnterEnabled;
    }

    @Override
    public void setOnEnterEnabled(boolean onEnterEnabled) {
        this.onEnterEnabled = onEnterEnabled;
    }

    @Override
    public boolean isBracketAutoClosingEnabled() {
        return this.bracketAutoClosingEnabled;
    }

    @Override
    public void setBracketAutoClosingEnabled(boolean bracketAutoClosingEnabled) {
        this.bracketAutoClosingEnabled = bracketAutoClosingEnabled;
    }

    @Override
    public boolean isMatchingPairsEnabled() {
        return this.matchingPairsEnabled;
    }

    @Override
    public void setMatchingPairsEnabled(boolean matchingPairsEnabled) {
        this.matchingPairsEnabled = matchingPairsEnabled;
    }
}

