/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.grammar.reader.GrammarReader;
import org.eclipse.tm4e.core.internal.registry.SyncRegistry;
import org.eclipse.tm4e.core.internal.theme.IRawTheme;
import org.eclipse.tm4e.core.internal.theme.Theme;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.registry.IRegistryOptions;

public class Registry {
    private final IRegistryOptions options;
    private final SyncRegistry syncRegistry;

    public Registry() {
        this(IRegistryOptions.DEFAULT_LOCATOR);
    }

    public Registry(IRegistryOptions options) {
        this.options = options;
        this.syncRegistry = new SyncRegistry(Theme.createFromRawTheme(options.getTheme(), options.getColorMap()));
    }

    public void setTheme(IRawTheme theme) {
        this.syncRegistry.setTheme(Theme.createFromRawTheme(theme, this.options.getColorMap()));
    }

    public Set<String> getColorMap() {
        return this.syncRegistry.getColorMap();
    }

    public @Nullable IGrammar loadGrammar(String initialScopeName) {
        ArrayList<String> remainingScopeNames = new ArrayList<String>();
        remainingScopeNames.add(initialScopeName);
        ArrayList<String> seenScopeNames = new ArrayList<String>();
        seenScopeNames.add(initialScopeName);
        while (!remainingScopeNames.isEmpty()) {
            String scopeName = (String)remainingScopeNames.remove(0);
            if (this.syncRegistry.lookup(scopeName) != null) continue;
            String filePath = this.options.getFilePath(scopeName);
            if (filePath == null) {
                if (!scopeName.equals(initialScopeName)) continue;
                throw new TMException("Unknown location for grammar <" + initialScopeName + ">");
            }
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream in = this.options.getInputStream(scopeName);){
                    if (in == null) {
                        throw new TMException("Unknown location for grammar <" + initialScopeName + ">");
                    }
                    IRawGrammar grammar = GrammarReader.readGrammarSync(filePath, in);
                    Collection<String> injections = this.options.getInjections(scopeName);
                    Collection<String> deps = this.syncRegistry.addGrammar(grammar, injections);
                    for (String dep : deps) {
                        if (seenScopeNames.contains(dep)) continue;
                        seenScopeNames.add(dep);
                        remainingScopeNames.add(dep);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                if (!scopeName.equals(initialScopeName)) continue;
                throw new TMException("Unknown location for grammar <" + initialScopeName + ">", e);
            }
        }
        return this.grammarForScopeName(initialScopeName);
    }

    public @Nullable IGrammar loadGrammarFromPathSync(File file) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream is = new FileInputStream(file);){
            return this.loadGrammarFromPathSync(file.getPath(), is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public @Nullable IGrammar loadGrammarFromPathSync(String path, InputStream in) throws Exception {
        return this.loadGrammarFromPathSync(path, in, 0, null);
    }

    public @Nullable IGrammar loadGrammarFromPathSync(String path, InputStream in, int initialLanguage, @Nullable Map<String, Integer> embeddedLanguages) throws Exception {
        IRawGrammar rawGrammar = GrammarReader.readGrammarSync(path, in);
        Collection<String> injections = this.options.getInjections(rawGrammar.getScopeName());
        this.syncRegistry.addGrammar(rawGrammar, injections);
        return this.grammarForScopeName(rawGrammar.getScopeName(), initialLanguage, embeddedLanguages);
    }

    public @Nullable IGrammar grammarForScopeName(String scopeName) {
        return this.grammarForScopeName(scopeName, 0, null);
    }

    public @Nullable IGrammar grammarForScopeName(String scopeName, int initialLanguage, @Nullable Map<String, Integer> embeddedLanguages) {
        return this.syncRegistry.grammarForScopeName(scopeName, initialLanguage, embeddedLanguages, null, null);
    }

    public IRegistryOptions getLocator() {
        return this.options;
    }
}

