/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.utils.MoreCollections;
import org.eclipse.tm4e.core.model.ITMModel;
import org.eclipse.tm4e.core.model.ModelTokensChangedEvent;
import org.eclipse.tm4e.core.model.Range;

public final class ModelTokensChangedEventBuilder {
    private final ITMModel model;
    private final List<Range> ranges = new ArrayList<Range>();

    public ModelTokensChangedEventBuilder(ITMModel model) {
        this.model = model;
    }

    public void registerChangedTokens(int lineNumber) {
        Range previousRange = MoreCollections.findLastElement(this.ranges);
        if (previousRange != null && previousRange.toLineNumber == lineNumber - 1) {
            ++previousRange.toLineNumber;
        } else {
            this.ranges.add(new Range(lineNumber));
        }
    }

    public @Nullable ModelTokensChangedEvent build() {
        if (this.ranges.isEmpty()) {
            return null;
        }
        return new ModelTokensChangedEvent(this.ranges, this.model);
    }
}

