/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;
import org.eclipse.tm4e.core.internal.utils.StringUtils;
import org.jcodings.Encoding;
import org.jcodings.specific.NonStrictUTF8Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.SyntaxException;

public final class OnigRegExp {
    private static final System.Logger LOGGER = System.getLogger(OnigRegExp.class.getName());
    private static final WarnCallback LOGGER_WARN_CALLBACK = message -> LOGGER.log(System.Logger.Level.WARNING, message);
    private @Nullable OnigString lastSearchString;
    private int lastSearchPosition = -1;
    private @Nullable OnigResult lastSearchResult;
    private final String pattern;
    private final Regex regex;
    private final boolean hasGAnchor;

    public OnigRegExp(String pattern) {
        this(pattern, false);
    }

    public OnigRegExp(String pattern, boolean ignoreCase) {
        Regex regex;
        this.hasGAnchor = pattern.contains("\\G");
        try {
            regex = this.parsePattern(pattern, ignoreCase);
        }
        catch (SyntaxException ex) {
            try {
                regex = this.parsePattern(this.rewritePatternIfRequired(pattern), ignoreCase);
            }
            catch (SyntaxException unused) {
                throw new TMException("Parsing regex pattern \"" + pattern + "\" failed with " + String.valueOf((Object)ex), ex);
            }
        }
        this.pattern = pattern;
        this.regex = regex;
    }

    private Regex parsePattern(String pattern, boolean ignoreCase) throws SyntaxException {
        int options = 256;
        if (ignoreCase) {
            options |= 1;
        }
        byte[] patternBytes = pattern.getBytes(StandardCharsets.UTF_8);
        return new Regex(patternBytes, 0, patternBytes.length, options, (Encoding)NonStrictUTF8Encoding.INSTANCE, Syntax.RUBY, LOGGER.isLoggable(System.Logger.Level.WARNING) ? LOGGER_WARN_CALLBACK : WarnCallback.NONE);
    }

    private String rewritePatternIfRequired(String pattern) {
        int close;
        if (pattern.isEmpty()) {
            return pattern;
        }
        if (pattern.startsWith("(?<=") && (close = this.findBalancedGroupEnd(pattern, 0)) > 0) {
            String body = pattern.substring("(?<=".length(), close);
            if (this.isFixedLength(body)) {
                return pattern;
            }
            return "(?:" + body + ")" + pattern.substring(close + 1);
        }
        String negLB = "(?<!\\.\\s*)";
        if (pattern.startsWith("(?<!\\.\\s*)")) {
            return "(?<!\\.)\\s*" + pattern.substring("(?<!\\.\\s*)".length());
        }
        return pattern;
    }

    private int findBalancedGroupEnd(String str, int start) {
        int depth = 0;
        boolean escaped = false;
        int idx = start;
        while (idx < str.length()) {
            char c = str.charAt(idx);
            if (escaped) {
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else if (c == '(') {
                ++depth;
            } else if (c == ')' && --depth == 0) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    private boolean isFixedLength(String body) {
        boolean escaped = false;
        int idx = 0;
        while (idx < body.length()) {
            char ch = body.charAt(idx);
            if (escaped) {
                escaped = false;
            } else if (ch == '\\') {
                escaped = true;
            } else {
                if (ch == '*' || ch == '+' || ch == '?' || ch == '|') {
                    return false;
                }
                if (ch == '{') {
                    int close;
                    int m;
                    int j = idx + 1;
                    while (j < body.length() && Character.isDigit(body.charAt(j))) {
                        ++j;
                    }
                    if (j == idx + 1) {
                        return false;
                    }
                    try {
                        m = Integer.parseInt(body.substring(idx + 1, j));
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                    if (j < body.length() && body.charAt(j) == ',') {
                        int k = ++j;
                        while (k < body.length() && Character.isDigit(body.charAt(k))) {
                            ++k;
                        }
                        if (k == j) {
                            return false;
                        }
                        try {
                            int n = Integer.parseInt(body.substring(j, k));
                            if (m != n) {
                                return false;
                            }
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                        j = k;
                    }
                    if ((close = body.indexOf(125, j)) < 0) {
                        return false;
                    }
                    idx = close;
                }
            }
            ++idx;
        }
        return true;
    }

    public @Nullable OnigResult search(OnigString str, int startPosition) {
        if (this.hasGAnchor) {
            return this.search(str.bytesUTF8, startPosition, str.bytesCount);
        }
        OnigResult lastSearchResult0 = this.lastSearchResult;
        if (this.lastSearchString == str && this.lastSearchPosition <= startPosition && (lastSearchResult0 == null || lastSearchResult0.locationAt(0) >= startPosition)) {
            return lastSearchResult0;
        }
        this.lastSearchString = str;
        this.lastSearchPosition = startPosition;
        this.lastSearchResult = this.search(str.bytesUTF8, startPosition, str.bytesCount);
        return this.lastSearchResult;
    }

    private @Nullable OnigResult search(byte[] data, int startPosition, int end) {
        Matcher matcher = this.regex.matcher(data);
        int status = matcher.search(startPosition, end, 0);
        if (status != -1) {
            Region region = matcher.getEagerRegion();
            return new OnigResult(region, -1);
        }
        return null;
    }

    public String pattern() {
        return this.pattern;
    }

    public String toString() {
        return StringUtils.toString(this, sb -> sb.append("pattern=").append(this.pattern));
    }
}

