/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.tm4e.core.internal.grammar.ScopeStack;
import org.eclipse.tm4e.core.internal.theme.FontStyle;
import org.eclipse.tm4e.core.internal.theme.Style;
import org.eclipse.tm4e.core.internal.theme.StyleAttributes;
import org.eclipse.tm4e.core.internal.theme.Theme;
import org.eclipse.tm4e.core.internal.theme.raw.IRawTheme;
import org.eclipse.tm4e.core.internal.theme.raw.RawThemeReader;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.registry.IThemeSource;
import org.eclipse.tm4e.core.theme.IStyle;
import org.eclipse.tm4e.core.theme.RGB;
import org.eclipse.tm4e.ui.internal.themes.AbstractTokenProvider;
import org.eclipse.tm4e.ui.themes.ColorManager;

public class TMThemeTokenProvider
extends AbstractTokenProvider {
    private final Theme theme;
    private final List<String> colors;

    public TMThemeTokenProvider(IThemeSource.ContentType contentType, InputStream in) throws Exception {
        IRawTheme rawTheme = RawThemeReader.readTheme((IThemeSource)IThemeSource.fromString((IThemeSource.ContentType)contentType, (String)new String(in.readAllBytes(), StandardCharsets.UTF_8)));
        this.theme = Theme.createFromRawTheme((IRawTheme)rawTheme, null);
        this.colors = this.theme.getColorMap();
    }

    @Override
    protected @Nullable IStyle getBestStyle(String textMateTokenType) {
        StyleAttributes styleAttrs = null;
        while (styleAttrs == null) {
            styleAttrs = this.theme.match(ScopeStack.from((String)textMateTokenType));
            if (styleAttrs != null && !styleAttrs.equals((Object)StyleAttributes.NO_STYLE)) continue;
            styleAttrs = null;
            int dotIdx = textMateTokenType.indexOf(46);
            if (dotIdx == -1) break;
            textMateTokenType = textMateTokenType.substring(dotIdx + 1);
        }
        if (styleAttrs != null) {
            Style style = new Style();
            if (styleAttrs.foregroundId > 0) {
                style.setColor(RGB.fromHex((String)this.colors.get(styleAttrs.foregroundId)));
            }
            if (styleAttrs.backgroundId > 0) {
                style.setBackgroundColor(RGB.fromHex((String)this.colors.get(styleAttrs.backgroundId)));
            }
            if (styleAttrs.fontStyle > 0) {
                style.setBold(FontStyle.isBold((int)styleAttrs.fontStyle));
                style.setItalic(FontStyle.isItalic((int)styleAttrs.fontStyle));
                style.setUnderline(FontStyle.isUnderline((int)styleAttrs.fontStyle));
                style.setStrikeThrough(FontStyle.isStrikethrough((int)styleAttrs.fontStyle));
            }
            return style;
        }
        return null;
    }

    protected @Nullable Color getEditorColor(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            RGB rgb;
            String name = stringArray[n2];
            String colorHexCode = (String)NullSafetyHelper.castNullable((Object)((String)this.theme.getEditorColors().get(name)));
            if (colorHexCode != null && (rgb = RGB.fromHex((String)colorHexCode)) != null) {
                return ColorManager.getInstance().getColor(rgb);
            }
            ++n2;
        }
        return null;
    }

    @Override
    public @Nullable Color getEditorForeground() {
        return this.getEditorColor("foreground", "editor.foreground");
    }

    @Override
    public @Nullable Color getEditorBackground() {
        return this.getEditorColor("background", "editor.background");
    }

    @Override
    public @Nullable Color getEditorSelectionForeground() {
        return this.getEditorColor("selectionForeground", "editor.selectionForeground", "selection.foreground");
    }

    @Override
    public @Nullable Color getEditorSelectionBackground() {
        return this.getEditorColor("selection", "editor.selectionBackground", "editor.selectionHighlightBackground", "selection.background");
    }

    @Override
    public @Nullable Color getEditorCurrentLineHighlight() {
        return this.getEditorColor("lineHighlight", "editor.lineHighlightBackground");
    }
}

