/*
 * Decompiled with CFR 0.152.
 */
package samples.ui.propertypages;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import samples.RSESamplesPlugin;
import samples.RSESamplesResources;

public class FolderInfoPropertyPage
extends SystemBasePropertyPage
implements SelectionListener {
    private Label sizeLabel;
    private Label filesLabel;
    private Label foldersLabel;
    private Button stopButton;
    private int totalSize = 0;
    private int totalFolders = 0;
    private int totalFiles = 0;
    private boolean stopped = false;
    private Thread workerThread;
    private Runnable guiUpdater;

    protected Control createContentArea(Composite parent) {
        Composite composite = SystemWidgetHelpers.createComposite((Composite)parent, (int)2);
        this.sizeLabel = SystemWidgetHelpers.createLabeledLabel((Composite)composite, (String)RSESamplesResources.pp_size_label, (String)RSESamplesResources.pp_size_tooltip, (boolean)false);
        this.filesLabel = SystemWidgetHelpers.createLabeledLabel((Composite)composite, (String)RSESamplesResources.pp_files_label, (String)RSESamplesResources.pp_files_tooltip, (boolean)false);
        this.foldersLabel = SystemWidgetHelpers.createLabeledLabel((Composite)composite, (String)RSESamplesResources.pp_folders_label, (String)RSESamplesResources.pp_folders_tooltip, (boolean)false);
        this.stopButton = SystemWidgetHelpers.createPushButton((Composite)composite, null, (String)RSESamplesResources.pp_stopButton_label, (String)RSESamplesResources.pp_stopButton_tooltip);
        this.stopButton.addSelectionListener((SelectionListener)this);
        this.setValid(false);
        this.setMessage(RSESamplesPlugin.getPluginMessage("RSSG1002"));
        this.guiUpdater = new RunnableGUIClass();
        this.workerThread = new RunnableClass(this.getRemoteFile());
        this.workerThread.start();
        return composite;
    }

    public boolean performCancel() {
        this.killThread();
        return true;
    }

    public void dispose() {
        this.killThread();
        super.dispose();
    }

    private void killThread() {
        if (!this.stopped && this.workerThread.isAlive()) {
            this.stopped = true;
            try {
                this.workerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.getSource() == this.stopButton) {
            this.stopped = true;
            this.stopButton.setEnabled(false);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    private void updateGUI() {
        Display.getDefault().asyncExec(this.guiUpdater);
    }

    protected boolean verifyPageContents() {
        return true;
    }

    protected IRemoteFile getRemoteFile() {
        IAdaptable element = this.getElement();
        return (IRemoteFile)element;
    }

    private class RunnableClass
    extends Thread {
        IRemoteFile inputFolder;

        RunnableClass(IRemoteFile inputFolder) {
            this.inputFolder = inputFolder;
        }

        public void run() {
            if (FolderInfoPropertyPage.this.stopped) {
                return;
            }
            this.walkFolder(this.inputFolder);
            if (!FolderInfoPropertyPage.this.stopped) {
                FolderInfoPropertyPage.this.stopped = true;
            }
            FolderInfoPropertyPage.this.updateGUI();
        }

        private void walkFolder(IRemoteFile currFolder) {
            try {
                IRemoteFile[] folders = currFolder.getParentRemoteFileSubSystem().list(currFolder, null);
                if (folders != null && folders.length > 0) {
                    int idx = 0;
                    while (!FolderInfoPropertyPage.this.stopped && idx < folders.length) {
                        if (folders[idx].isDirectory()) {
                            FolderInfoPropertyPage folderInfoPropertyPage = FolderInfoPropertyPage.this;
                            folderInfoPropertyPage.totalFolders = folderInfoPropertyPage.totalFolders + 1;
                            this.walkFolder(folders[idx]);
                            FolderInfoPropertyPage.this.updateGUI();
                        } else {
                            FolderInfoPropertyPage folderInfoPropertyPage = FolderInfoPropertyPage.this;
                            folderInfoPropertyPage.totalFiles = folderInfoPropertyPage.totalFiles + 1;
                            FolderInfoPropertyPage folderInfoPropertyPage2 = FolderInfoPropertyPage.this;
                            folderInfoPropertyPage2.totalSize = (int)((long)folderInfoPropertyPage2.totalSize + folders[idx].getLength());
                        }
                        ++idx;
                    }
                }
            }
            catch (SystemMessageException systemMessageException) {
                // empty catch block
            }
        }
    }

    private class RunnableGUIClass
    implements Runnable {
        private RunnableGUIClass() {
        }

        public void run() {
            if (FolderInfoPropertyPage.this.stopButton.isDisposed()) {
                return;
            }
            if (FolderInfoPropertyPage.this.stopped) {
                FolderInfoPropertyPage.this.setValid(true);
                FolderInfoPropertyPage.this.stopButton.setEnabled(false);
                FolderInfoPropertyPage.this.clearMessage();
            }
            FolderInfoPropertyPage.this.sizeLabel.setText(Integer.toString(FolderInfoPropertyPage.this.totalSize));
            FolderInfoPropertyPage.this.filesLabel.setText(Integer.toString(FolderInfoPropertyPage.this.totalFiles));
            FolderInfoPropertyPage.this.foldersLabel.setText(Integer.toString(FolderInfoPropertyPage.this.totalFolders));
        }
    }
}

