/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.internal.importexport.files.IRemoteFileExportDescriptionReader;
import org.eclipse.rse.internal.importexport.files.IRemoteFileExportDescriptionWriter;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportDescriptionReader;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportDescriptionWriter;
import org.eclipse.rse.ui.SystemBasePlugin;

public class RemoteFileExportData {
    private String destination;
    private IPath containerPath;
    private boolean reviewSynchronize;
    private boolean overWriteExistingFiles;
    private boolean createDirectoryStructure;
    private boolean createSelectionOnly;
    private boolean saveSettings;
    private String descriptionFilePath;
    private List elements;

    public RemoteFileExportData() {
        this.setContainerPath(null);
        this.setDestination(null);
        this.setOverWriteExistingFiles(false);
        this.setCreateDirectoryStructure(false);
        this.setCreateSelectionOnly(true);
        this.setSaveSettings(false);
        this.setDescriptionFilePath(null);
    }

    public String getDescriptionFilePath() {
        return this.descriptionFilePath;
    }

    public IFile getDescriptionFile() {
        Path path = new Path(this.getDescriptionFilePath());
        if (path.isValidPath(path.toString()) && path.segmentCount() >= 2) {
            return SystemBasePlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    public void setDescriptionFilePath(String descriptionFilePath) {
        this.descriptionFilePath = descriptionFilePath;
    }

    public void setContainerPath(IPath location) {
        this.containerPath = location;
    }

    public IPath getContainerPath() {
        return this.containerPath;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public List getElements() {
        return this.elements;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public boolean isOverWriteExistingFiles() {
        return this.overWriteExistingFiles;
    }

    public void setOverWriteExistingFiles(boolean overWriteExistingFiles) {
        this.overWriteExistingFiles = overWriteExistingFiles;
    }

    public boolean isReviewSynchronize() {
        return this.reviewSynchronize;
    }

    public void setReviewSynchronize(boolean reviewSynchronize) {
        this.reviewSynchronize = reviewSynchronize;
    }

    public boolean isSaveSettings() {
        return this.saveSettings;
    }

    public void setSaveSettings(boolean saveSettings) {
        this.saveSettings = saveSettings;
    }

    public boolean isCreateDirectoryStructure() {
        return this.createDirectoryStructure;
    }

    public void setCreateDirectoryStructure(boolean createDirectoryStructure) {
        this.createDirectoryStructure = createDirectoryStructure;
    }

    public boolean isCreateSelectionOnly() {
        return this.createSelectionOnly;
    }

    public void setCreateSelectionOnly(boolean createSelectionOnly) {
        this.createSelectionOnly = createSelectionOnly;
    }

    public IRemoteFileExportDescriptionWriter createExportDescriptionWriter(OutputStream outputStream) {
        return new RemoteFileExportDescriptionWriter(outputStream);
    }

    public IRemoteFileExportDescriptionReader createExportDescriptionReader(InputStream inputStream) {
        return new RemoteFileExportDescriptionReader(inputStream);
    }
}

