/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.examples.daytime.subsystems;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystemConfiguration;
import org.eclipse.rse.examples.daytime.connectorservice.DaytimeConnectorService;
import org.eclipse.rse.examples.daytime.connectorservice.DaytimeConnectorServiceManager;
import org.eclipse.rse.examples.daytime.service.IDaytimeService;
import org.eclipse.rse.examples.daytime.subsystems.DaytimeSubSystem;
import org.eclipse.rse.services.IService;

public class DaytimeSubSystemConfiguration
extends SubSystemConfiguration {
    private Map fServices = new HashMap();

    public boolean supportsFilters() {
        return false;
    }

    public boolean supportsSubSystemConnect() {
        return true;
    }

    public boolean isPortEditable() {
        return false;
    }

    public boolean isFactoryFor(Class subSystemType) {
        return DaytimeSubSystem.class.equals((Object)subSystemType);
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        IConnectorService connectorService = this.getConnectorService(host);
        DaytimeSubSystem subsys = new DaytimeSubSystem(host, connectorService, this.createDaytimeService(host));
        return subsys;
    }

    public IConnectorService getConnectorService(IHost host) {
        return DaytimeConnectorServiceManager.getInstance().getConnectorService(host, IDaytimeService.class);
    }

    public void setConnectorService(IHost host, IConnectorService connectorService) {
        DaytimeConnectorServiceManager.getInstance().setConnectorService(host, IDaytimeService.class, connectorService);
    }

    public IDaytimeService createDaytimeService(IHost host) {
        DaytimeConnectorService connectorService = (DaytimeConnectorService)this.getConnectorService(host);
        return connectorService.getDaytimeService();
    }

    public final IService getService(IHost host) {
        IDaytimeService service = (IDaytimeService)this.fServices.get(host);
        if (service == null) {
            service = this.createDaytimeService(host);
            this.fServices.put(host, service);
        }
        return service;
    }

    public final Class getServiceType() {
        return IDaytimeService.class;
    }

    public Class getServiceImplType() {
        return IDaytimeService.class;
    }
}

