/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.manipulation.CodeStyleConfiguration;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.core.manipulation.ImportReferencesCollector;
import org.eclipse.jdt.core.manipulation.OrganizeImportsOperation;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JSONUtility;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.corrections.SimilarElementsRequestor;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.text.correction.SourceAssistProcessor;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public final class OrganizeImportsHandler {
    public static final String CLIENT_COMMAND_ID_CHOOSEIMPORTS = "java.action.organizeImports.chooseImports";

    public static TextEdit organizeImports(ICompilationUnit unit, Function<ImportSelection[], ImportCandidate[]> chooseImports) {
        return OrganizeImportsHandler.organizeImports(unit, chooseImports, (IProgressMonitor)new NullProgressMonitor());
    }

    public static TextEdit organizeImports(ICompilationUnit unit, Function<ImportSelection[], ImportCandidate[]> chooseImports, IProgressMonitor monitor) {
        TextEdit staticEdit;
        block5: {
            if (unit == null) {
                return null;
            }
            CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, monitor);
            if (astRoot == null) {
                return null;
            }
            OrganizeImportsOperation op = new OrganizeImportsOperation(unit, astRoot, true, false, true, (openChoices, ranges) -> {
                ArrayList<ImportSelection> selections = new ArrayList<ImportSelection>();
                int i = 0;
                while (i < openChoices.length) {
                    ImportCandidate[] candidates = (ImportCandidate[])Stream.of(openChoices[i]).map(choice -> new ImportCandidate((TypeNameMatch)choice)).toArray(ImportCandidate[]::new);
                    Range range = null;
                    try {
                        range = JDTUtils.toRange((IOpenable)unit, ranges[i].getOffset(), ranges[i].getLength());
                    }
                    catch (JavaModelException e) {
                        range = JDTUtils.newRange();
                    }
                    selections.add(new ImportSelection(candidates, range));
                    ++i;
                }
                ImportCandidate[] chosens = (ImportCandidate[])chooseImports.apply(selections.toArray(new ImportSelection[0]));
                if (chosens == null) {
                    return null;
                }
                HashMap typeMaps = new HashMap();
                Stream.of(openChoices).flatMap(x -> Arrays.stream(x)).forEach(x -> typeMaps.put(String.valueOf(x.getFullyQualifiedName()) + "@" + x.hashCode(), x));
                return (TypeNameMatch[])Stream.of(chosens).filter(chosen -> chosen != null && typeMaps.containsKey(chosen.id)).map(chosen -> (TypeNameMatch)typeMaps.get(chosen.id)).toArray(TypeNameMatch[]::new);
            });
            JobHelpers.waitForJobs("DocumentLifeCycleJobs", monitor);
            TextEdit edit = op.createTextEdit(null);
            staticEdit = OrganizeImportsHandler.wrapStaticImports(edit, astRoot, unit);
            if (staticEdit.getChildrenSize() != 0) break block5;
            return null;
        }
        try {
            return staticEdit;
        }
        catch (CoreException | OperationCanceledException e) {
            JavaLanguageServerPlugin.logException("Failed to resolve organize imports source action", e);
            return null;
        }
    }

    public static TextEdit wrapStaticImports(TextEdit edit, CompilationUnit root, ICompilationUnit unit) throws MalformedTreeException, CoreException {
        String[] favourites = PreferenceManager.getPrefs(unit.getResource()).getJavaCompletionFavoriteMembers();
        if (favourites.length == 0) {
            return edit;
        }
        IJavaProject project = unit.getJavaProject();
        if (JavaModelUtil.is50OrHigher((IJavaProject)project)) {
            ArrayList typeReferences = new ArrayList();
            ArrayList staticReferences = new ArrayList();
            ImportReferencesCollector.collect((ASTNode)root, (IJavaProject)project, null, typeReferences, staticReferences);
            if (staticReferences.isEmpty()) {
                return edit;
            }
            ImportRewrite importRewrite = CodeStyleConfiguration.createImportRewrite((CompilationUnit)root, (boolean)true);
            AST ast = root.getAST();
            ASTRewrite astRewrite = ASTRewrite.create((AST)ast);
            for (SimpleName node : staticReferences) {
                OrganizeImportsHandler.addImports(root, unit, favourites, importRewrite, ast, astRewrite, node, true);
                OrganizeImportsHandler.addImports(root, unit, favourites, importRewrite, ast, astRewrite, node, false);
            }
            TextEdit staticEdit = importRewrite.rewriteImports(null);
            if (staticEdit != null && staticEdit.getChildrenSize() > 0) {
                TextEdit firstEdit;
                TextEdit firstStatic;
                TextEdit last;
                TextEdit lastStatic = staticEdit.getChildren()[staticEdit.getChildrenSize() - 1];
                if (lastStatic instanceof DeleteEdit && edit.getChildrenSize() > 0 && (last = edit.getChildren()[edit.getChildrenSize() - 1]) instanceof DeleteEdit && lastStatic.getOffset() == last.getOffset() && lastStatic.getLength() == last.getLength()) {
                    edit.removeChild(last);
                }
                if ((firstStatic = staticEdit.getChildren()[0]) instanceof InsertEdit && edit.getChildrenSize() > 0 && (firstEdit = edit.getChildren()[0]) instanceof InsertEdit && OrganizeImportsHandler.areEqual((InsertEdit)firstEdit, (InsertEdit)firstStatic)) {
                    edit.removeChild(firstEdit);
                }
                try {
                    staticEdit.addChild(edit);
                    return staticEdit;
                }
                catch (MalformedTreeException e) {
                    JavaLanguageServerPlugin.logException("Failed to resolve static organize imports source action", e);
                }
            }
        }
        return edit;
    }

    private static boolean areEqual(InsertEdit edit1, InsertEdit edit2) {
        if (edit1 != null && edit2 != null) {
            return edit1.getOffset() == edit2.getOffset() && edit1.getLength() == edit2.getLength() && edit1.getText().equals(edit2.getText());
        }
        return false;
    }

    private static void addImports(CompilationUnit root, ICompilationUnit unit, String[] favourites, ImportRewrite importRewrite, AST ast, ASTRewrite astRewrite, SimpleName node, boolean isMethod) throws JavaModelException {
        String name = node.getIdentifier();
        String[] imports = SimilarElementsRequestor.getStaticImportFavorites(unit, name, isMethod, favourites);
        if (imports.length > 1) {
            return;
        }
        int i = 0;
        while (i < imports.length) {
            String curr = imports[i];
            String qualifiedTypeName = Signature.getQualifier((String)curr);
            String res = importRewrite.addStaticImport(qualifiedTypeName, name, isMethod, (ImportRewrite.ImportRewriteContext)new ContextSensitiveImportRewriteContext(root, node.getStartPosition(), importRewrite));
            int dot = res.lastIndexOf(46);
            if (dot != -1) {
                String usedTypeName = importRewrite.addImport(qualifiedTypeName);
                QualifiedName newName = ast.newQualifiedName(ast.newName(usedTypeName), ast.newSimpleName(name));
                astRewrite.replace((ASTNode)node, (ASTNode)newName, null);
            }
            ++i;
        }
    }

    public static WorkspaceEdit organizeImports(JavaClientConnection connection, CodeActionParams params, IProgressMonitor monitor) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(params.getTextDocument().getUri());
        if (unit == null) {
            return null;
        }
        TextEdit edit = OrganizeImportsHandler.organizeImports(unit, (ImportSelection[] selections) -> {
            Object commandResult = connection.executeClientCommand(CLIENT_COMMAND_ID_CHOOSEIMPORTS, uri, selections);
            String json = commandResult == null ? null : new Gson().toJson(commandResult);
            return JSONUtility.toModel(json, ImportCandidate[].class);
        }, monitor);
        return SourceAssistProcessor.convertToWorkspaceEdit(unit, edit);
    }

    public static class ImportCandidate {
        public String fullyQualifiedName;
        public String id;

        public ImportCandidate() {
        }

        public ImportCandidate(TypeNameMatch typeMatch) {
            this.fullyQualifiedName = typeMatch.getFullyQualifiedName();
            this.id = String.valueOf(typeMatch.getFullyQualifiedName()) + "@" + typeMatch.hashCode();
        }
    }

    public static class ImportSelection {
        public ImportCandidate[] candidates;
        public Range range;

        public ImportSelection(ImportCandidate[] candidates, Range range) {
            this.candidates = candidates;
            this.range = range;
        }
    }
}

