/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.util.ArrayDeque;
import java.util.Arrays;
import sun.java2d.marlin.MarlinConst;
import sun.java2d.marlin.MarlinUtils;

final class ByteArrayCache
implements MarlinConst {
    private final int arraySize;
    private final ArrayDeque<byte[]> byteArrays;
    private int getOp = 0;
    private int createOp = 0;
    private int returnOp = 0;

    void dumpStats() {
        if (this.getOp > 0) {
            MarlinUtils.logInfo("ByteArrayCache[" + this.arraySize + "]: get: " + this.getOp + " created: " + this.createOp + " - returned: " + this.returnOp + " :: cache size: " + this.byteArrays.size());
        }
    }

    ByteArrayCache(int n) {
        this.arraySize = n;
        this.byteArrays = new ArrayDeque(6);
    }

    byte[] getArray() {
        byte[] byArray;
        if (doStats) {
            ++this.getOp;
        }
        if ((byArray = this.byteArrays.pollLast()) != null) {
            return byArray;
        }
        if (doStats) {
            ++this.createOp;
        }
        return new byte[this.arraySize];
    }

    void putDirtyArray(byte[] byArray, int n) {
        if (n != this.arraySize) {
            if (doChecks) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + n);
            }
            return;
        }
        if (doStats) {
            ++this.returnOp;
        }
        this.byteArrays.addLast(byArray);
    }

    void putArray(byte[] byArray, int n, int n2, int n3) {
        if (n != this.arraySize) {
            if (doChecks) {
                MarlinUtils.logInfo("ArrayCache: bad length = " + n);
            }
            return;
        }
        if (doStats) {
            ++this.returnOp;
        }
        ByteArrayCache.fill(byArray, n2, n3, (byte)0);
        this.byteArrays.addLast(byArray);
    }

    static void fill(byte[] byArray, int n, int n2, byte by) {
        if (n2 != 0) {
            Arrays.fill(byArray, n, n2, by);
        }
        if (doChecks) {
            ByteArrayCache.check(byArray, n, n2, by);
        }
    }

    static void check(byte[] byArray, int n, int n2, byte by) {
        if (doChecks) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == by) continue;
                MarlinUtils.logException("Invalid value at: " + i + " = " + byArray[i] + " from: " + n + " to: " + n2 + "\n" + Arrays.toString(byArray), new Throwable());
                Arrays.fill(byArray, by);
                return;
            }
        }
    }
}

