/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.eu;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_eu extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Moscow = new String[] {
               "Moskuko ordu estandarra",
               "MST",
               "Moskuko udako ordua",
               "MST",
               "Moskuko ordua",
               "MT",
            };
        final String[] Omsk = new String[] {
               "Omskeko ordu estandarra",
               "OST",
               "Omskeko udako ordua",
               "OST",
               "Omskeko ordua",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii Aleuteko ordu estandarra",
               "HAST",
               "Hawaii Aleuteko urte-sasoiko ordua",
               "HADT",
               "Hawaii Aleuteko ordua",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "Sakhalingo ordu estandarra",
               "SST",
               "Sakhalingo udako ordua",
               "SST",
               "Sakhalingo ordua",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Yakutskeko ordu estandarra",
               "YST",
               "Yakutskeko udako ordua",
               "YST",
               "Yakutskeko ordua",
               "YT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Kazakhstan ekialdeko ordua",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostokeko ordu estandarra",
               "VST",
               "Vladivostokeko udako ordua",
               "VST",
               "Vladivostokeko ordua",
               "VT",
            };
        final String[] Europe_Western = new String[] {
               "Western European Standard Time",
               "WET",
               "Western European Summer Time",
               "WEST",
               "Western European Time",
               "WET",
            };
        final String[] Brasilia = new String[] {
               "Brasiliako ordu estandarra",
               "BST",
               "Brasiliako udako ordua",
               "BST",
               "Brasiliako ordua",
               "BT",
            };
        final String[] Hovd = new String[] {
               "Hovdeko ordu estandarra",
               "HST",
               "Hovdeko udako ordua",
               "HST",
               "Hovdeko ordua",
               "HT",
            };
        final String[] Indonesia_Western = new String[] {
               "Indonesia mendebaldeko ordua",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Amazon = new String[] {
               "Amazoniako ordu estandarra",
               "AST",
               "Amazoniako urte-sasoiko ordua",
               "AST",
               "Amazoniako ordua",
               "AT",
            };
        final String[] Mongolia = new String[] {
               "Ulan Batorgo ordu estandarra",
               "UBST",
               "Ulan Batorgo udako ordua",
               "UBST",
               "Ulan Batorgo ordua",
               "UBT",
            };
        final String[] Indonesia_Central = new String[] {
               "Indonesia erdialdeko ordua",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] America_Pacific = new String[] {
               "Pazifikoko ordu estandarra",
               "PST",
               "Pazifikoko urte-sasoiko ordua",
               "PDT",
               "Pazifikoko ordua",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Argentina mendebaldeko ordu estandarra",
               "WAST",
               "Argentina mendebaldeko udako ordua",
               "WAST",
               "Argentina mendebaldeko ordua",
               "WAT",
            };
        final String[] Newfoundland = new String[] {
               "Ternuako ordu estandarra",
               "NST",
               "Ternuako urte-sasoiko ordua",
               "NDT",
               "Ternuako ordua",
               "NT",
            };
        final String[] Volgograd = new String[] {
               "Belgradeko ordu estandarra",
               "VST",
               "Belgradeko udako ordua",
               "VST",
               "Belgradeko ordua",
               "VT",
            };
        final String[] America_Central = new String[] {
               "Erdialdeko ordu estandarra",
               "CST",
               "Erdialdeko urte-sasoiko ordua",
               "CDT",
               "Erdialdeko ordua",
               "CT",
            };
        final String[] Argentina = new String[] {
               "Argentinako ordu estandarra",
               "AST",
               "Argentinako udako ordua",
               "AST",
               "Argentinako ordua",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburgeko ordu estandarra",
               "YST",
               "Yekaterinburgeko udako ordua",
               "YST",
               "Yekaterinburgeko ordua",
               "YT",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howeko ordu estandarra",
               "LHST",
               "Lord Howeko urte-sasoiko ordua",
               "LHDT",
               "Lord Howeko ordua",
               "LHT",
            };
        final String[] Macquarie = new String[] {
               "Macquarieko ordua",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Australia ekialdeko ordu estandarra",
               "AEST",
               "Australia ekialdeko urte-sasoiko ordua",
               "AEDT",
               "Australia ekialdeko ordua",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutskeko ordu estandarra",
               "IST",
               "Irkutskeko udako ordua",
               "IST",
               "Irkutskeko ordua",
               "IT",
            };
        final String[] Choibalsan = new String[] {
               "Choibalsango ordu estandarra",
               "CST",
               "Choibalsango udako ordua",
               "CST",
               "Choibalsango ordua",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Kazakhstan mendebaldeko ordua",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] America_Eastern = new String[] {
               "Ekialdeko ordu estandarra",
               "EST",
               "Ekialdeko urte-sasoiko ordua",
               "EDT",
               "Ekialdeko ordua",
               "ET",
            };
        final String[] Australia_Western = new String[] {
               "Australia mendebaldeko ordu estandarra",
               "AWST",
               "Australia mendebaldeko urte-sasoiko ordua",
               "AWDT",
               "Australia mendebaldeko ordua",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Australia erdialdeko mendebaldeko ordu estandarra",
               "ACWST",
               "Australia erdialdeko mendebaldeko urte-sasoiko ordua",
               "ACWDT",
               "Australia erdialdeko mendebaldeko ordua",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarskeko ordu estandarra",
               "KST",
               "Krasnoyarskeko udako ordua",
               "KST",
               "Krasnoyarskeko ordua",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Indonesia ekialdeko ordua",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronhako ordu estandarra",
               "FNST",
               "Fernando de Noronhako udako ordua",
               "FNST",
               "Fernando de Noronhako ordua",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirskeko ordu estandarra",
               "NST",
               "Novosibirskeko udako ordua",
               "NST",
               "Novosibirskeko ordua",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Mendi Harritsuetako ordu estandarra",
               "MST",
               "Mendi Harritsuetako urte-sasoiko ordua",
               "MDT",
               "Mendiko ordua",
               "MT",
            };
        final String[] Europe_Central = new String[] {
               "Central European Standard Time",
               "CET",
               "Central European Summer Time",
               "CEST",
               "Central European Time",
               "CET",
            };
        final String[] Alaska = new String[] {
               "Alaskako ordu estandarra",
               "AKST",
               "Alaskako urte-sasoiko ordua",
               "AKDT",
               "Alaskako ordua",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "Australia erdialdeko ordu estandarra",
               "ACST",
               "Australia erdialdeko urte-sasoiko ordua",
               "ACDT",
               "Australia erdialdeko ordua",
               "CAT",
            };
        final String[] Europe_Eastern = new String[] {
               "Eastern European Standard Time",
               "EET",
               "Eastern European Summer Time",
               "EEST",
               "Eastern European Time",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Atlantikoko ordu estandarra",
               "AST",
               "Atlantikoko urte-sasoiko ordua",
               "ADT",
               "Atlantikoko ordua",
               "AT",
            };
        final String[] Magadan = new String[] {
               "Magadako ordu estandarra",
               "MST",
               "Magadango udako ordua",
               "MST",
               "Magadako ordua",
               "MT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Europe/Bucharest", Europe_Eastern },
            { "Europe/Samara", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Zurich", Europe_Central },
            { "America/Resolute", America_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Danmarkshavn", GMT },
            { "Europe/Dublin", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "Europe/Copenhagen", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "America/Cayman", America_Eastern },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Europe/Berlin", Europe_Central },
            { "Asia/Omsk", Omsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Asia/Choibalsan", Choibalsan },
            { "Africa/Tunis", Europe_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Europe/Jersey", GMT },
            { "America/Thunder_Bay", America_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Africa/Sao_Tome", GMT },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "America/Tortola", Atlantic },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Damascus", Europe_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Nome", Alaska },
            { "America/Moncton", Atlantic },
            { "Atlantic/Faeroe", Europe_Western },
            { "America/Maceio", Brasilia },
            { "America/Rio_Branco", Amazon },
            { "Africa/Dakar", GMT },
            { "Europe/Podgorica", Europe_Central },
            { "America/Belize", America_Central },
            { "America/Vancouver", America_Pacific },
            { "America/Cuiaba", Amazon },
            { "Atlantic/Canary", Europe_Western },
            { "America/Rankin_Inlet", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Irkutsk", Irkutsk },
            { "Africa/Accra", GMT },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Metlakatla", America_Pacific },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Africa/Bissau", GMT },
            { "America/Jamaica", America_Eastern },
            { "Africa/Abidjan", GMT },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Luxembourg", Europe_Central },
            { "Africa/Banjul", GMT },
            { "Asia/Makassar", Indonesia_Central },
            { "Australia/Currie", Australia_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Jujuy", Argentina },
            { "Europe/Rome", Europe_Central },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/San_Marino", Europe_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Juneau", Alaska },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Africa/Conakry", GMT },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/St_Thomas", Atlantic },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Minsk", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Edmonton", America_Mountain },
            { "America/Santo_Domingo", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "Australia/Darwin", Australia_Central },
            { "MST7MDT", America_Mountain },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/St_Barthelemy", Atlantic },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Europe/Zagreb", Europe_Central },
            { "America/Eirunepe", Amazon },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
            { "Atlantic/Madeira", Europe_Western },
        };
        return data;
    }
}
