/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.repository.model;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.repository.RepositoryTreeViewer;
import org.eclipse.team.svn.ui.repository.model.IDataTreeNode;
import org.eclipse.team.svn.ui.repository.model.IParentTreeNode;
import org.eclipse.team.svn.ui.repository.model.IResourceTreeNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryFictiveNode;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.repository.model.RepositoryPending;
import org.eclipse.team.svn.ui.repository.model.RepositoryResource;
import org.eclipse.team.svn.ui.repository.model.RepositoryRevisions;
import org.eclipse.team.svn.ui.repository.model.RepositoryRoot;

public class RepositoryLocation
extends RepositoryFictiveNode
implements IParentTreeNode,
IDataTreeNode,
IResourceTreeNode {
    protected IRepositoryLocation location;
    protected Object[] children;
    protected RepositoryFolder locationRoot;

    public RepositoryLocation(IRepositoryLocation location) {
        this.location = location;
        this.refresh();
    }

    public void setViewer(RepositoryTreeViewer repositoryTree) {
        this.locationRoot.setViewer(repositoryTree);
    }

    public RepositoryResource getResourceWrapper() {
        return this.locationRoot;
    }

    public IRepositoryResource getRepositoryResource() {
        return this.location.getRoot();
    }

    public void refresh() {
        this.children = null;
        if (this.locationRoot == null || !this.locationRoot.getRepositoryResource().getUrl().equals(this.location.getUrl())) {
            this.locationRoot = new RepositoryFolder(null, (IRepositoryResource)this.location.getRoot()){

                protected RepositoryResource.RefreshOperation getRefreshOperation(RepositoryTreeViewer viewer) {
                    return new RepositoryResource.RefreshOperation(this, viewer){

                        protected void runImpl(IProgressMonitor monitor) throws Exception {
                            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                                this.viewer.refresh(RepositoryLocation.this, null, false);
                            }
                        }
                    };
                }
            };
        } else {
            this.locationRoot.refresh();
        }
    }

    public IRepositoryLocation getRepositoryLocation() {
        return this.location;
    }

    public Object getData() {
        return this.location;
    }

    public String getLabel(Object o) {
        return this.location.getLabel();
    }

    public boolean hasChildren() {
        return true;
    }

    public Object[] getChildren(Object o) {
        if (this.children == null) {
            ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(this.locationRoot.getChildren(o)));
            if (list.size() > 0 && list.get(0) instanceof RepositoryPending) {
                list.add(new RepositoryRevisions(this.location));
                return list.toArray();
            }
            list.add(new RepositoryRoot(null, (IRepositoryResource)this.location.getRepositoryRoot()));
            list.add(new RepositoryRevisions(this.location));
            this.children = list.toArray();
        }
        return this.children;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return SVNTeamUIPlugin.instance().getImageDescriptor("icons/objects/repository.gif");
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof RepositoryLocation) {
            return ((RepositoryLocation)obj).location.equals(this.location);
        }
        return super.equals(obj);
    }
}

