/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.utility;

import org.eclipse.team.svn.ui.SVNTeamUIPlugin;

public class InputHistory {
    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_DOUBLE = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_INT = 3;
    public static final int TYPE_LONG = 4;
    public static final int TYPE_STRING = 5;
    protected static final String HISTORY_NAME_BASE = "history.";
    protected String name;
    protected int type;
    protected Object value;

    public InputHistory(String name, int type, Object defaultValue) {
        this.name = name;
        this.type = type;
        this.loadHistoryValue(defaultValue);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void clear() {
        this.value = null;
        this.saveHistoryValue();
    }

    public void setValue(Object value) {
        this.value = value;
        this.saveHistoryValue();
    }

    protected void loadHistoryValue(Object defaultValue) {
        String fullName = HISTORY_NAME_BASE + this.name;
        switch (this.type) {
            case 0: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setDefault(fullName, defaultValue == null ? false : (Boolean)defaultValue);
                this.value = SVNTeamUIPlugin.instance().getPreferenceStore().getBoolean(fullName);
                break;
            }
            case 1: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setDefault(fullName, defaultValue == null ? 0.0 : (Double)defaultValue);
                this.value = SVNTeamUIPlugin.instance().getPreferenceStore().getDouble(fullName);
                break;
            }
            case 2: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setDefault(fullName, defaultValue == null ? 0.0f : ((Float)defaultValue).floatValue());
                this.value = Float.valueOf(SVNTeamUIPlugin.instance().getPreferenceStore().getFloat(fullName));
                break;
            }
            case 3: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setDefault(fullName, defaultValue == null ? 0 : (Integer)defaultValue);
                this.value = SVNTeamUIPlugin.instance().getPreferenceStore().getInt(fullName);
                break;
            }
            case 4: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setDefault(fullName, defaultValue == null ? 0L : (Long)defaultValue);
                this.value = SVNTeamUIPlugin.instance().getPreferenceStore().getLong(fullName);
                break;
            }
            default: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setDefault(fullName, defaultValue == null ? "" : (String)defaultValue);
                this.value = SVNTeamUIPlugin.instance().getPreferenceStore().getString(fullName);
            }
        }
    }

    protected void saveHistoryValue() {
        Object value = this.value;
        String fullName = HISTORY_NAME_BASE + this.name;
        switch (this.type) {
            case 0: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setValue(fullName, value == null ? false : (Boolean)value);
                break;
            }
            case 1: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setValue(fullName, value == null ? 0.0 : (Double)value);
                break;
            }
            case 2: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setValue(fullName, value == null ? 0.0f : ((Float)value).floatValue());
                break;
            }
            case 3: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setValue(fullName, value == null ? 0 : (Integer)value);
                break;
            }
            case 4: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setValue(fullName, value == null ? 0L : (Long)value);
                break;
            }
            default: {
                SVNTeamUIPlugin.instance().getPreferenceStore().setValue(fullName, value == null ? "" : (String)value);
            }
        }
    }
}

